/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class ObjectBinary {
    private ObjectBinary() {
    }

    public static final void encode(OutputStream buf, Object o) throws Exception {
        ObjectBinary.encodeObject(buf, o);
    }

    public static final Object decode(byte[] b) throws Exception {
        return ObjectBinary.decode(b, 0, b.length);
    }

    public static final Object decode(byte[] b, int off, int len) throws Exception {
        int[] p = new int[]{off};
        return ObjectBinary.decodeObject(p, b, len);
    }

    public static final Object decodeBinary(int[] outOff, byte[] b, int len) throws Exception {
        return ObjectBinary.decodeObject(outOff, b, len);
    }

    public static final void byte1(OutputStream buf, int b) throws Exception {
        buf.write(b & 0xFF);
    }

    public static final void byte2(OutputStream buf, int b) throws Exception {
        buf.write(new byte[]{(byte)((b & 0xFF00) >> 8), (byte)(b & 0xFF)});
    }

    public static final void byte4(OutputStream buf, int b) throws Exception {
        int bit = ObjectBinary.nlzs(b);
        int src = (bit >> 3) + (bit & 1 | bit >> 1 & 1 | bit >> 2 & 1);
        bit += 2;
        if ((bit = (bit >> 3) + (bit & 1 | bit >> 1 & 1 | bit >> 2 & 1)) == src) {
            switch (bit) {
                case 1: {
                    buf.write(new byte[]{(byte)(b & 0xFF)});
                    return;
                }
                case 2: {
                    buf.write(new byte[]{(byte)(0x40 | (b & 0xFF00) >> 8), (byte)(b & 0xFF)});
                    return;
                }
                case 3: {
                    buf.write(new byte[]{(byte)(0x80 | (b & 0xFF0000) >> 16), (byte)((b & 0xFF00) >> 8), (byte)(b & 0xFF)});
                    return;
                }
                case 4: {
                    buf.write(new byte[]{(byte)(0xC0 | (b & 0xFF000000) >> 24), (byte)((b & 0xFF0000) >> 16), (byte)((b & 0xFF00) >> 8), (byte)(b & 0xFF)});
                    return;
                }
            }
        }
        switch (src) {
            case 0: 
            case 1: {
                buf.write(new byte[]{0, (byte)(b & 0xFF)});
                return;
            }
            case 2: {
                buf.write(new byte[]{64, (byte)((b & 0xFF00) >> 8), (byte)(b & 0xFF)});
                return;
            }
            case 3: {
                buf.write(new byte[]{-128, (byte)((b & 0xFF0000) >> 16), (byte)((b & 0xFF00) >> 8), (byte)(b & 0xFF)});
                return;
            }
            case 4: {
                buf.write(new byte[]{-64, (byte)((b & 0xFF000000) >> 24), (byte)((b & 0xFF0000) >> 16), (byte)((b & 0xFF00) >> 8), (byte)(b & 0xFF)});
                return;
            }
        }
    }

    public static final void byte8(OutputStream buf, long b) throws Exception {
        int bit = ObjectBinary.nlzs(b);
        int src = (bit >> 3) + (bit & 1 | bit >> 1 & 1 | bit >> 2 & 1);
        bit += 3;
        if ((bit = (bit >> 3) + (bit & 1 | bit >> 1 & 1 | bit >> 2 & 1)) == src) {
            switch (bit) {
                case 1: {
                    buf.write(new byte[]{(byte)(b & 0xFFL)});
                    return;
                }
                case 2: {
                    buf.write(new byte[]{(byte)(0x20L | (b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                    return;
                }
                case 3: {
                    buf.write(new byte[]{(byte)(0x40L | (b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                    return;
                }
                case 4: {
                    buf.write(new byte[]{(byte)(0x60L | (b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                }
                case 5: {
                    buf.write(new byte[]{(byte)(0x80L | (b & 0xFF00000000L) >> 32), (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                    return;
                }
                case 6: {
                    buf.write(new byte[]{(byte)(0xA0L | (b & 0xFF0000000000L) >> 40), (byte)((b & 0xFF00000000L) >> 32), (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                    return;
                }
                case 7: {
                    buf.write(new byte[]{(byte)(0xC0L | (b & 0xFF000000000000L) >> 48), (byte)((b & 0xFF0000000000L) >> 40), (byte)((b & 0xFF00000000L) >> 32), (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                    return;
                }
                case 8: {
                    buf.write(new byte[]{(byte)(0xE0L | (b & 0xFF00000000000000L) >> 56), (byte)((b & 0xFF000000000000L) >> 48), (byte)((b & 0xFF0000000000L) >> 40), (byte)((b & 0xFF00000000L) >> 32), (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                    return;
                }
            }
        }
        switch (src) {
            case 0: 
            case 1: {
                buf.write(new byte[]{0, (byte)(b & 0xFFL)});
                return;
            }
            case 2: {
                buf.write(new byte[]{32, (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                return;
            }
            case 3: {
                buf.write(new byte[]{64, (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                return;
            }
            case 4: {
                buf.write(new byte[]{96, (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                return;
            }
            case 5: {
                buf.write(new byte[]{-128, (byte)((b & 0xFF00000000L) >> 32), (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                return;
            }
            case 6: {
                buf.write(new byte[]{-96, (byte)((b & 0xFF0000000000L) >> 40), (byte)((b & 0xFF00000000L) >> 32), (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                return;
            }
            case 7: {
                buf.write(new byte[]{-64, (byte)((b & 0xFF000000000000L) >> 48), (byte)((b & 0xFF0000000000L) >> 40), (byte)((b & 0xFF00000000L) >> 32), (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                return;
            }
            case 8: {
                buf.write(new byte[]{-32, (byte)((b & 0xFF00000000000000L) >> 56), (byte)((b & 0xFF000000000000L) >> 48), (byte)((b & 0xFF0000000000L) >> 40), (byte)((b & 0xFF00000000L) >> 32), (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                return;
            }
        }
    }

    public static final int byte1Int(byte[] b, int[] off) {
        int n = off[0];
        off[0] = n + 1;
        return b[n] & 0xFF;
    }

    public static final int byte2Int(byte[] b, int[] off) {
        int n = off[0];
        off[0] = n + 1;
        int n2 = off[0];
        off[0] = n2 + 1;
        return (b[n] & 0xFF) << 8 | b[n2] & 0xFF;
    }

    public static final int byte4Int(byte[] b, int[] off) {
        int o = off[0];
        if ((b[o] & 0x3F) == 0) {
            switch (((b[o] & 0xC0) >> 6) + 1) {
                case 1: {
                    off[0] = off[0] + 2;
                    return b[o + 1] & 0xFF;
                }
                case 2: {
                    off[0] = off[0] + 3;
                    return (b[o + 1] & 0xFF) << 8 | b[o + 2] & 0xFF;
                }
                case 3: {
                    off[0] = off[0] + 4;
                    return (b[o + 1] & 0xFF) << 16 | (b[o + 2] & 0xFF) << 8 | b[o + 3] & 0xFF;
                }
                case 4: {
                    off[0] = off[0] + 5;
                    return (b[o + 1] & 0xFF) << 24 | (b[o + 2] & 0xFF) << 16 | (b[o + 3] & 0xFF) << 8 | b[o + 4] & 0xFF;
                }
            }
            throw new IllegalArgumentException("\u4e0d\u6b63\u306abyte4Int\u6761\u4ef6:" + off[0]);
        }
        switch (((b[o] & 0xC0) >> 6) + 1) {
            case 1: {
                off[0] = off[0] + 1;
                return b[o] & 0x3F;
            }
            case 2: {
                off[0] = off[0] + 2;
                return (b[o] & 0x3F) << 8 | b[o + 1] & 0xFF;
            }
            case 3: {
                off[0] = off[0] + 3;
                return (b[o] & 0x3F) << 16 | (b[o + 1] & 0xFF) << 8 | b[o + 2] & 0xFF;
            }
            case 4: {
                off[0] = off[0] + 4;
                return (b[o] & 0x3F) << 24 | (b[o + 1] & 0xFF) << 16 | (b[o + 2] & 0xFF) << 8 | b[o + 3] & 0xFF;
            }
        }
        throw new IllegalArgumentException("\u4e0d\u6b63\u306abyte4Int\u6761\u4ef6:" + off[0]);
    }

    public static final long byte8Long(byte[] b, int[] off) {
        int o = off[0];
        if ((b[o] & 0x1F) == 0) {
            switch (((b[o] & 0xE0) >> 5) + 1) {
                case 1: {
                    off[0] = off[0] + 2;
                    return b[o + 1] & 0xFF;
                }
                case 2: {
                    off[0] = off[0] + 3;
                    return (b[o + 1] & 0xFF) << 8 | b[o + 2] & 0xFF;
                }
                case 3: {
                    off[0] = off[0] + 4;
                    return (b[o + 1] & 0xFF) << 16 | (b[o + 2] & 0xFF) << 8 | b[o + 3] & 0xFF;
                }
                case 4: {
                    off[0] = off[0] + 5;
                    return (b[o + 1] & 0xFF) << 24 | (b[o + 2] & 0xFF) << 16 | (b[o + 3] & 0xFF) << 8 | b[o + 4] & 0xFF;
                }
                case 5: {
                    off[0] = off[0] + 6;
                    return ((long)b[o + 1] & 0xFFL) << 32 | ((long)b[o + 2] & 0xFFL) << 24 | ((long)b[o + 3] & 0xFFL) << 16 | ((long)b[o + 4] & 0xFFL) << 8 | (long)b[o + 5] & 0xFFL;
                }
                case 6: {
                    off[0] = off[0] + 7;
                    return ((long)b[o + 1] & 0xFFL) << 40 | ((long)b[o + 2] & 0xFFL) << 32 | ((long)b[o + 3] & 0xFFL) << 24 | ((long)b[o + 4] & 0xFFL) << 16 | ((long)b[o + 5] & 0xFFL) << 8 | (long)b[o + 6] & 0xFFL;
                }
                case 7: {
                    off[0] = off[0] + 8;
                    return ((long)b[o + 1] & 0xFFL) << 48 | ((long)b[o + 2] & 0xFFL) << 40 | ((long)b[o + 3] & 0xFFL) << 32 | ((long)b[o + 4] & 0xFFL) << 24 | ((long)b[o + 5] & 0xFFL) << 16 | ((long)b[o + 6] & 0xFFL) << 8 | (long)b[o + 7] & 0xFFL;
                }
                case 8: {
                    off[0] = off[0] + 9;
                    return ((long)b[o + 1] & 0xFFL) << 56 | ((long)b[o + 2] & 0xFFL) << 48 | ((long)b[o + 3] & 0xFFL) << 40 | ((long)b[o + 4] & 0xFFL) << 32 | ((long)b[o + 5] & 0xFFL) << 24 | ((long)b[o + 6] & 0xFFL) << 16 | ((long)b[o + 7] & 0xFFL) << 8 | (long)b[o + 8] & 0xFFL;
                }
            }
            throw new IllegalArgumentException("\u4e0d\u6b63\u306abyte8Long\u6761\u4ef6:" + off[0]);
        }
        switch (((b[o] & 0xE0) >> 5) + 1) {
            case 1: {
                off[0] = off[0] + 1;
                return b[o] & 0x1F;
            }
            case 2: {
                off[0] = off[0] + 2;
                return (b[o] & 0x1F) << 8 | b[o + 1] & 0xFF;
            }
            case 3: {
                off[0] = off[0] + 3;
                return (b[o] & 0x1F) << 16 | (b[o + 1] & 0xFF) << 8 | b[o + 2] & 0xFF;
            }
            case 4: {
                off[0] = off[0] + 4;
                return (b[o] & 0x1F) << 24 | (b[o + 1] & 0xFF) << 16 | (b[o + 2] & 0xFF) << 8 | b[o + 3] & 0xFF;
            }
            case 5: {
                off[0] = off[0] + 5;
                return ((long)b[o] & 0x1FL) << 32 | ((long)b[o + 1] & 0xFFL) << 24 | ((long)b[o + 2] & 0xFFL) << 16 | ((long)b[o + 3] & 0xFFL) << 8 | (long)b[o + 4] & 0xFFL;
            }
            case 6: {
                off[0] = off[0] + 6;
                return ((long)b[o] & 0x1FL) << 40 | ((long)b[o + 1] & 0xFFL) << 32 | ((long)b[o + 2] & 0xFFL) << 24 | ((long)b[o + 3] & 0xFFL) << 16 | ((long)b[o + 4] & 0xFFL) << 8 | (long)b[o + 5] & 0xFFL;
            }
            case 7: {
                off[0] = off[0] + 7;
                return ((long)b[o] & 0x1FL) << 48 | ((long)b[o + 1] & 0xFFL) << 40 | ((long)b[o + 2] & 0xFFL) << 32 | ((long)b[o + 3] & 0xFFL) << 24 | ((long)b[o + 4] & 0xFFL) << 16 | ((long)b[o + 5] & 0xFFL) << 8 | (long)b[o + 6] & 0xFFL;
            }
            case 8: {
                off[0] = off[0] + 8;
                return ((long)b[o] & 0x1FL) << 56 | ((long)b[o + 1] & 0xFFL) << 48 | ((long)b[o + 2] & 0xFFL) << 40 | ((long)b[o + 3] & 0xFFL) << 32 | ((long)b[o + 4] & 0xFFL) << 24 | ((long)b[o + 5] & 0xFFL) << 16 | ((long)b[o + 6] & 0xFFL) << 8 | (long)b[o + 7] & 0xFFL;
            }
        }
        throw new IllegalArgumentException("\u4e0d\u6b63\u306abyte8Long\u6761\u4ef6:" + off[0]);
    }

    public static final void stringBinary(OutputStream buf, String s) throws Exception {
        byte[] b = s.getBytes("UTF8");
        ObjectBinary.byte4(buf, b.length);
        buf.write(b, 0, b.length);
    }

    public static final void serialBinary(OutputStream buf, Serializable s) throws Exception {
        byte[] b = ObjectBinary.toBinary(s);
        ObjectBinary.byte4(buf, b.length);
        buf.write(b, 0, b.length);
    }

    public static final String byteString(byte[] b, int[] pos) throws Exception {
        int len = ObjectBinary.byte4Int(b, pos);
        if (len == 0) {
            return "";
        }
        String ret = new String(b, pos[0], len, "UTF8");
        pos[0] = pos[0] + len;
        return ret;
    }

    public static final Object byteSerial(byte[] b, int[] pos) throws Exception {
        int len = ObjectBinary.byte4Int(b, pos);
        if (len == 0) {
            return null;
        }
        Serializable ret = ObjectBinary.toObject(b, pos[0], len);
        pos[0] = pos[0] + len;
        return ret;
    }

    public static final void encodeObject(OutputStream buf, Object o) throws Exception {
        if (o == null) {
            ObjectBinary.head(buf, 255);
        } else if (o instanceof String) {
            ObjectBinary.head(buf, 1);
            ObjectBinary.stringBinary(buf, (String)o);
        } else if (o instanceof Boolean) {
            ObjectBinary.head(buf, 2);
            ObjectBinary.byte1(buf, (Boolean)o != false ? 1 : 0);
        } else if (o instanceof Character) {
            ObjectBinary.head(buf, 3);
            ObjectBinary.byte2(buf, ((Character)o).charValue());
        } else if (o instanceof Number) {
            if (o instanceof Byte) {
                ObjectBinary.head(buf, 4);
                ObjectBinary.byte1(buf, ((Byte)o).byteValue());
            } else if (o instanceof Short) {
                ObjectBinary.head(buf, 5);
                ObjectBinary.byte2(buf, ((Short)o).shortValue());
            } else if (o instanceof Integer) {
                ObjectBinary.head(buf, 6);
                ObjectBinary.byte4(buf, (Integer)o);
            } else if (o instanceof Long) {
                ObjectBinary.head(buf, 7);
                ObjectBinary.byte8(buf, (Long)o);
            } else if (o instanceof Float) {
                ObjectBinary.head(buf, 8);
                ObjectBinary.byte4(buf, Float.floatToRawIntBits(((Float)o).floatValue()));
            } else if (o instanceof Double) {
                ObjectBinary.head(buf, 9);
                ObjectBinary.byte8(buf, Double.doubleToRawLongBits((Double)o));
            } else if (o instanceof AtomicInteger) {
                ObjectBinary.head(buf, 10);
                ObjectBinary.byte4(buf, ((AtomicInteger)o).get());
            } else if (o instanceof AtomicLong) {
                ObjectBinary.head(buf, 11);
                ObjectBinary.byte8(buf, ((AtomicLong)o).get());
            } else if (o instanceof BigDecimal) {
                ObjectBinary.head(buf, 12);
                ObjectBinary.stringBinary(buf, o.toString());
            } else if (o instanceof BigInteger) {
                ObjectBinary.head(buf, 13);
                ObjectBinary.stringBinary(buf, o.toString());
            }
        } else if (o instanceof java.util.Date) {
            ObjectBinary.head(buf, 14);
            if (o instanceof Date) {
                ObjectBinary.byte1(buf, 1);
            } else if (o instanceof Time) {
                ObjectBinary.byte1(buf, 2);
            } else if (o instanceof Timestamp) {
                ObjectBinary.byte1(buf, 3);
            } else {
                ObjectBinary.byte1(buf, 4);
            }
            ObjectBinary.byte8(buf, ((java.util.Date)o).getTime());
        } else if (o.getClass().isArray()) {
            if (o instanceof boolean[]) {
                ObjectBinary.head(buf, 20);
                boolean[] c = (boolean[])o;
                int len = c.length;
                ObjectBinary.byte4(buf, len);
                for (int i = 0; i < len; ++i) {
                    ObjectBinary.byte1(buf, c[i] ? 1 : 0);
                }
            } else if (o instanceof byte[]) {
                ObjectBinary.head(buf, 21);
                byte[] b = (byte[])o;
                ObjectBinary.byte4(buf, b.length);
                buf.write(b, 0, b.length);
                b = null;
            } else if (o instanceof char[]) {
                ObjectBinary.head(buf, 22);
                char[] c = (char[])o;
                int len = c.length;
                ObjectBinary.byte4(buf, len);
                for (int i = 0; i < len; ++i) {
                    ObjectBinary.byte2(buf, c[i]);
                }
            } else if (o instanceof short[]) {
                ObjectBinary.head(buf, 23);
                short[] c = (short[])o;
                int len = c.length;
                ObjectBinary.byte4(buf, len);
                for (int i = 0; i < len; ++i) {
                    ObjectBinary.byte2(buf, c[i]);
                }
            } else if (o instanceof int[]) {
                ObjectBinary.head(buf, 24);
                int[] c = (int[])o;
                int len = c.length;
                ObjectBinary.byte4(buf, len);
                for (int i = 0; i < len; ++i) {
                    ObjectBinary.byte4(buf, c[i]);
                }
            } else if (o instanceof long[]) {
                ObjectBinary.head(buf, 25);
                long[] c = (long[])o;
                int len = c.length;
                ObjectBinary.byte4(buf, len);
                for (int i = 0; i < len; ++i) {
                    ObjectBinary.byte8(buf, c[i]);
                }
            } else if (o instanceof float[]) {
                ObjectBinary.head(buf, 26);
                float[] c = (float[])o;
                int len = c.length;
                ObjectBinary.byte4(buf, len);
                for (int i = 0; i < len; ++i) {
                    ObjectBinary.byte4(buf, Float.floatToRawIntBits(c[i]));
                }
            } else if (o instanceof double[]) {
                ObjectBinary.head(buf, 27);
                double[] c = (double[])o;
                int len = c.length;
                ObjectBinary.byte4(buf, len);
                for (int i = 0; i < len; ++i) {
                    ObjectBinary.byte8(buf, Double.doubleToRawLongBits(c[i]));
                }
            } else if (o instanceof String[]) {
                ObjectBinary.head(buf, 28);
                String[] c = (String[])o;
                int len = c.length;
                ObjectBinary.byte4(buf, len);
                for (int i = 0; i < len; ++i) {
                    ObjectBinary.stringBinary(buf, c[i]);
                }
            } else {
                String s = o.getClass().getName();
                if (s.startsWith("[L")) {
                    ObjectBinary.head(buf, 50);
                    if ("[Ljava.lang.Object;".equals(s)) {
                        ObjectBinary.byte4(buf, 0);
                    } else {
                        ObjectBinary.stringBinary(buf, s.substring(2, s.length() - 1).trim());
                    }
                    int len = Array.getLength(o);
                    ObjectBinary.byte4(buf, len);
                    for (int i = 0; i < len; ++i) {
                        ObjectBinary.encodeObject(buf, Array.get(o, i));
                    }
                } else {
                    ObjectBinary.head(buf, 255);
                }
            }
        } else if (o instanceof List) {
            ObjectBinary.head(buf, 51);
            List lst = (List)o;
            int len = lst.size();
            ObjectBinary.byte4(buf, len);
            for (int i = 0; i < len; ++i) {
                ObjectBinary.encodeObject(buf, lst.get(i));
            }
        } else if (o instanceof Map) {
            ObjectBinary.head(buf, 52);
            Map map = (Map)o;
            ObjectBinary.byte4(buf, map.size());
            for (Object k : map.keySet()) {
                ObjectBinary.encodeObject(buf, k);
                ObjectBinary.encodeObject(buf, map.get(k));
            }
        } else if (o instanceof Set) {
            ObjectBinary.head(buf, 53);
            Set set = (Set)o;
            ObjectBinary.byte4(buf, set.size());
            Iterator it = set.iterator();
            while (it.hasNext()) {
                ObjectBinary.encodeObject(buf, it.next());
            }
        } else if (o instanceof Serializable) {
            ObjectBinary.head(buf, 60);
            ObjectBinary.serialBinary(buf, (Serializable)o);
        } else {
            ObjectBinary.head(buf, 255);
        }
    }

    public static final Object decodeObject(int[] pos, byte[] b, int length) throws Exception {
        if (length <= pos[0]) {
            throw new IOException("\u6307\u5b9a\u9577[" + length + "byte]\u3092\u8d8a\u3048\u3066\u3001\u51e6\u7406\u3092\u884c\u304a\u3046\u3068\u3057\u3066\u3044\u307e\u3059:" + pos[0]);
        }
        int code = ObjectBinary.byte1Int(b, pos);
        switch (code) {
            case 1: {
                return ObjectBinary.byteString(b, pos);
            }
            case 2: {
                Boolean ret = ObjectBinary.byte1Int(b, pos) == 1;
                return ret;
            }
            case 3: {
                Character ret = Character.valueOf((char)ObjectBinary.byte2Int(b, pos));
                return ret;
            }
            case 4: {
                Byte ret = (byte)ObjectBinary.byte1Int(b, pos);
                return ret;
            }
            case 5: {
                Short ret = (short)ObjectBinary.byte2Int(b, pos);
                return ret;
            }
            case 6: {
                Integer ret = ObjectBinary.byte4Int(b, pos);
                return ret;
            }
            case 7: {
                Long ret = ObjectBinary.byte8Long(b, pos);
                return ret;
            }
            case 8: {
                Float ret = Float.valueOf(Float.intBitsToFloat(ObjectBinary.byte4Int(b, pos)));
                return ret;
            }
            case 9: {
                Double ret = Double.longBitsToDouble(ObjectBinary.byte8Long(b, pos));
                return ret;
            }
            case 10: {
                AtomicInteger ret = new AtomicInteger(ObjectBinary.byte4Int(b, pos));
                return ret;
            }
            case 11: {
                AtomicLong ret = new AtomicLong(ObjectBinary.byte8Long(b, pos));
                return ret;
            }
            case 12: {
                return new BigDecimal(ObjectBinary.byteString(b, pos));
            }
            case 13: {
                return new BigInteger(ObjectBinary.byteString(b, pos));
            }
            case 14: {
                int type = ObjectBinary.byte1Int(b, pos);
                java.util.Date ret = type == 1 ? new Date(ObjectBinary.byte8Long(b, pos)) : (type == 2 ? new Time(ObjectBinary.byte8Long(b, pos)) : (type == 3 ? new Timestamp(ObjectBinary.byte8Long(b, pos)) : new java.util.Date(ObjectBinary.byte8Long(b, pos))));
                return ret;
            }
            case 20: {
                int len = ObjectBinary.byte4Int(b, pos);
                boolean[] lst = new boolean[len];
                for (int i = 0; i < len; ++i) {
                    lst[i] = ObjectBinary.byte1Int(b, pos) == 1;
                }
                return lst;
            }
            case 21: {
                int len = ObjectBinary.byte4Int(b, pos);
                byte[] lst = new byte[len];
                System.arraycopy(b, pos[0], lst, 0, len);
                pos[0] = pos[0] + len;
                return lst;
            }
            case 22: {
                int len = ObjectBinary.byte4Int(b, pos);
                char[] lst = new char[len];
                for (int i = 0; i < len; ++i) {
                    lst[i] = (char)ObjectBinary.byte2Int(b, pos);
                }
                return lst;
            }
            case 23: {
                int len = ObjectBinary.byte4Int(b, pos);
                short[] lst = new short[len];
                for (int i = 0; i < len; ++i) {
                    lst[i] = (short)ObjectBinary.byte2Int(b, pos);
                }
                return lst;
            }
            case 24: {
                int len = ObjectBinary.byte4Int(b, pos);
                int[] lst = new int[len];
                for (int i = 0; i < len; ++i) {
                    lst[i] = ObjectBinary.byte4Int(b, pos);
                }
                return lst;
            }
            case 25: {
                int len = ObjectBinary.byte4Int(b, pos);
                long[] lst = new long[len];
                for (int i = 0; i < len; ++i) {
                    lst[i] = ObjectBinary.byte8Long(b, pos);
                }
                return lst;
            }
            case 26: {
                int len = ObjectBinary.byte4Int(b, pos);
                float[] lst = new float[len];
                for (int i = 0; i < len; ++i) {
                    lst[i] = Float.intBitsToFloat(ObjectBinary.byte4Int(b, pos));
                }
                return lst;
            }
            case 27: {
                int len = ObjectBinary.byte4Int(b, pos);
                double[] lst = new double[len];
                for (int i = 0; i < len; ++i) {
                    lst[i] = Double.longBitsToDouble(ObjectBinary.byte8Long(b, pos));
                }
                return lst;
            }
            case 28: {
                int len = ObjectBinary.byte4Int(b, pos);
                String[] lst = new String[len];
                for (int i = 0; i < len; ++i) {
                    lst[i] = ObjectBinary.byteString(b, pos);
                }
                return lst;
            }
            case 50: {
                String cls = ObjectBinary.byteString(b, pos);
                int len = ObjectBinary.byte4Int(b, pos);
                Object lst = cls.length() == 0 ? new Object[len] : Array.newInstance(Class.forName(cls), len);
                for (int i = 0; i < len; ++i) {
                    Array.set(lst, i, ObjectBinary.decodeObject(pos, b, length));
                }
                return lst;
            }
            case 51: {
                int len = ObjectBinary.byte4Int(b, pos);
                ArrayList<Object> lst = new ArrayList<Object>();
                for (int i = 0; i < len; ++i) {
                    lst.add(ObjectBinary.decodeObject(pos, b, length));
                }
                return lst;
            }
            case 52: {
                int len = ObjectBinary.byte4Int(b, pos);
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                for (int i = 0; i < len; ++i) {
                    map.put(ObjectBinary.decodeObject(pos, b, length), ObjectBinary.decodeObject(pos, b, length));
                }
                return map;
            }
            case 53: {
                HashSet<Object> set = new HashSet<Object>();
                int len = ObjectBinary.byte4Int(b, pos);
                for (int i = 0; i < len; ++i) {
                    set.add(ObjectBinary.decodeObject(pos, b, length));
                }
                return set;
            }
            case 60: {
                return ObjectBinary.byteSerial(b, pos);
            }
            case 255: {
                return null;
            }
        }
        throw new IOException("\u4e0d\u660e\u306a\u30bf\u30a4\u30d7[" + code + "]\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
    }

    private static final void head(OutputStream buf, int n) throws Exception {
        ObjectBinary.byte1(buf, n);
    }

    protected static final byte[] toBinary(Serializable value) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] ret = null;
        ObjectOutputStream o = null;
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            o = new ObjectOutputStream(b);
            o.writeObject(value);
            o.flush();
            ret = b.toByteArray();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                o.close();
            }
            catch (Exception e) {}
        }
        return ret;
    }

    protected static final Serializable toObject(byte[] bin, int off, int len) throws Exception {
        if (bin == null || bin.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ObjectInputStream in = null;
        Serializable ret = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(bin, off, len));
            ret = (Serializable)in.readObject();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
            in = null;
        }
        return ret;
    }

    protected static final int nlzs(int x) {
        if (x == 0) {
            return 0;
        }
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        x = (x & 0x55555555) + (x >> 1 & 0x55555555);
        x = (x & 0x33333333) + (x >> 2 & 0x33333333);
        x = (x & 0xF0F0F0F) + (x >> 4 & 0xF0F0F0F);
        x = (x & 0xFF00FF) + (x >> 8 & 0xFF00FF);
        return (x & 0xFFFF) + (x >> 16 & 0xFFFF);
    }

    protected static final int nlzs(long x) {
        int xx = (int)((x & 0xFFFFFFFF00000000L) >> 32);
        if (ObjectBinary.nlzs(xx) == 0) {
            return ObjectBinary.nlzs((int)(x & 0xFFFFFFFFFFFFFFFFL));
        }
        return ObjectBinary.nlzs(xx) + 32;
    }
}

