/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.util;

import java.io.IOException;

public final class StringUtils {
    private StringUtils() {
    }

    public static final boolean parseBoolean(String s) throws Exception {
        if (s == null || s.length() <= 0) {
            throw new IllegalArgumentException("\u6587\u5b57\u5217\u306f\u7a7a\u3067\u3059");
        }
        if (s.length() == 4) {
            if ("true" == s || "true".equals(s)) {
                return true;
            }
        } else if (s.length() == 5 && ("false" == s || "false".equals(s))) {
            return false;
        }
        throw new IOException("Boolean\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + s);
    }

    public static final int parseInt(String num) throws Exception {
        int dot;
        int len;
        if (num == null || (len = num.length()) <= 0) {
            throw new IllegalArgumentException("\u6587\u5b57\u5217\u306f\u7a7a\u3067\u3059");
        }
        int ret = 0;
        int v = 1;
        int end = 0;
        if (num.charAt(0) == '-') {
            end = 1;
        }
        if ((dot = num.indexOf(".")) != -1) {
            len = dot;
        }
        for (int i = len - 1; i >= end; --i) {
            char c = num.charAt(i);
            if (c >= '0' && c <= '9') {
                ret += v * (c - 48);
                v *= 10;
                continue;
            }
            throw new IOException("\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + num);
        }
        if (end == 1) {
            return ret * -1;
        }
        return ret;
    }

    public static final long parseLong(String num) throws Exception {
        int dot;
        int len;
        if (num == null || (len = num.length()) <= 0) {
            throw new IllegalArgumentException("\u6587\u5b57\u5217\u306f\u7a7a\u3067\u3059");
        }
        long ret = 0L;
        long v = 1L;
        int end = 0;
        if (num.charAt(0) == '-') {
            end = 1;
        }
        if ((dot = num.indexOf(".")) != -1) {
            len = dot;
        }
        for (int i = len - 1; i >= end; --i) {
            char c = num.charAt(i);
            if (c >= '0' && c <= '9') {
                ret += v * (long)(c - 48);
                v *= 10L;
                continue;
            }
            throw new IOException("\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + num);
        }
        if (end == 1) {
            return ret * -1L;
        }
        return ret;
    }

    public static final double parseDouble(String num) throws Exception {
        char c;
        int dot;
        int len;
        if (num == null || (len = num.length()) <= 0) {
            throw new IllegalArgumentException("\u6587\u5b57\u5217\u306f\u7a7a\u3067\u3059");
        }
        double ret = 0.0;
        double v = 1.0;
        int end = 0;
        if (num.charAt(0) == '-') {
            end = 1;
        }
        if ((dot = num.indexOf(".")) == -1) {
            for (int i = len - 1; i >= end; --i) {
                char c2 = num.charAt(i);
                if (c2 >= '0' && c2 <= '9') {
                    ret += v * (double)(c2 - 48);
                    v *= 10.0;
                    continue;
                }
                throw new IOException("\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + num);
            }
            if (end == 1) {
                return ret * -1.0;
            }
            return ret;
        }
        for (int i = dot - 1; i >= end; --i) {
            c = num.charAt(i);
            if (c >= '0' && c <= '9') {
                ret += v * (double)(c - 48);
                v *= 10.0;
                continue;
            }
            throw new IOException("\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + num);
        }
        double dret = 0.0;
        v = 1.0;
        for (int i = len - 1; i > dot; --i) {
            c = num.charAt(i);
            if (c >= '0' && c <= '9') {
                dret += v * (double)(c - 48);
                v *= 10.0;
                continue;
            }
            throw new IOException("\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + num);
        }
        ret = end == 1 ? (ret + dret / v) * -1.0 : (ret += dret / v);
        return ret;
    }

    public static final String changeString(String src, String s, String d) {
        int len = src.length();
        char t = s.charAt(0);
        int lenS = s.length();
        StringBuilder buf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            if (src.charAt(i) == t) {
                int j = i;
                int k = 0;
                while (++k < lenS && ++j < len && src.charAt(j) == s.charAt(k)) {
                }
                if (k >= lenS) {
                    buf.append(d);
                    i += lenS - 1;
                    continue;
                }
                buf.append(t);
                continue;
            }
            buf.append(src.charAt(i));
        }
        return buf.toString();
    }
}

