/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.maachang.mimdb.core.MimdbConnection;
import org.maachang.mimdb.core.MimdbPreparedStatement;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.jdbc.MimdbJdbcConnection;
import org.maachang.mimdb.jdbc.MimdbJdbcParameterMetaData;
import org.maachang.mimdb.jdbc.MimdbJdbcResultSet;
import org.maachang.mimdb.jdbc.MimdbJdbcResultSetMetaData;
import org.maachang.mimdb.jdbc.MimdbJdbcStatement;

public class MimdbJdbcPreparedStatement
extends MimdbJdbcStatement
implements PreparedStatement {
    protected String name;
    protected MimdbPreparedStatement prepared = null;

    protected MimdbJdbcPreparedStatement() {
    }

    protected MimdbJdbcPreparedStatement(MimdbJdbcConnection c, MimdbConnection cc, String sql) throws SQLException {
        super(c, cc);
        MimdbPreparedStatement ps = null;
        try {
            ps = cc.getPreparedStatement(sql);
        }
        catch (RuntimeException r) {
            this.close();
            throw r;
        }
        catch (Exception e) {
            this.close();
            throw new SQLException(e);
        }
        this.prepared = ps;
    }

    @Override
    protected void finalize() throws Exception {
        this.close();
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.prepared != null) {
            this.prepared.close();
            this.prepared = null;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.check();
    }

    @Override
    public boolean execute() throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return false;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.check();
        try {
            this.prepared.setFetchSize(this.fetchSize);
            if (this.maxRows >= 0) {
                this.prepared.setLimit(this.maxRows);
                this.maxRows = -1;
            }
            MimdbResult res = this.prepared.executeQuery();
            this.nowResult = new MimdbJdbcResultSet(this, res);
            return this.nowResult;
        }
        catch (Exception e) {
            this.errorsql(e);
            return null;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return -1;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.check();
        if (this.nowResult == null || this.nowResult.isClosed()) {
            return null;
        }
        return new MimdbJdbcResultSetMetaData(this.nowResult.result);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.check();
        return new MimdbJdbcParameterMetaData(this.prepared);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.check();
        this.prepared.setParams(parameterIndex - 1, x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.check();
        if (x == null) {
            this.prepared.setParams(parameterIndex - 1, null);
        } else {
            this.prepared.setParams(parameterIndex - 1, x.toString());
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.check();
        this.prepared.setParams(parameterIndex - 1, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.check();
        this.prepared.setParams(parameterIndex - 1, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.check();
        if (x == null) {
            this.prepared.setParams(parameterIndex - 1, null);
        } else {
            this.prepared.setParams(parameterIndex - 1, x);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.check();
        if (x == null) {
            this.prepared.setParams(parameterIndex - 1, null);
        } else {
            if (cal != null) {
                cal.setTime(x);
                x = new Date(cal.getTime().getTime());
            }
            this.prepared.setParams(parameterIndex - 1, x);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.check();
        this.prepared.setParams(parameterIndex - 1, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.check();
        this.prepared.setParams(parameterIndex - 1, Float.valueOf(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.check();
        this.prepared.setParams(parameterIndex - 1, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.check();
        this.prepared.setParams(parameterIndex - 1, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.check();
        if (value == null) {
            this.prepared.setParams(parameterIndex - 1, null);
        } else {
            this.prepared.setParams(parameterIndex - 1, value);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.check();
        this.prepared.setParams(parameterIndex - 1, null);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.check();
        this.prepared.setParams(parameterIndex - 1, null);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.check();
        if (x == null) {
            this.prepared.setParams(parameterIndex - 1, null);
        } else {
            this.prepared.setParams(parameterIndex - 1, x);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.check();
        if (x == null) {
            this.prepared.setParams(parameterIndex - 1, null);
        } else {
            this.prepared.setParams(parameterIndex - 1, x);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.check();
        if (x == null) {
            this.prepared.setParams(parameterIndex - 1, null);
        } else {
            this.prepared.setParams(parameterIndex - 1, x);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.check();
        if (x == null) {
            this.prepared.setParams(parameterIndex - 1, null);
        } else {
            this.prepared.setParams(parameterIndex - 1, x);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.check();
        if (x == null) {
            this.prepared.setParams(parameterIndex - 1, null);
        } else {
            this.prepared.setParams(parameterIndex - 1, x);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.check();
        if (x == null) {
            this.prepared.setParams(parameterIndex - 1, null);
        } else {
            this.prepared.setParams(parameterIndex - 1, x);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.check();
        if (x == null) {
            this.prepared.setParams(parameterIndex - 1, null);
        } else {
            this.prepared.setParams(parameterIndex - 1, x);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.check();
        if (x == null) {
            this.prepared.setParams(parameterIndex - 1, null);
        } else {
            this.prepared.setParams(parameterIndex - 1, x);
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.check();
        if (x == null) {
            this.prepared.setParams(parameterIndex - 1, null);
        } else {
            this.prepared.setParams(parameterIndex - 1, x.toString());
        }
    }

    private final void errorsql(String msg) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc:" + this.name + " " + msg);
    }

    private final void errorsql(Exception e) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc:" + this.name, e);
    }
}

