/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbConnection;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.MimdbStatement;
import org.maachang.mimdb.jdbc.MimdbJdbcConnection;
import org.maachang.mimdb.jdbc.MimdbJdbcResultSet;

public class MimdbJdbcStatement
implements Statement {
    protected MimdbJdbcConnection base;
    protected MimdbConnection conn;
    protected MimdbJdbcResultSet nowResult;
    protected int fetchSize = 10;
    protected int maxRows = -1;

    protected MimdbJdbcStatement() {
    }

    protected MimdbJdbcStatement(MimdbJdbcConnection c, MimdbConnection cc) {
        this.base = c;
        this.conn = cc;
    }

    protected void finalize() throws Exception {
        this.close();
    }

    @Override
    public void close() throws SQLException {
        this.nowResult = null;
        this.base = null;
        this.conn = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.base == null || this.base.isClosed();
    }

    protected final void check() {
        this.base.check();
        if (this.base == null) {
            throw new MimdbException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.check();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.check();
        try {
            MimdbStatement stmt = this.conn.getStatement();
            stmt.setFetchSize(this.fetchSize);
            if (this.maxRows >= 0) {
                stmt.setLimit(this.maxRows);
                this.maxRows = -1;
            }
            MimdbResult res = stmt.executeQuery(sql);
            this.nowResult = new MimdbJdbcResultSet(this, res);
            return this.nowResult;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.check();
        return this.base;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.check();
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.check();
        return this.fetchSize;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.check();
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.check();
        if (this.maxRows <= 0) {
            return Integer.MAX_VALUE;
        }
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.check();
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.check();
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.check();
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.check();
        return this.nowResult;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.check();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.check();
        return 1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.check();
        return 1004;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.check();
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.check();
        return null;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.check();
        return false;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.check();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.check();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.check();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.check();
        if (rows <= 0) {
            rows = 1;
        }
        this.fetchSize = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.check();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.check();
        this.maxRows = max;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.check();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.check();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        this.check();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.check();
        return null;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.check();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.check();
        return false;
    }
}

