/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.server;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.QueryCompileInfo;
import org.maachang.mimdb.core.RemoteTable;
import org.maachang.mimdb.core.RemoteTableManager;
import org.maachang.mimdb.core.util.ByteArrayIO;
import org.maachang.mimdb.core.util.ObjectBinary;
import org.maachang.mimdb.core.util.jsnappy.JSnappy;
import org.maachang.mimdb.core.util.jsnappy.JSnappyBuffer;
import org.maachang.mimdb.server.ConnectionDefine;

public final class MimdbClient {
    protected static final int RECV_LENGTH = 8192;
    protected static final int SEND_LENGTH = 4096;
    protected static final int BUFFER_LENGTH = 4096;
    protected Socket socket = null;
    protected InputStream input = null;
    protected OutputStream output = null;
    private boolean closeFlag = true;
    private String addr;
    private String bindAddr;
    private int port;
    private int bindPort;
    private int timeout;
    private final ByteArrayIO buffer = new ByteArrayIO(4096);
    private byte[] work = new byte[4096];
    private int[] recvOff = new int[1];

    public MimdbClient(String addr, int port) throws Exception {
        this(addr, port, null, -1, -1);
    }

    public MimdbClient(String addr, int port, int timeout) throws Exception {
        this(addr, port, null, -1, timeout);
    }

    public MimdbClient(String addr, int port, String bindAddr, int bindPort, int timeout) throws Exception {
        if (addr == null || (addr = addr.trim()).length() <= 0 || "null".equals(addr)) {
            addr = "127.0.0.1";
        }
        if (port > 65535 || port < 0) {
            port = 3210;
        }
        if (timeout <= -1) {
            timeout = 30000;
        }
        if (bindPort > 65535 || bindPort < 0) {
            bindPort = -1;
            bindAddr = null;
        }
        this.addr = addr;
        this.port = port;
        this.bindAddr = bindAddr;
        this.bindPort = bindPort;
        this.timeout = timeout;
        this._connect();
    }

    private final void _connect() throws Exception {
        Socket s;
        this.close();
        System.setProperty("networkaddress.cache.ttl", "300");
        System.setProperty("networkaddress.cache.negative.ttl", "0");
        if (this.bindPort != -1) {
            s = new Socket();
            if (this.bindAddr != null) {
                s.bind(new InetSocketAddress(InetAddress.getByName(this.bindAddr), this.bindPort));
            } else {
                s.bind(new InetSocketAddress(this.bindPort));
            }
            s.connect(new InetSocketAddress(InetAddress.getByName(this.addr), this.port));
        } else {
            s = new Socket();
            s.connect(new InetSocketAddress(InetAddress.getByName(this.addr), this.port));
        }
        s.setReuseAddress(true);
        s.setSoLinger(true, 5);
        s.setSendBufferSize(4096);
        s.setReceiveBufferSize(8192);
        s.setTcpNoDelay(false);
        s.setKeepAlive(false);
        s.setOOBInline(false);
        s.setSoTimeout(this.timeout);
        this.socket = s;
        this.closeFlag = false;
        this.input = s.getInputStream();
        this.output = new BufferedOutputStream(s.getOutputStream());
    }

    public void close() {
        this.closeFlag = true;
        if (this.socket != null) {
            try {
                this.input.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.output.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
            this.input = null;
            this.output = null;
        }
    }

    public boolean isClose() {
        return this.closeFlag;
    }

    protected final void check() {
        if (this.closeFlag) {
            throw new MimdbException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5207\u65ad\u3055\u308c\u3066\u3044\u307e\u3059");
        }
    }

    public String getAddress() {
        this.check();
        return this.addr;
    }

    public int getPort() {
        this.check();
        return this.port;
    }

    public String getBindAddress() {
        this.check();
        return this.bindAddr;
    }

    public int getBindPort() {
        this.check();
        return this.bindPort;
    }

    public int getTimeout() {
        this.check();
        return this.timeout;
    }

    public void setTimeout(int time) {
        this.check();
        this.timeout = time;
        try {
            this.socket.setSoTimeout(time);
        }
        catch (Exception e) {
            throw new MimdbException(e);
        }
    }

    public RemoteTable getTable(String table) throws Exception {
        this.check();
        long dbId = -1L;
        RemoteTable ret = null;
        RemoteTableManager man = RemoteTableManager.getInstance();
        if (man.isTable(table)) {
            ret = (RemoteTable)man.get(table);
            if (ret.getLastUpdateTime() + 30000L >= System.currentTimeMillis()) {
                return ret;
            }
            dbId = ret.getDbId();
        }
        try {
            this.buffer.clear();
            ObjectBinary.encode(this.buffer, dbId);
            ObjectBinary.encode(this.buffer, table);
            this.send(1);
            byte[] recv = this.recv(1);
            this.recvOff[0] = 0;
            int len = recv.length;
            if (((Boolean)ObjectBinary.decodeBinary(this.recvOff, recv, len)).booleanValue()) {
                ret = (RemoteTable)man.get(table);
                ret.update();
            } else {
                if (ret == null) {
                    ret = new RemoteTable();
                }
                RemoteTable.toObject(ret, recv, this.recvOff[0], len);
                man.put(ret);
            }
            return ret;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public void statement(int[] out, QueryCompileInfo sql, int offset, int limit) throws Exception {
        this.check();
        try {
            this.buffer.clear();
            ObjectBinary.encode(this.buffer, false);
            ObjectBinary.encode(this.buffer, offset);
            ObjectBinary.encode(this.buffer, limit);
            sql.getBinary(this.buffer);
            this.send(2);
            byte[] recv = this.recv(2);
            this.recvOff[0] = 0;
            int len = recv.length;
            if (!((Boolean)ObjectBinary.decodeBinary(this.recvOff, recv, len)).booleanValue()) {
                throw new IOException("statement\u51e6\u7406\u5931\u6557");
            }
            out[0] = (Integer)ObjectBinary.decodeBinary(this.recvOff, recv, len);
            out[1] = (Integer)ObjectBinary.decodeBinary(this.recvOff, recv, len);
            out[2] = (Integer)ObjectBinary.decodeBinary(this.recvOff, recv, len);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public int prepared(int[] out, int preparedId, QueryCompileInfo sql, int offset, int limit, Object ... params) throws Exception {
        this.check();
        try {
            int len;
            byte[] recv;
            this.buffer.clear();
            if ((long)preparedId >= 0L) {
                ObjectBinary.encode(this.buffer, true);
                ObjectBinary.encode(this.buffer, false);
                ObjectBinary.encode(this.buffer, offset);
                ObjectBinary.encode(this.buffer, limit);
                ObjectBinary.encode(this.buffer, preparedId);
                MimdbClient.setParams(this.buffer, params);
                this.send(2);
                recv = this.recv(2);
                this.recvOff[0] = 0;
                len = recv.length;
                if (((Boolean)ObjectBinary.decodeBinary(this.recvOff, recv, len)).booleanValue()) {
                    int preId = (Integer)ObjectBinary.decodeBinary(this.recvOff, recv, len);
                    out[0] = (Integer)ObjectBinary.decodeBinary(this.recvOff, recv, len);
                    out[1] = (Integer)ObjectBinary.decodeBinary(this.recvOff, recv, len);
                    out[2] = (Integer)ObjectBinary.decodeBinary(this.recvOff, recv, len);
                    return preId;
                }
            }
            this.buffer.clear();
            ObjectBinary.encode(this.buffer, true);
            ObjectBinary.encode(this.buffer, true);
            ObjectBinary.encode(this.buffer, offset);
            ObjectBinary.encode(this.buffer, limit);
            sql.getBinary(this.buffer);
            MimdbClient.setParams(this.buffer, params);
            this.send(2);
            recv = this.recv(2);
            this.recvOff[0] = 0;
            len = recv.length;
            if (!((Boolean)ObjectBinary.decodeBinary(this.recvOff, recv, len)).booleanValue()) {
                throw new IOException("preparedStatement\u51e6\u7406\u5931\u6557");
            }
            int preId = (Integer)ObjectBinary.decodeBinary(this.recvOff, recv, len);
            out[0] = (Integer)ObjectBinary.decodeBinary(this.recvOff, recv, len);
            out[1] = (Integer)ObjectBinary.decodeBinary(this.recvOff, recv, len);
            out[2] = (Integer)ObjectBinary.decodeBinary(this.recvOff, recv, len);
            sql.setPreparedId(preId);
            return preId;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public Object[][] resultSet(int[] out, int id, int offset, int fetch) throws Exception {
        this.check();
        try {
            int length;
            this.buffer.clear();
            ObjectBinary.encode(this.buffer, id);
            ObjectBinary.encode(this.buffer, offset);
            ObjectBinary.encode(this.buffer, fetch);
            this.send(3);
            byte[] recv = this.recv(3);
            this.recvOff[0] = 0;
            int len = recv.length;
            if (!((Boolean)ObjectBinary.decodeBinary(this.recvOff, recv, len)).booleanValue()) {
                throw new MimdbException("ResultSet\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            out[0] = length = ((Integer)ObjectBinary.decodeBinary(this.recvOff, recv, len)).intValue();
            if (length > 0) {
                Object[][] ret = new Object[length][];
                int rowLen = (Integer)ObjectBinary.decodeBinary(this.recvOff, recv, len);
                for (int i = 0; i < length; ++i) {
                    Object[] row = new Object[rowLen];
                    ret[i] = row;
                    for (int j = 0; j < rowLen; ++j) {
                        row[j] = ObjectBinary.decodeBinary(this.recvOff, recv, len);
                    }
                }
                return ret;
            }
            return null;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public boolean sendClose(int type, int id) throws Exception {
        this.check();
        try {
            this.buffer.clear();
            ObjectBinary.encode(this.buffer, type);
            if (type == 1) {
                ObjectBinary.encode(this.buffer, -1);
            } else {
                ObjectBinary.encode(this.buffer, id);
            }
            this.send(16);
            byte[] recv = this.recv(16);
            this.recvOff[0] = 0;
            int len = recv.length;
            return (Boolean)ObjectBinary.decodeBinary(this.recvOff, recv, len);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    private static final void setParams(ByteArrayIO buf, Object[] params) throws Exception {
        if (params != null) {
            int len = params.length;
            for (int i = 0; i < len; ++i) {
                ObjectBinary.encode(buf, params[i]);
            }
        }
    }

    private final void send(int type) throws Exception {
        byte[] w = this.work;
        byte[] b = this.buffer.toByteArray();
        this.buffer.clear();
        if (b.length >= 8192) {
            JSnappyBuffer buf = JSnappy.compress(b, 0, b.length);
            b = buf.toByteArray();
            type |= 0x80;
        }
        int off = 3;
        System.arraycopy(ConnectionDefine.HEAD, 0, w, 0, off);
        w[off] = (byte)type;
        int len = b.length + 8;
        w[off + 1] = (byte)(len & 0xFF);
        w[off + 2] = (byte)((len & 0xFF00) >> 8);
        w[off + 3] = (byte)((len & 0xFF0000) >> 16);
        w[off + 4] = (byte)((len & 0xFF000000) >> 24);
        this.output.write(w, 0, 8);
        this.output.write(b, 0, b.length);
        this.output.flush();
    }

    private final byte[] recv(int type) throws Exception {
        int allLen = -1;
        int recvType = -1;
        byte[] w = this.work;
        this.buffer.clear();
        while (true) {
            int len;
            if ((len = this.input.read(w)) <= 0) {
                if (len > -1) continue;
                this.close();
                throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u304c\u5207\u65ad\u3055\u308c\u307e\u3057\u305f");
            }
            this.buffer.write(w, 0, len);
            if (allLen == -1) {
                if (this.buffer.writeLength() < 8) continue;
                this.buffer.peek(w, 0, 8);
                byte[] h = ConnectionDefine.HEAD;
                int off = 3;
                for (int i = 0; i < off; ++i) {
                    if (w[i] == h[i]) continue;
                    throw new IOException("\u901a\u4fe1\u30d8\u30c3\u30c0\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
                }
                recvType = w[off] & 0xFF;
                allLen = w[off + 1] & 0xFF | (w[off + 2] & 0xFF) << 8 | (w[off + 3] & 0xFF) << 16 | (w[off + 4] & 0xFF) << 24;
                if (allLen <= 0 || allLen >= 0x8000000) {
                    throw new IOException("\u53d7\u4fe1\u30c7\u30fc\u30bf\u9577\u304c\u4e0d\u6b63\u3067\u3059:" + allLen);
                }
            }
            if (this.buffer.writeLength() >= allLen) break;
        }
        byte[] body = new byte[allLen - 8];
        this.buffer.skip(8);
        this.buffer.read(body);
        this.buffer.clear();
        if ((recvType & 0x80) == 128) {
            recvType &= 0x7F;
            JSnappyBuffer buf = JSnappy.decompress(body, 0, body.length);
            body = buf.toByteArray();
        }
        switch (recvType) {
            case 1: 
            case 2: 
            case 3: 
            case 16: {
                if (recvType != type) {
                    throw new MimdbException("\u8981\u6c42\u30bf\u30a4\u30d7[" + type + "]\u306b\u5bfe\u3057\u3066\u3001\u53d7\u4fe1\u30bf\u30a4\u30d7[" + recvType + "]\u306f\u4e00\u81f4\u3057\u307e\u305b\u3093");
                }
                return body;
            }
            case 127: {
                MimdbClient.recvError(this.recvOff, body);
                return body;
            }
        }
        throw new IOException("\u4e0d\u660e\u306a\u53d7\u4fe1\u30bf\u30a4\u30d7:" + type);
    }

    private static final void recvError(int[] off, byte[] recv) throws Exception {
        off[0] = 0;
        int len = recv.length;
        String err = (String)ObjectBinary.decodeBinary(off, recv, len);
        throw new MimdbException(err);
    }
}

