/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.server;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.maachang.mimdb.core.MimdbQueryPrepared;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.MimdbResultRow;
import org.maachang.mimdb.core.MimdbTable;
import org.maachang.mimdb.core.MimdbTableManager;
import org.maachang.mimdb.core.QueryCompileInfo;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.AtomicNumber32;
import org.maachang.mimdb.core.util.ByteArrayIO;
import org.maachang.mimdb.core.util.ObjectBinary;
import org.maachang.mimdb.core.util.jsnappy.JSnappy;
import org.maachang.mimdb.core.util.jsnappy.JSnappyBuffer;
import org.maachang.mimdb.server.ConnectionDefine;
import org.maachang.mimdb.server.MimdbConnectElement;
import org.maachang.mimdb.server.MimdbServer;
import org.maachang.mimdb.server.NioSelector;

public final class MimdbIOThread
extends Thread {
    protected static final int LINGER = 5;
    protected static final boolean TCP_NO_DELAY = false;
    protected static final boolean KEEP_ALIVE = false;
    protected static final boolean OOB_INLINE = false;
    protected static final int BUFFER_LENGTH = 8192;
    private static final int SELECTOR_TIMEOUT = 1000;
    private int threadNo;
    private NioSelector selector;
    private boolean compress;
    private final AtomicNumber32 stopFlag = new AtomicNumber32(0);
    private final Queue<MimdbConnectElement> queue = new ConcurrentLinkedQueue<MimdbConnectElement>();

    public MimdbIOThread(int no, boolean flg) throws Exception {
        this.threadNo = no;
        this.compress = flg;
        this.selector = new NioSelector();
    }

    protected static final void print(String s) {
        MimdbServer.print(s);
    }

    protected static final void println(String s) {
        MimdbServer.println(s);
    }

    public void startThread() throws Exception {
        this.stopFlag.set(1);
        this.setDaemon(true);
        this.start();
    }

    public void stopThread() {
        this.stopFlag.set(0);
    }

    public boolean isStop() {
        return this.stopFlag.get() == 0;
    }

    public void register(SocketChannel channel) throws Exception {
        this.register(channel, 8192, 4096);
    }

    public void register(SocketChannel channel, int sendBuffer, int recvBuffer) throws Exception {
        try {
            channel.configureBlocking(false);
            channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            channel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)false);
            channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)false);
            channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)sendBuffer);
            channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)recvBuffer);
            MimdbConnectElement em = new MimdbConnectElement();
            em.channel = channel;
            this.queue.offer(em);
            this.selector.wakeup();
        }
        catch (Throwable t) {
            try {
                channel.close();
            }
            catch (Throwable tt) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        ThreadDeath tdObject = null;
        boolean endFlag = false;
        SelectionKey key = null;
        SocketChannel channel = null;
        MimdbConnectElement em = null;
        ByteBuffer buf = ByteBuffer.allocateDirect(4096);
        ByteArrayIO sendWork = new ByteArrayIO(4096);
        int[] off = new int[1];
        byte[] tmp = new byte[8];
        NioSelector s = this.selector;
        MimdbIOThread.println("****** ioThread [\u958b\u59cb]." + this.threadNo + " *****");
        while (this.stopFlag.get() == 1 && !endFlag) {
            try {
                Iterator<SelectionKey> it;
                if (!this.queue.isEmpty()) {
                    while (!this.queue.isEmpty() && this.stopFlag.get() == 1) {
                        em = this.queue.poll();
                        if (em == null) continue;
                        channel = em.channel;
                        s.register(channel, 1, em);
                        em = null;
                    }
                }
                if (s.select(1000) <= 0 || (it = s.iterator()) == null) continue;
                while (it.hasNext() && this.stopFlag.get() == 1) {
                    key = it.next();
                    it.remove();
                    if (key == null || !key.isValid()) {
                        if (key == null) continue;
                        NioSelector.destroyKey(key);
                        continue;
                    }
                    if (key.isReadable()) {
                        em = (MimdbConnectElement)key.attachment();
                        buf.clear();
                        int len = em.channel.read(buf);
                        if (len <= 0) {
                            if (len != -1) continue;
                            NioSelector.destroyKey(key);
                            continue;
                        }
                        buf.flip();
                        em.recvBuffer.write(buf);
                        if (em.recvType == 0) {
                            MimdbIOThread.recvAnalysis(tmp, em);
                        }
                        if (!MimdbIOThread.endRecv(off, sendWork, em, this.compress)) continue;
                        key.interestOps(5);
                        continue;
                    }
                    if (!key.isWritable()) continue;
                    em = (MimdbConnectElement)key.attachment();
                    buf.clear();
                    if (!MimdbIOThread.send(buf, em)) continue;
                    key.interestOps(1);
                }
            }
            catch (ThreadDeath td) {
                NioSelector.destroyKey(key);
                tdObject = td;
                endFlag = true;
            }
            catch (Throwable t) {
                NioSelector.destroyKey(key);
                if (!(t instanceof Error)) continue;
                MimdbIOThread.println(MimdbUtils.getStackTrace(t));
            }
        }
        this.stopFlag.set(0);
        MimdbIOThread.println("****** ioThread [\u505c\u6b62]." + this.threadNo + " *****");
        s.close();
        this.selector = null;
        if (tdObject != null) {
            throw tdObject;
        }
    }

    private static final void recvAnalysis(byte[] tmp, MimdbConnectElement em) throws Exception {
        if (em.recvBuffer.writeLength() < tmp.length) {
            return;
        }
        em.recvBuffer.peek(tmp);
        byte[] h = ConnectionDefine.HEAD;
        int off = 3;
        for (int i = 0; i < off; ++i) {
            if (tmp[i] == h[i]) continue;
            throw new IOException("\u901a\u4fe1\u30d8\u30c3\u30c0\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
        }
        int type = tmp[off] & 0xFF;
        int len = tmp[off + 1] & 0xFF | (tmp[off + 2] & 0xFF) << 8 | (tmp[off + 3] & 0xFF) << 16 | (tmp[off + 4] & 0xFF) << 24;
        if (len <= 0 || len > 65535) {
            throw new IOException("\u30c7\u30fc\u30bf\u9577\u304c\u9577\u3059\u304e\u3067\u3059:" + len);
        }
        em.recvType = type;
        em.nowRecvLength = len;
    }

    protected static final boolean endRecv(int[] off, ByteArrayIO sendWork, MimdbConnectElement em, boolean compress) throws Exception {
        byte[] recv;
        if (em.recvBuffer.writeLength() < em.nowRecvLength) {
            return false;
        }
        int type = em.recvType;
        if ((em.recvType & 0x80) == 128) {
            type = em.recvType & 0x7F;
            recv = new byte[em.nowRecvLength - 8];
            em.recvBuffer.skip(8);
            em.recvBuffer.read(recv);
            JSnappyBuffer buf = JSnappy.decompress(recv, 0, recv.length);
            recv = null;
            recv = buf.toByteArray();
        } else {
            recv = new byte[em.nowRecvLength - 8];
            em.recvBuffer.skip(8);
            em.recvBuffer.read(recv);
        }
        em.recvType = 0;
        em.nowRecvLength = 0;
        switch (type) {
            case 1: {
                MimdbIOThread.sendTable(off, sendWork, em, compress, recv);
                return true;
            }
            case 2: {
                MimdbIOThread.sendFirstResult(off, sendWork, em, compress, recv);
                return true;
            }
            case 3: {
                MimdbIOThread.sendNextResult(off, sendWork, em, compress, recv);
                return true;
            }
            case 16: {
                MimdbIOThread.executionClose(off, sendWork, em, compress, recv);
                return true;
            }
        }
        throw new IOException("\u4e0d\u660e\u306a\u53d7\u4fe1\u30bf\u30a4\u30d7:" + type);
    }

    private static final void packSendData(ByteArrayIO sendWork, int type, MimdbConnectElement em, boolean compress) throws Exception {
        byte[] b = sendWork.toByteArray();
        sendWork.clear();
        if (compress && b.length >= 8192) {
            JSnappyBuffer buf = JSnappy.compress(b, 0, b.length);
            b = buf.toByteArray();
            type |= 0x80;
        }
        byte[] tmp = new byte[8];
        int off = 3;
        System.arraycopy(ConnectionDefine.HEAD, 0, tmp, 0, off);
        tmp[off] = (byte)type;
        int len = b.length + 8;
        tmp[off + 1] = (byte)(len & 0xFF);
        tmp[off + 2] = (byte)((len & 0xFF00) >> 8);
        tmp[off + 3] = (byte)((len & 0xFF0000) >> 16);
        tmp[off + 4] = (byte)((len & 0xFF000000) >> 24);
        em.sendHeader = tmp;
        em.nowSendHeaderOffset = 0;
        em.sendBuffer = b;
        em.nowSendOffset = 0;
        em.nowSendLength = b.length;
        em.lastAccess = System.currentTimeMillis();
    }

    private static final void sendError(ByteArrayIO sendWork, MimdbConnectElement em, boolean compress, String message) throws Exception {
        sendWork.clear();
        ObjectBinary.encode(sendWork, message);
        MimdbIOThread.packSendData(sendWork, 127, em, compress);
    }

    private static final void sendTable(int[] off, ByteArrayIO sendWork, MimdbConnectElement em, boolean compress, byte[] recv) throws Exception {
        off[0] = 0;
        int len = recv.length;
        long dbId = (Long)ObjectBinary.decodeBinary(off, recv, len);
        String tableName = (String)ObjectBinary.decodeBinary(off, recv, len);
        MimdbTable table = (MimdbTable)MimdbTableManager.getInstance().get(tableName);
        if (table == null) {
            MimdbIOThread.sendError(sendWork, em, compress, "\u5bfe\u8c61\u306e\u30c6\u30fc\u30d6\u30eb\u540d[" + tableName + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        } else if (dbId <= 0L || table.getDbId() != dbId) {
            sendWork.clear();
            ObjectBinary.encode(sendWork, false);
            table.getBinary(sendWork);
            MimdbIOThread.packSendData(sendWork, 1, em, compress);
        } else {
            sendWork.clear();
            ObjectBinary.encode(sendWork, true);
            MimdbIOThread.packSendData(sendWork, 1, em, compress);
        }
    }

    private static final void sendFirstResult(int[] off, ByteArrayIO sendWork, MimdbConnectElement em, boolean compress, byte[] recv) throws Exception {
        off[0] = 0;
        int len = recv.length;
        int newId = -1;
        int offset = -1;
        int limit = -1;
        QueryCompileInfo prepared = null;
        boolean preparedFlag = (Boolean)ObjectBinary.decodeBinary(off, recv, len);
        boolean nowSendFlag = true;
        int preparedId = -1;
        if (preparedFlag) {
            nowSendFlag = (Boolean)ObjectBinary.decodeBinary(off, recv, len);
            offset = (Integer)ObjectBinary.decodeBinary(off, recv, len);
            limit = (Integer)ObjectBinary.decodeBinary(off, recv, len);
            if (!nowSendFlag) {
                SoftReference<QueryCompileInfo> o;
                preparedId = (Integer)ObjectBinary.decodeBinary(off, recv, len);
                if (preparedId <= -1 || (o = em.preparedList.get(preparedId)) == null || (prepared = o.get()) == null) {
                    em.preparedList.remove(preparedId);
                    sendWork.clear();
                    ObjectBinary.encode(sendWork, false);
                    MimdbIOThread.packSendData(sendWork, 2, em, compress);
                    return;
                }
                newId = preparedId;
            } else {
                prepared = new QueryCompileInfo();
                off[0] = prepared.toObject(recv, off[0], len);
            }
        } else {
            offset = (Integer)ObjectBinary.decodeBinary(off, recv, len);
            limit = (Integer)ObjectBinary.decodeBinary(off, recv, len);
            prepared = new QueryCompileInfo();
            off[0] = prepared.toObject(recv, off[0], len);
        }
        MimdbQueryPrepared ps = new MimdbQueryPrepared(prepared);
        if (ps.paramsLength() > 0) {
            int plen = ps.paramsLength();
            for (int i = 0; i < plen; ++i) {
                ps.setParams(i, ObjectBinary.decodeBinary(off, recv, len));
            }
        }
        MimdbResult res = null;
        if (offset >= 0) {
            ps.setOffset(offset);
        }
        if (limit >= 0) {
            ps.setLimit(limit);
        }
        try {
            res = ps.executeQuery();
        }
        catch (Exception e) {
            MimdbIOThread.sendError(sendWork, em, compress, e.getMessage());
            return;
        }
        if (preparedFlag && nowSendFlag) {
            newId = em.getPreparedSequenceId();
            em.preparedList.put(newId, new SoftReference<QueryCompileInfo>(prepared));
        }
        int resId = em.getResultSetSequenceId();
        em.resultList.put(resId, res);
        sendWork.clear();
        ObjectBinary.encode(sendWork, true);
        if (newId != -1) {
            ObjectBinary.encode(sendWork, newId);
        }
        ObjectBinary.encode(sendWork, resId);
        ObjectBinary.encode(sendWork, res.length());
        ObjectBinary.encode(sendWork, res.maxLength());
        MimdbIOThread.packSendData(sendWork, 2, em, compress);
    }

    private static final void sendNextResult(int[] off, ByteArrayIO sendWork, MimdbConnectElement em, boolean compress, byte[] recv) throws Exception {
        off[0] = 0;
        int len = recv.length;
        int id = (Integer)ObjectBinary.decodeBinary(off, recv, len);
        int offset = (Integer)ObjectBinary.decodeBinary(off, recv, len);
        int fetch = (Integer)ObjectBinary.decodeBinary(off, recv, len);
        MimdbResult res = em.resultList.get(id);
        if (res == null) {
            sendWork.clear();
            ObjectBinary.encode(sendWork, false);
            MimdbIOThread.packSendData(sendWork, 3, em, compress);
            return;
        }
        int length = res.length() - offset;
        length = fetch > length ? length : fetch;
        sendWork.clear();
        ObjectBinary.encode(sendWork, true);
        ObjectBinary.encode(sendWork, length);
        if (res.absolute(offset)) {
            MimdbResultRow row = res.get();
            int lenJ = row.size();
            ObjectBinary.encode(sendWork, lenJ);
            for (int i = 0; i < length; ++i) {
                for (int j = 0; j < lenJ; ++j) {
                    ObjectBinary.encode(sendWork, row.getValue(j));
                }
                if (!res.next()) break;
                row = res.get();
            }
        }
        MimdbIOThread.packSendData(sendWork, 3, em, compress);
    }

    private static final void executionClose(int[] off, ByteArrayIO sendWork, MimdbConnectElement em, boolean compress, byte[] recv) throws Exception {
        off[0] = 0;
        int len = recv.length;
        int type = (Integer)ObjectBinary.decodeBinary(off, recv, len);
        int id = (Integer)ObjectBinary.decodeBinary(off, recv, len);
        sendWork.clear();
        if (type == 1) {
            em.clear();
            ObjectBinary.encode(sendWork, true);
            MimdbIOThread.packSendData(sendWork, 16, em, compress);
        } else if (type == 2) {
            MimdbResult res = em.resultList.get(id);
            if (res != null) {
                em.resultList.remove(id);
                res.clear();
                ObjectBinary.encode(sendWork, true);
            } else {
                ObjectBinary.encode(sendWork, false);
            }
            MimdbIOThread.packSendData(sendWork, 16, em, compress);
        } else {
            MimdbIOThread.sendError(sendWork, em, compress, "\u30af\u30ed\u30fc\u30ba\u5bfe\u8c61\u306e\u51e6\u7406\u30bf\u30a4\u30d7[" + type + "]\u306f\u4e0d\u660e\u3067\u3059");
        }
    }

    private static final boolean send(ByteBuffer buf, MimdbConnectElement em) throws Exception {
        if (em.sendBuffer == null) {
            return true;
        }
        if (em.sendHeader != null) {
            int headerLen = em.sendHeader.length - em.nowSendHeaderOffset;
            buf.put(em.sendHeader, em.nowSendHeaderOffset, headerLen);
            int len = buf.remaining();
            if (len > em.nowSendLength) {
                len = em.nowSendLength;
            }
            buf.put(em.sendBuffer, 0, len);
            buf.flip();
            int sendLen = em.channel.write(buf);
            if (sendLen < headerLen) {
                em.nowSendHeaderOffset += sendLen;
                return false;
            }
            em.sendHeader = null;
            em.nowSendHeaderOffset = 0;
            em.nowSendOffset += sendLen - headerLen;
        } else {
            int len = buf.limit();
            if (len > em.nowSendLength - em.nowSendOffset) {
                len = em.nowSendLength - em.nowSendOffset;
            }
            buf.put(em.sendBuffer, em.nowSendOffset, len);
            buf.flip();
            int sendLen = em.channel.write(buf);
            em.nowSendOffset += sendLen;
        }
        if (em.nowSendLength <= em.nowSendOffset) {
            em.sendHeader = null;
            em.nowSendHeaderOffset = 0;
            em.sendBuffer = null;
            em.nowSendLength = 0;
            em.nowSendOffset = 0;
            return true;
        }
        return false;
    }
}

