/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.server.shutdown;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.maachang.mimdb.server.shutdown.ShutdownSignal;

public class WaitShutdown {
    private static final int RECEIVE_TIMEOUT = 1500;
    private byte[] recvBuffer = new byte[512];
    private DatagramSocket connection = null;
    private int srcPort = -1;

    private WaitShutdown() {
    }

    public WaitShutdown(int port) throws Exception {
        if (port <= 0 || port > 65535) {
            port = 3456;
        }
        this.connection = new DatagramSocket(port, InetAddress.getByName("127.0.0.1"));
        this.connection.setSoTimeout(1500);
    }

    public static final void waitSignal(int port, int exitCode) throws Exception {
        WaitShutdown w = new WaitShutdown(port);
        while (true) {
            try {
                while (true) {
                    if (!w.isShutdown()) {
                        continue;
                    }
                    w.exitShutdown();
                    System.exit(exitCode);
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    public boolean isShutdown() {
        boolean ret = false;
        try {
            DatagramPacket packet = new DatagramPacket(this.recvBuffer, this.recvBuffer.length);
            this.connection.receive(packet);
            if (packet.getLength() == ShutdownSignal.SHUTDOWN_BINARY.length && WaitShutdown.equals(packet)) {
                this.srcPort = packet.getPort();
                ret = true;
            }
        }
        catch (Throwable e) {
            ret = false;
        }
        return ret;
    }

    public void exitShutdown() {
        if (this.srcPort > 0) {
            try {
                this.connection.send(new DatagramPacket(ShutdownSignal.SHUTDOWN_BINARY, 0, ShutdownSignal.SHUTDOWN_BINARY.length, InetAddress.getByName("127.0.0.1"), this.srcPort));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final boolean equals(DatagramPacket packet) {
        if (packet.getLength() == ShutdownSignal.SHUTDOWN_BINARY.length) {
            boolean ret = true;
            int len = packet.getLength();
            byte[] bin = packet.getData();
            for (int i = 0; i < len; ++i) {
                if ((ShutdownSignal.SHUTDOWN_BINARY[i] & 0xFF) == (bin[i] & 0xFF)) continue;
                ret = false;
                break;
            }
            return ret;
        }
        return false;
    }
}

