package org.maachang.mimdb ;

import org.maachang.mimdb.server.MimdbServer;
import org.maachang.mimdb.server.shutdown.CallbackShutdown;
import org.maachang.mimdb.server.shutdown.ShutdownHook;
import org.maachang.mimdb.server.shutdown.WaitShutdown;

/**
 * Mimdbサーバーオブジェクト.
 * 
 * @version 2014/01/20
 * @author masahito suzuki
 * @since MasterInMemDB 1.02
 */
public final class Server {
    
    /** コンストラクタ. **/
    public Server() {}
    
    /** サーバー起動処理. **/
    public static final void main( String[] args ) throws Exception {
        
        if( args == null || args.length <= 0 ) {
            System.out.println( "パラメータが足りません" ) ;
            System.exit( -1 ) ;
        }
        
        Server s = new Server() ;
        s.create( args[ 0 ] ) ;
        
        // サーバーシャットダウン待ち.
        WaitShutdown.waitSignal( -1,0 ) ;
    }
    
    /**
     * Mimdbサーバー生成処理.
     * @param folder 対象のフォルダオブジェクトを設定します.
     * @exception Exception 例外.
     */
    public final void create( String folder ) throws Exception {
        
        // サーバ生成.
        MimdbServer server = new MimdbServer( folder ) ;
        
        // シャットダウンフックを生成.
        ExecutionShutdown sd = new ExecutionShutdown() ;
        sd.sv = server ;
        
        // シャットダウンフックをセット.
        ShutdownHook.registHook( sd ) ;
        
        // サーバー実行.
        server.startThread() ;
    }
    
    /** シャットダウンフックオブジェクト. **/
    private static final class ExecutionShutdown extends CallbackShutdown {
        MimdbServer sv ;
        
        /**
         * シャットダウンを実行するコールバックメソッド.
         */
        public void execution() {
            
            MimdbServer.println( " *** mimdbサーバー停止シグナルを受信 *** " ) ;
            
            // サーバー停止.
            sv.stopThread() ;
            
            // サーバー停止待機.
            while( !sv.isStop() ) {
                try {
                    Thread.sleep( 500 ) ;
                } catch( Exception e ) {
                }
            }
            
            MimdbServer.println( " *** mimdbサーバー停止完了 *** " ) ;
            
        }
    }
}
