package org.maachang.mimdb.core ;

import org.maachang.mimdb.core.impl.EqualsNoList;

/**
 * 結果メタデータ.
 * 
 * @version 2013/10/28
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
class MetaDataImpl implements MimdbMetaData {
    
    /** 親オブジェクト. **/
    ResultImpl parent ;
    
    /** 表示カラム条件. **/
    EqualsNoList viewColumnList ;
    
    /**
     * コンストラクタ.
     */
    public MetaDataImpl() {}
    
    /**
     * コンストラクタ.
     * @param parent ResultImplを設定します.
     * @param viewColumnList 表示カラムリストを設定します.
     */
    public MetaDataImpl( ResultImpl parent,EqualsNoList viewColumnList ) {
        create( parent,viewColumnList ) ;
    }
    
    /**
     * 情報生成.
     * @param parent ResultImplを設定します.
     * @param viewColumnList 表示カラムリストを設定します.
     */
    public void create( ResultImpl parent,EqualsNoList viewColumnList ) {
        this.parent = parent ;
        this.viewColumnList = viewColumnList ;
    }
    
    /**
     * 情報クリア.
     */
    public void clear() {
        this.parent = null ;
        this.viewColumnList = null ;
    }
    
    /**
     * 更新IDを取得.
     * @return long 更新IDが返却されます.
     */
    public long getDbId() {
        return parent.dbId ;
    }
    
    /**
     * テーブル名の取得.
     * @return String テーブル名が返却されます.
     */
    public String getName() {
        return parent.table.name ;
    }
    
    /**
     * テーブル情報の取得.
     * @return BaseTable テーブル情報が返却されます.
     */
    public BaseTable getTable() {
        return parent.table ;
    }
    
    /**
     * カラム数の取得.
     * @return int カラム数が返却されます.
     */
    public int getColumnSize() {
        // 表示カラム条件が設定されている場合.
        if( viewColumnList != null ) {
            return viewColumnList.size() ;
        }
        return parent.table.columnLength ;
    }
    
    /**
     * カラム名を取得.
     * @param no カラム項番を設定します.
     * @return String カラム名が返却されます.
     */
    public String getColumnName( int no ) {
        // 表示カラム条件が設定されている場合.
        if( viewColumnList != null ) {
            no = viewColumnList.src( no ) ;
        }
        return parent.table.getColumnName( no ) ;
    }
    
    /**
     * 指定カラム名に対する項番を取得.
     * @param name カラム名を設定します.
     * @return int カラム項番が返却されます.
     *             [-1]の場合は対象カラム名は存在しません.
     */
    public int getColumnNameByNo( String name ) {
        // 表示カラム条件が設定されている場合.
        if( viewColumnList != null ) {
            int ret = parent.table.getColumnNameByNo( name ) ;
            if( !viewColumnList.equals( ret ) ) {
                return -1 ;
            }
            return ret ;
        }
        return parent.table.getColumnNameByNo( name ) ;
    }
    
    /**
     * カラムタイプを取得.
     * @param no カラム項番を設定します.
     * @return int カラムタイプが返却されます.
     *             -1が返却された場合は、対象カラムは存在しません.
     * java.lang.Boolean  : MimdbIndex.COLUMN_BOOL
     * java.lang.Integer  : MimdbIndex.COLUMN_INT
     * java.lang.Long     : MimdbIndex.COLUMN_LONG
     * java.lang.Double   : MimdbIndex.COLUMN_FLOAT
     * java.lang.String   : MimdbIndex.COLUMN_STRING
     * java.sql.Date      : MimdbIndex.COLUMN_DATE
     * java.sql.Time      : MimdbIndex.COLUMN_TIME
     * java.sql.Timestamp : MimdbIndex.COLUMN_TIMESTAMP
     * java.util.Date     : MimdbIndex.COLUMN_DATE
     */
    public int getColumnType( int no ) {
        // 表示カラム条件が設定されている場合.
        if( viewColumnList != null ) {
            no = viewColumnList.src( no ) ;
        }
        return parent.table.getColumnType( no ) ;
    }
    
    /**
     * カラムタイプを取得.
     * @param name 対象のカラム名を設定します.
     * @return int カラムタイプが返却されます.
     *             -1が返却された場合は、対象カラムは存在しません.
     * java.lang.Boolean  : MimdbIndex.COLUMN_BOOL
     * java.lang.Integer  : MimdbIndex.COLUMN_INT
     * java.lang.Long     : MimdbIndex.COLUMN_LONG
     * java.lang.Double   : MimdbIndex.COLUMN_FLOAT
     * java.lang.String   : MimdbIndex.COLUMN_STRING
     * java.sql.Date      : MimdbIndex.COLUMN_DATE
     * java.sql.Time      : MimdbIndex.COLUMN_TIME
     * java.sql.Timestamp : MimdbIndex.COLUMN_TIMESTAMP
     * java.util.Date     : MimdbIndex.COLUMN_DATE
     */
    public int getColumnType( String name ) {
        // 表示カラム条件が設定されている場合.
        if( viewColumnList != null ) {
            int no = parent.table.getColumnNameByNo( name ) ;
            if( !viewColumnList.equals( no ) ) {
                return -1 ;
            }
            return parent.table.getColumnType( no ) ;
        }
        return parent.table.getColumnType( name ) ;
    }
}
