package org.maachang.mimdb.core;

import java.io.OutputStream;


/**
 * 検索要素情報.
 * 
 * @version 2013/10/07
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public interface MimdbSearchElement {
    
    /**
     * 対象カラム名を取得.
     * @return String 比較対象のカラム名を取得します.
     */
    public String getColumn() ;
    
    /**
     * 検索タイプの取得.
     * @return int 検索タイプが返却されます.
     */
    public int getType() ;
    
    /**
     * 検索要素の取得.
     * @return Object 検索要素が返却されます.
     */
    public Object getValue() ;
    
    /**
     * 検索要素の設定.
     * @param v 検索要素を設定します.
     */
    public void setValue( Object v ) ;
    
    /**
     * 検索条件がNULLかチェック.
     * @return boolean [true]の場合はNULLです.
     */
    public boolean isNull() ;
    
    /**
     * Preparedモードかチェック.
     * @return boolean [true]の場合、Preparedモードです.
     */
    public boolean isPrepared() ;
    
    /**
     * 条件指定かチェック.
     * @return boolean [true]の場合、a=bのような条件指定です.
     */
    public boolean isWhere() ;
    
    /**
     * 条件指定かチェック.
     * @return boolean [true]の場合、and orのような条件指定です.
     */
    public boolean isAndOr() ;
    
    /**
     * オフセット、リミット条件かチェック.
     * @return boolean [true]の場合、オフセット、リミット条件です.
     */
    public boolean isOffLimit() ;
    
    /**
     * カラム名を番号に変換.
     * @param table 対象のテーブルを設定します.
     * @return int カラム項番が返却されます.
     * @exception Exception 例外.
     */
    public int columnNameByNo( BaseTable table ) throws Exception ;
    
    /**
     * カラム項番を取得.
     * @return int カラム項番が返却されます.
     */
    public int getColumnNo() ;
    
    /**
     * バイナリ変換.
     * @param out 対象のOutputStreamを設定します.
     * @exception Exception 例外.
     */
    public void getOutput( OutputStream out )
        throws Exception ;
}
