package org.maachang.mimdb.core ;

/**
 * Mimdbステートメント.
 * 
 * @version 2014/01/16
 * @author masahito suzuki
 * @since MasterInMemDB 1.02
 */
public interface MimdbStatement {
    
    /**
     * オブジェクトクローズ.
     */
    public void close() ;
    
    /**
     * オブジェクトがクローズしているか取得.
     * @return boolean [true]の場合、クローズしています.
     */
    public boolean isClose() ;
    
    /**
     * 表示オフセット値を設定.
     * この条件により、表示位置を確定できます.
     * @param off 表示オフセット値を設定します.
     *            [-1]が設定された場合、表示幅は確定されません.
     * @return MimdbStatement このオブジェクトが返却されます.
     */
    public MimdbStatement setOffset( int off ) ;
    
    /**
     * 表示リミット値を設定.
     * この条件により、表示位置を確定できます.
     * @param limit 表示リミット値を設定します.
     *            [-1]が設定された場合、表示幅は確定されません.
     * @return MimdbStatement このオブジェクトが返却されます.
     */
    public MimdbStatement setLimit( int limit ) ;
    
    /**
     * フェッチサイズを設定.
     * ※この値は、サーバーモードでの接続のみ有効となります.
     * @param size フェッチサイズを設定します.
     * @return MimdbStatement このオブジェクトが返却されます.
     */
    public MimdbStatement setFetchSize( int size ) ;
    
    /**
     * フェッチサイズを取得.
     * ※この値は、サーバーモードでの接続のみ有効となります.
     * @return int フェッチサイズが返却されます.
     */
    public int getFetchSize() ;
    
    /**
     * クエリー実行.
     * @param sql 対象のSQL文を設定します.
     * @return MimdbResult 実行結果が返却されます.
     * @exception Exception 例外.
     */
    public MimdbResult executeQuery( String sql ) throws Exception ;
}
