package org.maachang.mimdb.core ;

import java.io.OutputStream;

import org.maachang.mimdb.core.util.ObjectBinary;

/**
 * ソート要素.
 * 
 * @version 2013/10/10
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
final class SortElement {
    
    /** ソートカラム項番. **/
    protected int[] sortNoList = null ;
    
    /** 降順の場合は[true]. **/
    protected boolean[] desc = null ;
    
    /** インデックスリスト. **/
    protected int[][] indexList = null ;
    
    /** インデックス長. **/
    protected int indexLength = -1 ;
    
    /**
     * バイナリ変換.
     * @param out 対象のOutputStreamを設定します.
     * @exception Exception 例外.
     */
    public void getOutput( OutputStream out )
        throws Exception {
        ObjectBinary.encode( out,sortNoList ) ;
        ObjectBinary.encode( out,desc ) ;
    }
    
}
