package org.maachang.mimdb.jdbc ;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Properties;
import java.util.concurrent.Executor;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbConnection;

/**
 * Mimdb-JDBC Connection.
 * 
 * @version 2014/01/20
 * @author masahito suzuki
 * @since MasterInMemDB 1.02
 */
public final class MimdbJdbcConnection implements java.sql.Connection {
    protected MimdbConnection connection = null ;
    
    private MimdbJdbcConnection() {}
    
    public MimdbJdbcConnection( MimdbConnection conn ) {
        connection = conn ;
    }
    
    protected void finalize() throws Exception {
        close() ;
    }
    
    public void close() throws SQLException {
        if( connection != null ) {
            connection.close() ;
            connection = null ;
        }
    }
    
    public boolean isClosed() throws SQLException {
        return connection == null ;
    }
    
    /** チェック. **/
    protected final void check() {
        if( connection == null || connection.isClose() ) {
            throw new MimdbException( "コネクションは既にクローズしています" ) ;
        }
    }
    
    public void commit() throws SQLException {
        check() ;
    }
    
    public void rollback() throws SQLException {
        check() ;
    }
    
    public Statement createStatement() throws SQLException {
        check() ;
        return new MimdbJdbcStatement( this,connection ) ;
    }
    
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        check() ;
        return new MimdbJdbcPreparedStatement( this,connection,sql ) ;
    }
    
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    
    public String nativeSQL(String sql) throws SQLException {
        check() ;
        return sql ;
    }
    
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        check() ;
    }
    
    public boolean getAutoCommit() throws SQLException {
        check() ;
        return true ;
    }
    
    // ======================================================================
    // Advanced features:
    
    public DatabaseMetaData getMetaData() throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    
    public void setReadOnly(boolean readOnly) throws SQLException {
        check() ;
    }
    
    public boolean isReadOnly() throws SQLException {
        check() ;
        return true ;
    }
    
    public void setCatalog(String catalog) throws SQLException {
        check() ;
    }
    
    public String getCatalog() throws SQLException {
        check() ;
        return null ;
    }
    
    public void setTransactionIsolation(int level) throws SQLException {
        check() ;
    }
    
    public int getTransactionIsolation() throws SQLException {
        check() ;
        return Connection.TRANSACTION_NONE  ;
    }
    
    public SQLWarning getWarnings() throws SQLException {
        check() ;
        return null ;
    }
    
    public void clearWarnings() throws SQLException {
        check() ;
    }
    
    // --------------------------JDBC 2.0-----------------------------
    
    public Statement createStatement(int resultSetType, int resultSetConcurrency)
        throws SQLException {
        return createStatement() ;
    }
    
    public PreparedStatement prepareStatement(String sql, int resultSetType,
        int resultSetConcurrency) throws SQLException {
        return prepareStatement( sql ) ;
    }
    
    public CallableStatement prepareCall(String sql, int resultSetType,
        int resultSetConcurrency) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    
    public java.util.Map<String, Class<?>> getTypeMap() throws SQLException {
        check() ;
        return null ;
    }
    
    public void setTypeMap(java.util.Map<String, Class<?>> map)
        throws SQLException {
        check() ;
    }
    
    // --------------------------JDBC 3.0-----------------------------
    
    public void setHoldability(int holdability) throws SQLException {
        check() ;
    }
    
    public int getHoldability() throws SQLException {
        check() ;
        return ResultSet.HOLD_CURSORS_OVER_COMMIT ;
    }
    
    public Savepoint setSavepoint() throws SQLException {
        check() ;
        return null ;
    }
    
    public Savepoint setSavepoint(String name) throws SQLException {
        check() ;
        return null ;
    }
    
    public void rollback(Savepoint savepoint) throws SQLException {
        check() ;
    }
    
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        check() ;
    }
    
    public Statement createStatement(int resultSetType,
        int resultSetConcurrency, int resultSetHoldability)
        throws SQLException {
        return createStatement() ;
    }
    
    public PreparedStatement prepareStatement(String sql, int resultSetType,
        int resultSetConcurrency, int resultSetHoldability)
        throws SQLException {
        return prepareStatement( sql ) ;
    }
    
    public CallableStatement prepareCall(String sql, int resultSetType,
        int resultSetConcurrency, int resultSetHoldability)
        throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys)
        throws SQLException {
        return prepareStatement( sql ) ;
    }
    
    public PreparedStatement prepareStatement(String sql, int columnIndexes[])
        throws SQLException {
        return prepareStatement( sql ) ;
    }
    
    public PreparedStatement prepareStatement(String sql, String columnNames[])
        throws SQLException {
        return prepareStatement( sql ) ;
    }
    
    public Clob createClob() throws SQLException {
        check() ;
        return null ;
    }
    
    public Blob createBlob() throws SQLException {
        check() ;
        return null ;
    }
    
    public NClob createNClob() throws SQLException {
        check() ;
        return null ;
    }
    
    public SQLXML createSQLXML() throws SQLException {
        check() ;
        return null ;
    }
    
    public boolean isValid(int timeout) throws SQLException {
        check() ;
        return true ;
    }
    
    public void setClientInfo(String name, String value)
        throws SQLClientInfoException {
        check() ;
    }
    
    public void setClientInfo(Properties properties)
        throws SQLClientInfoException {
        check() ;
    }
    
    public String getClientInfo(String name) throws SQLException {
        check() ;
        return null ;
    }
    
    public Properties getClientInfo() throws SQLException {
        check() ;
        return null ;
    }
    
    public Array createArrayOf(String typeName, Object[] elements)
        throws SQLException {
        check() ;
        return null ;
    }
    
    public Struct createStruct(String typeName, Object[] attributes)
        throws SQLException {
        check() ;
        return null ;
    }
    
    // Wrapper.java
    public <T> T unwrap(java.lang.Class<T> iface) throws java.sql.SQLException {
        check() ;
        return null ;
    }
    
    public boolean isWrapperFor(java.lang.Class<?> iface)
        throws java.sql.SQLException {
        check() ;
        return false ;
    }
    
    public void setSchema(String schema) throws SQLException {
        check() ;
    }
    
    public String getSchema() throws SQLException {
        check() ;
        return null ;
    }
    
    public void abort(Executor executor) throws SQLException {
        check() ;
    }
    
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        check() ;
        connection.setTimeout( (int)milliseconds ) ;
    }
    
    public int getNetworkTimeout() throws SQLException {
        check() ;
        return connection.getTimeout() ;
    }
}
