package org.maachang.mimdb.jdbc ;

import java.sql.SQLException;
import java.sql.Types;

import org.maachang.mimdb.core.MimdbPreparedStatement;

/**
 * Mimdb-JDBC プリコンパイル済み
 * パラメータメタデータ.
 *
 * @version 2013/11/19
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public class MimdbJdbcParameterMetaData implements java.sql.ParameterMetaData {
    protected MimdbPreparedStatement pstmt ;

    protected MimdbJdbcParameterMetaData( MimdbPreparedStatement p ) {
        pstmt = p ;
    }

    public String getParameterClassName(int param) throws SQLException {
        if( pstmt.isListParam( param-1 ) ) {
            return "java.util.List" ;
        }
        return MimdbJdbcResultSetMetaData._getColumnClassName(
            pstmt.getType( param-1 ) ) ;
    }
    public int getParameterCount() throws SQLException {
        return pstmt.length() ;
    }
    public int getParameterMode(int param) throws SQLException {
        return parameterModeUnknown ;
    }
    public int getParameterType(int param) throws SQLException {
        if( pstmt.isListParam( param-1 ) ) {
            return Types.JAVA_OBJECT ;
        }
        return MimdbJdbcResultSetMetaData._getColumnType(
            pstmt.getType( param-1 ) ) ;
    }
    public String getParameterTypeName(int param) throws SQLException {
        return getParameterClassName( param ) ;
    }
    public int getPrecision(int param) throws SQLException {
        return MimdbJdbcResultSetMetaData._getPrecision(
            pstmt.getType( param-1 ) ) ;
    }
    public int getScale(int param) throws SQLException {
        return MimdbJdbcResultSetMetaData._getScale(
            pstmt.getType( param-1 ) ) ;
    }
    public int isNullable(int param) throws SQLException {
        return -1 ;
    }
    public boolean isSigned(int param) throws SQLException {
        return MimdbJdbcResultSetMetaData._isSigned(
            pstmt.getType( param-1 ) ) ;
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false ;
    }
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null ;
    }
}
