package org.maachang.mimdb.server ;

/**
 * 通信定義.
 * 
 * @version 2014/01/16
 * @author  masahito suzuki
 * @since MasterInMemDB 1.02
 */
public final class ConnectionDefine {
    private ConnectionDefine() {}
    
    /** デフォルトポート. **/
    public static final int DEF_PORT = 3210 ;
    
    /** シャットダウンシグナル待ちポート. **/
    public static final int SHUTDOWN_PORT = 3456 ;
    
    /** 通信ヘッダ. **/
    public static final byte[] HEAD = new byte[]{
        (byte)'m',(byte)'i',(byte)'m' } ;
    
    /** 通信ヘッダ長. **/
    public static final int HEAD_LENGTH = 3 ;
    
    /** Body圧縮を行う最小サイズ. **/
    protected static final int COMPRESS_LENGTH = 8192 ;
    
    /**
     * 通信ヘッダプラス.
     * mim   (3).
     * type  (1).
     * length(4).
     */
    public static final int HEAD_PLUS = HEAD_LENGTH + 1 + 4 ;
    
    /** シーケンスID最大管理長. **/
    public static final int MAX_SEQUENCE_ID = 999999999 ;
    
    /** リモートテーブル問い合わせタイミング. **/
    public static final long TABLE_TIMING = 30000L ;
    
    /** 最大受信長. **/
    public static final int MAX_RECV_LENGTH = 1048576 * 128 ;
    
    
    
    
    /** 通信タイプ : テーブル情報要求. **/
    public static final int TABLE_INFO = 0x01 ;
    
    /** 通信タイプ : テーブル情報要求. **/
    public static final int EXECUTION_SQL = 0x02 ;
    
    /** 通信タイプ : テーブル情報要求. **/
    public static final int RESULT_GET = 0x03 ;
    
    /** 通信タイプ : テーブル情報要求. **/
    public static final int CLOSE = 0x10 ;
    
    /** 通信タイプ : エラー. **/
    public static final int ERROR = 0x7f ;
    
    
    
    /** コネクションクローズタイプ : コネクションクローズ. **/
    public static final int CLOSE_CONNECTION = 1 ;
    
    /** コネクションクローズタイプ : ResultSetクローズ. **/
    public static final int CLOSE_RESULT_SET = 2 ;
}
