/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.maachang.rimdb.table.TableUtil;
import org.maachang.rimdb.util.ConvertUtil;

public class ColumnMap
implements Map<String, Object> {
    private static final int DEF_LENGTH = 32;
    private static final int MIN_LENGTH = 4;
    private ColumnMapChild[] list;
    private int mask;
    private int length;
    private int limit;
    private int base;
    private boolean nullFlag;
    private Object nullValue;
    private int pos = 0;
    private ColumnMapChild cPos = null;
    private int count = 0;
    private boolean nullOutFlag = false;

    public ColumnMap() {
        this(32);
    }

    public ColumnMap(int size) {
        size = size < 4 ? 4 : ConvertUtil.bitMask(size);
        this.list = new ColumnMapChild[size];
        this.length = 0;
        this.mask = size - 1;
        this.limit = size;
        this.base = size;
        this.nullFlag = false;
        this.nullValue = null;
    }

    @Override
    public void clear() {
        if (this.length != 0 || this.list == null || this.list.length != this.base) {
            this.list = new ColumnMapChild[this.base];
        }
        this.length = 0;
        this.mask = this.base - 1;
        this.limit = this.base;
        this.nullFlag = false;
        this.nullValue = null;
    }

    public final ColumnMap toJavaMap() {
        ColumnMap ret = new ColumnMap(this.size());
        this.reset();
        while (this.hasNext()) {
            ret.put(TableUtil.convertDBNameByJavaName(false, this.next()), this.nextValue());
        }
        return ret;
    }

    public final ColumnMap toSqlMap() {
        ColumnMap ret = new ColumnMap(this.size());
        this.reset();
        while (this.hasNext()) {
            ret.put(TableUtil.convertJavaNameByDBName(this.next()), this.nextValue());
        }
        return ret;
    }

    @Override
    public Object put(String b, Object o) {
        int h;
        if (b == null) {
            this.nullFlag = true;
            this.nullValue = o;
            return null;
        }
        Object ret = null;
        if (this.length + 1 >= this.limit) {
            int nLen = this.limit << 1;
            int msk = nLen - 1;
            ColumnMapChild[] nList = new ColumnMapChild[nLen];
            int i = 0;
            while (i < this.limit) {
                ColumnMapChild n = this.list[i];
                while (n != null) {
                    ColumnMapChild t;
                    h = n.b.hashCode() & msk;
                    if (nList[h] == null) {
                        t = n.n;
                        n.n = null;
                    } else {
                        t = n.n;
                        n.n = nList[h];
                    }
                    nList[h] = n;
                    n = t;
                }
                ++i;
            }
            this.list = nList;
            this.limit = nLen;
            this.mask = msk;
        }
        if (this.list[h = b.hashCode() & this.mask] == null) {
            this.list[h] = new ColumnMapChild(b, o);
            ++this.length;
        } else {
            int bh = b.hashCode();
            ColumnMapChild nn = this.list[h];
            while (nn.n != null) {
                if (nn.b.hashCode() == bh && (nn.b == b || nn.b.equals(b))) {
                    ret = nn.o;
                    nn.o = o;
                    return ret;
                }
                nn = nn.n;
            }
            if (nn.b.hashCode() == bh && (nn.b == b || nn.b.equals(b))) {
                ret = nn.o;
                nn.o = o;
            } else {
                nn.n = new ColumnMapChild(b, o);
                ++this.length;
            }
        }
        return ret;
    }

    @Override
    public boolean containsKey(Object b) {
        if (b == null) {
            return this.nullFlag;
        }
        int hb = b.hashCode();
        ColumnMapChild n = this.list[hb & this.mask];
        while (n != null) {
            if (n.b.hashCode() == hb && (n.b == b || n.b.equals(b))) {
                return true;
            }
            n = n.n;
        }
        return false;
    }

    @Override
    public Object get(Object b) {
        if (b == null) {
            return this.nullValue;
        }
        int hb = b.hashCode();
        ColumnMapChild n = this.list[hb & this.mask];
        while (n != null) {
            if (n.b.hashCode() == hb && (n.b == b || n.b.equals(b))) {
                return n.o;
            }
            n = n.n;
        }
        return null;
    }

    @Override
    public Object remove(Object b) {
        if (b == null) {
            this.nullFlag = false;
            Object ret = this.nullValue;
            this.nullValue = null;
            return ret;
        }
        Object ret = null;
        int bh = b.hashCode();
        ColumnMapChild bf = null;
        ColumnMapChild n = this.list[bh & this.mask];
        while (n != null) {
            if (n.b.hashCode() == bh && (n.b == b || n.b.equals(b))) {
                if (bf == null) {
                    if (n.n == null) {
                        ret = this.list[bh & this.mask].o;
                        this.list[bh & this.mask] = null;
                    } else {
                        ret = this.list[bh & this.mask].o;
                        this.list[bh & this.mask] = n.n;
                    }
                } else if (n.n == null) {
                    ret = bf.o;
                    bf.n = null;
                } else {
                    ret = bf.o;
                    bf.n = n.n;
                }
                --this.length;
                break;
            }
            bf = n;
            n = n.n;
        }
        return ret;
    }

    @Override
    public int size() {
        return this.nullFlag ? this.length + 1 : this.length;
    }

    public Object[] keyArray() {
        int cnt;
        Object[] ret;
        if (this.size() == 0) {
            return null;
        }
        if (this.nullFlag) {
            ret = new Object[this.length + 1];
            cnt = 1;
        } else {
            ret = new Object[this.length];
            cnt = 0;
        }
        int i = 0;
        while (i < this.limit) {
            if (this.list[i] != null) {
                ColumnMapChild n = this.list[i];
                while (n != null) {
                    ret[cnt++] = n.b;
                    n = n.n;
                }
            }
            ++i;
        }
        return ret;
    }

    public ColumnMap reset() {
        this.pos = 0;
        this.cPos = null;
        this.count = 0;
        this.nullOutFlag = false;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasNext() {
        if (this.count == 0) {
            if (this.nullFlag) {
                ++this.count;
                return true;
            }
            this.nullOutFlag = true;
        }
        if (this.cPos == null || (this.cPos = this.cPos.n) == null) ** GOTO lbl12
        ++this.count;
        return true;
lbl-1000:
        // 1 sources

        {
            if ((this.cPos = this.list[this.pos++]) == null) continue;
            ++this.count;
            return true;
lbl12:
            // 2 sources

            ** while (this.pos < this.limit)
        }
lbl13:
        // 1 sources

        return false;
    }

    public String next() {
        if (!this.nullOutFlag) {
            this.nullOutFlag = true;
            return null;
        }
        if (this.cPos == null) {
            return null;
        }
        return (String)this.cPos.b;
    }

    public Object nextValue() {
        if (this.cPos == null) {
            return null;
        }
        return this.cPos.o;
    }

    public int count() {
        return this.count;
    }

    public Iterator<String> iterator() {
        OKV_Iterator ret = new OKV_Iterator();
        ret._this = this;
        this.reset();
        return ret;
    }

    public String toString() {
        this.reset();
        boolean flg = false;
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        while (this.hasNext()) {
            this.next();
            if (flg) {
                buf.append(",");
            }
            buf.append(this.cPos.b);
            buf.append(":");
            if (this.cPos.o instanceof String) {
                buf.append("\"").append(this.cPos.o).append("\"");
            } else {
                buf.append(this.cPos.o);
            }
            flg = true;
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        for (String string : toMerge.keySet()) {
            this.put(string, toMerge.get(string));
        }
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public Set entrySet() {
        return null;
    }

    @Override
    public Collection<Object> values() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<String> keySet() {
        OKV_KeySet ret = new OKV_KeySet();
        ret._this = this;
        return ret;
    }

    public void getAllKey(Set<Object> set) {
    }

    public void getAllValues(Set<Object> set) {
    }

    private static final class ColumnMapChild {
        public Object b;
        public Object o;
        ColumnMapChild n;

        ColumnMapChild(Object k, Object v) {
            this.b = k;
            this.o = v;
        }
    }

    private final class OKV_Iterator
    implements Iterator<String> {
        ColumnMap _this;

        private OKV_Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this._this.hasNext();
        }

        @Override
        public String next() {
            return this._this.next();
        }

        @Override
        public void remove() {
        }
    }

    private final class OKV_KeySet
    implements Set<String> {
        ColumnMap _this;

        private OKV_KeySet() {
        }

        @Override
        public boolean add(String e) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean contains(Object o) {
            return this._this.containsKey((String)o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }

        @Override
        public int hashCode() {
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this._this.size() == 0;
        }

        @Override
        public Iterator<String> iterator() {
            return this._this.iterator();
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public int size() {
            return this.size();
        }

        @Override
        public Object[] toArray() {
            return this._this.keyArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return null;
        }
    }
}

