/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.Table;
import org.maachang.rimdb.search.CacheSearch;
import org.maachang.rimdb.table.ConfTable;
import org.maachang.rimdb.table.TableImpl;
import org.maachang.rimdb.table.TableManager;
import org.maachang.rimdb.table.TableUtil;
import org.maachang.rimdb.util.Config;
import org.maachang.rimdb.util.FileUtil;

public final class TableFactory {
    public static final int VERSION = 1;
    public static final int MINOR_VERSION = 1;
    private static final TableFactory SNGL = new TableFactory();
    private static final String DEF_CONF = "rimdb.conf";
    private static final String SECTION = "rimdb";
    private volatile String baseFileName;
    private volatile String baseFolder;
    private volatile TableManager manager;
    private volatile Map<String, ConfTable> confMap;
    private final CacheSearch cache = new CacheSearch();

    protected TableFactory() {
    }

    public static final TableFactory getInstance() {
        return SNGL;
    }

    public final void init(String fileName) {
        if (fileName.endsWith("\\") || fileName.endsWith("/")) {
            fileName = String.valueOf(fileName) + DEF_CONF;
        }
        if (!FileUtil.isFile(fileName)) {
            throw new RimDbException("\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb[" + fileName + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        try {
            fileName = FileUtil.getFullPath(fileName);
        }
        catch (Exception e) {
            throw new RimDbException(e);
        }
        this.baseFileName = fileName;
        this.reload();
    }

    public final void reload() {
        Config conf;
        if (this.baseFileName == null) {
            return;
        }
        try {
            conf = Config.read(this.baseFileName);
        }
        catch (Exception e) {
            throw new RimDbException(e);
        }
        if (!conf.isSection(SECTION)) {
            throw new RimDbException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + this.baseFileName + "]\u306eConfig\u30d5\u30a1\u30a4\u30eb\u306f\u3001RIMDB\u5b9a\u7fa9\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        Boolean useFlag = conf.getBoolean(SECTION, "use", 0);
        if (useFlag != null && !useFlag.booleanValue()) {
            this.confMap.clear();
            this.manager = null;
            this.baseFileName = null;
            this.baseFolder = null;
            this.cache.clear();
            return;
        }
        String folder = conf.getString(SECTION, "folder", 0);
        if (folder == null || (folder = folder.trim()).length() <= 0) {
            int p = this.baseFileName.lastIndexOf("/");
            folder = p == -1 ? "/" : this.baseFileName.substring(0, p + 1);
        } else {
            try {
                folder = FileUtil.getFullPath(folder);
            }
            catch (Exception e) {
                throw new RimDbException(e);
            }
        }
        String[] names = conf.getAll(SECTION, "name");
        if (names == null || names.length == 0) {
            TableManager m = new TableManager();
            ConcurrentHashMap<String, ConfTable> mm = new ConcurrentHashMap<String, ConfTable>();
            this.baseFolder = folder;
            this.confMap = mm;
            this.manager = m;
            return;
        }
        int len = names.length;
        int i = 0;
        while (i < len) {
            if (!names[i].endsWith(".conf")) {
                int n = i;
                names[n] = String.valueOf(names[n]) + ".conf";
            }
            ++i;
        }
        len = names.length;
        TableManager m = new TableManager();
        ConcurrentHashMap<String, ConfTable> mm = new ConcurrentHashMap<String, ConfTable>();
        int i2 = 0;
        while (i2 < len) {
            ConfTable ct = new ConfTable(folder, names[i2]);
            TableImpl t = ct.createTable();
            m.set(t);
            mm.put(t.getName(), ct);
            ++i2;
        }
        this.baseFolder = folder;
        this.confMap = mm;
        this.manager = m;
        this.cache.clear();
    }

    public final void reload(String name) {
        if (!this.isInit()) {
            throw new RimDbException("TableFactory\u306f\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        ConfTable t = this.confMap.get(TableUtil.convertJavaNameByDBName(name));
        if (t == null) {
            throw new RimDbException("\u6307\u5b9a\u30c6\u30fc\u30d6\u30eb\u540d[" + name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        ConfTable cn = new ConfTable(t.baseFolder, t.confName);
        TableImpl nt = cn.createTable();
        this.confMap.put(nt.getName(), cn);
        this.manager.set(nt);
        this.cache.clear();
    }

    public final boolean isInit() {
        return this.baseFileName != null;
    }

    public final Table get(String name) {
        TableManager m = this.manager;
        if (!this.isInit()) {
            throw new RimDbException("TableFactory\u306f\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        return m.get(TableUtil.convertJavaNameByDBName(name));
    }

    public final boolean isTable(String name) {
        if (!this.isInit()) {
            throw new RimDbException("TableFactory\u306f\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        return this.confMap.containsKey(TableUtil.convertJavaNameByDBName(name));
    }

    public final int size() {
        return this.manager.size();
    }

    public final String[] getNames() {
        return this.manager.getNames();
    }

    public final String getConfigFileName() {
        return this.baseFileName;
    }

    public final String getBaseFolder() {
        return this.baseFolder;
    }

    public final CacheSearch getCacheSearch() {
        return this.cache;
    }
}

