/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.index.Index;
import org.maachang.rimdb.index.SearchPointer;
import org.maachang.rimdb.util.NAdd;
import org.maachang.rimdb.util.OList;

public abstract class BetweenPointer<W>
extends SearchPointer<Index<W>> {
    protected final int[] position = new int[]{-1, -1};
    protected W startWord;
    protected W endWord;

    @Override
    public void reset(boolean mode) {
        super.reset(mode);
        if (mode) {
            this.startWord = null;
            this.endWord = null;
        }
        this.position[0] = -1;
        this.position[1] = -1;
    }

    public void set(W start, W end) {
        if (start == null || end == null) {
            throw new RimDbException("[" + this.getClass().getName() + "]\u691c\u7d22\u6761\u4ef6\u306bnull\u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093");
        }
        this.startWord = start;
        this.endWord = end;
        this.resetFlag = false;
    }

    public abstract void parameter(Object var1, Object var2);

    @Override
    public final void parameter(Object word) {
        if (word == null) {
            throw new RimDbException("[" + this.getClass().getName() + "]\u691c\u7d22\u6761\u4ef6\u306bnull\u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093");
        }
        if (word instanceof List) {
            List n = (List)word;
            if (n.size() < 2) {
                throw new RimDbException("[" + this.getClass().getName() + "]\u691c\u7d22\u6761\u4ef6\u306f\uff12\u3064\u306e\u5b9a\u7fa9\u304c\u5fc5\u8981\u3067\u3059");
            }
            this.parameter(n.get(0), n.get(1));
        } else if (word instanceof Object[]) {
            Object[] n = (Object[])word;
            if (n.length < 2) {
                throw new RimDbException("[" + this.getClass().getName() + "]\u691c\u7d22\u6761\u4ef6\u306f\uff12\u3064\u306e\u5b9a\u7fa9\u304c\u5fc5\u8981\u3067\u3059");
            }
            this.parameter(n[0], n[1]);
        } else if (word instanceof OList) {
            OList n = (OList)word;
            if (n.size() < 2) {
                throw new RimDbException("[" + this.getClass().getName() + "]\u691c\u7d22\u6761\u4ef6\u306f\uff12\u3064\u306e\u5b9a\u7fa9\u304c\u5fc5\u8981\u3067\u3059");
            }
            this.parameter(n.get(0), n.get(1));
        } else if (word instanceof Map) {
            Object e;
            Map n = (Map)word;
            Object s = n.get("start");
            if (s == null || (e = n.get("end")) == null) {
                throw new RimDbException("[" + this.getClass().getName() + "]\u691c\u7d22\u6761\u4ef6\u306f\uff12\u3064\u306e\u5b9a\u7fa9[start,end]\u304c\u5fc5\u8981\u3067\u3059");
            }
            this.parameter(s, e);
        } else if (word.getClass().isArray()) {
            if (Array.getLength(word) < 2) {
                throw new RimDbException("[" + this.getClass().getName() + "]\u691c\u7d22\u6761\u4ef6\u306f\uff12\u3064\u306e\u5b9a\u7fa9\u304c\u5fc5\u8981\u3067\u3059");
            }
            this.parameter(Array.get(word, 0), Array.get(word, 1));
        } else {
            throw new RimDbException("[" + this.getClass().getName() + "]\u691c\u7d22\u6761\u4ef6\u306b\u306f[" + word.getClass().getName() + "]\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5b9a\u7fa9\u3067\u304d\u307e\u305b\u3093");
        }
    }

    public final int[] position() {
        return this.position;
    }

    @Override
    public final void search(Index<W> index) {
        if (this.resetFlag) {
            throw new RimDbException("[" + this.getClass().getName() + "]\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (!index.between(this.position, this.startWord, this.endWord)) {
            this.length = 0;
            this.count = 0;
            this.position[0] = -1;
            this.position[1] = -1;
        } else {
            this.length = this.position[1] - this.position[0];
            this.count = index.getMaskLine((int)this.position[1]).count - index.getMaskLine((int)this.position[0]).count + 1;
        }
    }

    @Override
    public final void get(NAdd out, Index<W> index) {
        int s = this.position[0];
        int e = this.position[1];
        int[][] indexToLine = index.getIndexToLine();
        int i = s;
        while (i <= e) {
            int[] n = indexToLine[i];
            int lenJ = n.length;
            int j = 0;
            while (j < lenJ) {
                out.add(n[j]);
                ++j;
            }
            ++i;
        }
    }

    protected void baseCopy(boolean mode, BetweenPointer o) {
        super.baseCopy(mode, o);
        if (!mode) {
            o.startWord = this.startWord;
            o.endWord = this.endWord;
            o.resetFlag = false;
        }
        o.position[0] = -1;
        o.position[1] = -1;
    }
}

