/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.index.Index;
import org.maachang.rimdb.index.SearchPointer;
import org.maachang.rimdb.util.NAdd;

public abstract class IfPointer<W>
extends SearchPointer<Index<W>> {
    protected int position = -1;
    protected W word;
    protected boolean eq;

    @Override
    public final void reset(boolean mode) {
        super.reset(mode);
        if (mode) {
            this.word = null;
        }
        this.position = -1;
    }

    public void set(W word) {
        if (word == null) {
            throw new RimDbException("[" + this.getClass().getName() + "]\u691c\u7d22\u6761\u4ef6\u306bnull\u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093");
        }
        this.word = word;
        this.resetFlag = false;
    }

    public final int position() {
        return this.position;
    }

    @Override
    public final void search(Index<W> index) {
        if (this.resetFlag) {
            throw new RimDbException("[" + this.getClass().getName() + "]\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        switch (this.type) {
            case 1: 
            case 7: {
                this.position = index.eq(this.word);
                if (this.position == -1) {
                    if (this.eq) {
                        this.length = 0;
                        this.count = 0;
                        break;
                    }
                    this.length = index.getLength();
                    this.count = index.getMaxLine();
                    break;
                }
                if (this.eq) {
                    this.length = 1;
                    this.count = index.getMaskLine((int)this.position).length;
                    break;
                }
                this.length = index.getLength() - 1;
                this.count = index.getMaxLine() - index.getMaskLine((int)this.position).length;
                break;
            }
            case 3: 
            case 4: {
                this.position = index.big(this.eq, this.word);
                if (this.position == -1) {
                    this.length = 0;
                    this.count = 0;
                    break;
                }
                this.length = index.getLength() - this.position;
                this.count = index.getMaxLine() - index.getMaskLine((int)this.position).count;
                break;
            }
            case 5: 
            case 6: {
                this.position = index.small(this.eq, this.word);
                if (this.position == -1) {
                    this.length = 0;
                    this.count = 0;
                    break;
                }
                this.length = this.position;
                this.count = index.getMaskLine((int)this.position).count + 1;
            }
        }
    }

    @Override
    public final void get(NAdd out, Index<W> index) {
        int pos = this.position;
        if (this.type != 7 && pos == -1) {
            return;
        }
        int[][] indexToLine = index.getIndexToLine();
        switch (this.type) {
            case 1: {
                int[] n = indexToLine[pos];
                int len = n.length;
                int i = 0;
                while (i < len) {
                    out.add(n[i]);
                    ++i;
                }
                break;
            }
            case 3: 
            case 4: {
                int len = index.getLength();
                int i = pos;
                while (i < len) {
                    int[] n = indexToLine[i];
                    int lenJ = n.length;
                    int j = 0;
                    while (j < lenJ) {
                        out.add(n[j]);
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 5: 
            case 6: {
                int i = 0;
                while (i <= pos) {
                    int[] n = indexToLine[i];
                    int lenJ = n.length;
                    int j = 0;
                    while (j < lenJ) {
                        out.add(n[j]);
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 7: {
                if (pos == -1) {
                    int len = index.getMaxLine();
                    int i = 0;
                    while (i < len) {
                        out.add(i);
                        ++i;
                    }
                } else {
                    int len = index.getLength();
                    int i = 0;
                    while (i < len) {
                        if (i != pos) {
                            int[] n = indexToLine[i];
                            int lenJ = n.length;
                            int j = 0;
                            while (j < lenJ) {
                                out.add(n[j]);
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                break;
            }
        }
    }

    protected void baseCopy(boolean mode, IfPointer o) {
        super.baseCopy(mode, o);
        if (!mode) {
            o.word = this.word;
            o.resetFlag = false;
        }
        o.eq = this.eq;
        o.position = -1;
    }
}

