/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index;

import org.maachang.rimdb.index.LineIndex;
import org.maachang.rimdb.index.MaskLine;
import org.maachang.rimdb.index.SortLines;
import org.maachang.rimdb.util.NAdd;

public abstract class Index<T> {
    protected int columnNo;
    protected String columnName;
    protected int maxLine;
    protected int length;
    protected int[][] indexToLine;
    protected MaskLine[] maskLine;
    protected LineIndex lineIndex;
    protected SortLines sortLineList;

    protected Index(int[][] line, int max) {
        this.maxLine = max;
        this.length = line.length;
        this.indexToLine = line;
        this.maskLine = MaskLine.create(line);
        this.lineIndex = new LineIndex(line, max);
        this.sortLineList = new SortLines(line, max);
    }

    public final void setColumnNoAndName(int no, String name) {
        this.columnNo = no;
        this.columnName = name;
    }

    public final int getColumnNo() {
        return this.columnNo;
    }

    public final String getColumnName() {
        return this.columnName;
    }

    public final int getMaxLine() {
        return this.maxLine;
    }

    public final int getLength() {
        return this.length;
    }

    public final int[][] getIndexToLine() {
        return this.indexToLine;
    }

    public final MaskLine[] getMaskLine() {
        return this.maskLine;
    }

    public final MaskLine getMaskLine(int pos) {
        return this.maskLine[pos];
    }

    public final LineIndex getLineIndex() {
        return this.lineIndex;
    }

    public final SortLines getSortLines() {
        return this.sortLineList;
    }

    public abstract int eq(T var1);

    public abstract int big(boolean var1, T var2);

    public abstract int small(boolean var1, T var2);

    public abstract boolean between(int[] var1, T var2, T var3);

    public abstract void like(NAdd var1, String var2);
}

