/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index.comparable;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.index.Index;
import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.util.NAdd;

public final class ComparableIndex
extends Index<Comparable> {
    private final Comparable[] index;

    public ComparableIndex(Comparable[] index, int[][] line, int max) {
        super(line, max);
        this.index = index;
    }

    public Comparable[] getIndex() {
        return this.index;
    }

    @Override
    public final int eq(Comparable key) {
        return IndexUtil.search(this.index, key);
    }

    @Override
    public final int big(boolean eq, Comparable key) {
        if (this.index[this.index.length - 1].compareTo(key) == -1) {
            return -1;
        }
        if (eq) {
            return IndexUtil.searchBS(true, this.index, key);
        }
        int n = IndexUtil.searchBS(true, this.index, key);
        if (key.compareTo(this.index[n]) == 0 && ++n >= this.maxLine) {
            return -1;
        }
        return n;
    }

    @Override
    public final int small(boolean eq, Comparable key) {
        if (this.index[0].compareTo(key) == 1) {
            return -1;
        }
        if (eq) {
            return IndexUtil.searchBS(false, this.index, key);
        }
        int n = IndexUtil.searchBS(false, this.index, key);
        if (key.compareTo(this.index[n]) == 0 && --n < 0) {
            return -1;
        }
        return n;
    }

    @Override
    public final boolean between(int[] out, Comparable start, Comparable end) {
        if (start.compareTo(end) == 1) {
            Comparable n = start;
            start = end;
            end = n;
        }
        out[0] = IndexUtil.searchBS(true, this.index, start);
        out[1] = IndexUtil.searchBS(false, this.index, end);
        int f = this.index[out[0]].compareTo(start);
        int e = this.index[out[1]].compareTo(end);
        return !(f < 0 && e < 0 || f > 0 && e > 0);
    }

    @Override
    public final void like(NAdd result, String key) {
        throw new RimDbException("Comparable\u3067\u306fLike\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }
}

