/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index.number32;

import java.lang.reflect.Array;
import java.util.List;
import org.maachang.rimdb.index.InPointer;
import org.maachang.rimdb.index.number32.Number32Index;
import org.maachang.rimdb.util.ConvertUtil;
import org.maachang.rimdb.util.OList;

public final class Number32In
extends InPointer<Integer> {
    protected Number32In() {
    }

    public Number32In(Number32Index index) {
        this.type = 2;
        this.columnName = index.getColumnName();
    }

    public Number32In(Number32Index index, OList<Integer> word) {
        this(index);
        this.set(word);
    }

    public Number32In(Number32Index index, int ... word) {
        this(index);
        this.set(word);
    }

    public Number32In(Number32Index index, Object word) {
        this(index);
        this.set(word);
    }

    public final void set(int ... word) {
        OList<Integer> n = new OList<Integer>();
        int len = word.length;
        int i = 0;
        while (i < len) {
            n.add(word[i]);
            ++i;
        }
        this.set(n);
    }

    public final void set(Object word) {
        this.set(Number32In.getWord(word));
    }

    @Override
    public final void parameter(Object word) {
        this.set(Number32In.getWord(word));
    }

    public static final OList<Integer> getWord(Object word) {
        if (word instanceof List) {
            List n = (List)word;
            int len = n.size();
            OList<Integer> ret = new OList<Integer>(len);
            int i = 0;
            while (i < len) {
                ret.add(Number32In.convert(n.get(i)));
                ++i;
            }
            return ret;
        }
        if (word instanceof int[]) {
            int[] n = (int[])word;
            int len = n.length;
            OList<Integer> ret = new OList<Integer>(len);
            int i = 0;
            while (i < len) {
                ret.add(n[i]);
                ++i;
            }
            return ret;
        }
        if (word instanceof Integer[]) {
            Integer[] n = (Integer[])word;
            int len = n.length;
            OList<Integer> ret = new OList<Integer>(len);
            int i = 0;
            while (i < len) {
                ret.add(n[i]);
                ++i;
            }
            return ret;
        }
        if (word instanceof Object[]) {
            Object[] n = (Object[])word;
            int len = n.length;
            OList<Integer> ret = new OList<Integer>(len);
            int i = 0;
            while (i < len) {
                ret.add(Number32In.convert(n[i]));
                ++i;
            }
            return ret;
        }
        if (word instanceof OList) {
            OList n = (OList)word;
            if (n.size() != 0 && n.get(0) instanceof Integer) {
                return (OList)word;
            }
            int len = n.size();
            OList<Integer> ret = new OList<Integer>(len);
            int i = 0;
            while (i < len) {
                ret.add(Number32In.convert(n.get(i)));
                ++i;
            }
            return ret;
        }
        if (word.getClass().isArray()) {
            int len = Array.getLength(word);
            OList<Integer> ret = new OList<Integer>(len);
            int i = 0;
            while (i < len) {
                ret.add(Number32In.convert(Array.get(word, i)));
                ++i;
            }
            return ret;
        }
        OList<Integer> ret = new OList<Integer>(1);
        ret.add(Number32In.convert(word));
        return ret;
    }

    protected static final int convert(Object o) {
        if (!ConvertUtil.isNumeric(o)) {
            return (int)ConvertUtil.convertSqlTime(o).getTime();
        }
        return ConvertUtil.convertInt(o);
    }

    @Override
    public final Number32In copy(boolean mode) {
        Number32In ret = new Number32In();
        this.baseCopy(mode, ret);
        return ret;
    }
}

