/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index.number64;

import java.lang.reflect.Array;
import java.util.Date;
import java.util.List;
import org.maachang.rimdb.index.InPointer;
import org.maachang.rimdb.index.number64.Number64Index;
import org.maachang.rimdb.util.ConvertUtil;
import org.maachang.rimdb.util.OList;

public final class Number64In
extends InPointer<Long> {
    protected Number64In() {
    }

    public Number64In(Number64Index index) {
        this.type = 2;
        this.columnName = index.getColumnName();
    }

    public Number64In(Number64Index index, OList<Long> word) {
        this(index);
        this.set(word);
    }

    public Number64In(Number64Index index, long ... word) {
        this(index);
        this.set(word);
    }

    public Number64In(Number64Index index, Object word) {
        this(index);
        this.set(word);
    }

    public final void set(long ... word) {
        OList<Long> n = new OList<Long>();
        int len = word.length;
        int i = 0;
        while (i < len) {
            n.add(word[i]);
            ++i;
        }
        this.set(n);
    }

    public final void set(Object word) {
        this.set(Number64In.getWord(word));
    }

    @Override
    public final void parameter(Object word) {
        this.set(Number64In.getWord(word));
    }

    public static final OList<Long> getWord(Object word) {
        if (word instanceof List) {
            List n = (List)word;
            int len = n.size();
            OList<Long> ret = new OList<Long>(len);
            int i = 0;
            while (i < len) {
                ret.add(Number64In.convert(n.get(i)));
                ++i;
            }
            return ret;
        }
        if (word instanceof long[]) {
            long[] n = (long[])word;
            int len = n.length;
            OList<Long> ret = new OList<Long>(len);
            int i = 0;
            while (i < len) {
                ret.add(n[i]);
                ++i;
            }
            return ret;
        }
        if (word instanceof Long[]) {
            Long[] n = (Long[])word;
            int len = n.length;
            OList<Long> ret = new OList<Long>(len);
            int i = 0;
            while (i < len) {
                ret.add(n[i]);
                ++i;
            }
            return ret;
        }
        if (word instanceof Object[]) {
            Object[] n = (Object[])word;
            int len = n.length;
            OList<Long> ret = new OList<Long>(len);
            int i = 0;
            while (i < len) {
                ret.add(Number64In.convert(n[i]));
                ++i;
            }
            return ret;
        }
        if (word instanceof OList) {
            OList n = (OList)word;
            if (n.size() != 0 && n.get(0) instanceof Long) {
                return (OList)word;
            }
            int len = n.size();
            OList<Long> ret = new OList<Long>(len);
            int i = 0;
            while (i < len) {
                ret.add(Number64In.convert(n.get(i)));
                ++i;
            }
            return ret;
        }
        if (word.getClass().isArray()) {
            int len = Array.getLength(word);
            OList<Long> ret = new OList<Long>(len);
            int i = 0;
            while (i < len) {
                ret.add(Number64In.convert(Array.get(word, i)));
                ++i;
            }
            return ret;
        }
        OList<Long> ret = new OList<Long>(1);
        ret.add(Number64In.convert(word));
        return ret;
    }

    protected static final long convert(Object o) {
        if (!ConvertUtil.isNumeric(o)) {
            if (o instanceof java.sql.Date) {
                return ConvertUtil.convertSqlDate(o).getTime();
            }
            if (o instanceof Date) {
                return ((Date)o).getTime();
            }
            if (o instanceof String) {
                return ConvertUtil.convertDate(o).getTime();
            }
        }
        return ConvertUtil.convertInt(o).intValue();
    }

    @Override
    public final Number64In copy(boolean mode) {
        Number64In ret = new Number64In();
        this.baseCopy(mode, ret);
        return ret;
    }
}

