/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index.number64;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.index.Index;
import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.util.NAdd;

public final class Number64Index
extends Index<Long> {
    protected final long[] index;

    public Number64Index(long[] index, int[][] line, int max) {
        super(line, max);
        this.index = index;
    }

    public long[] getIndex() {
        return this.index;
    }

    @Override
    public final int eq(Long key) {
        return IndexUtil.searchLong(this.index, key);
    }

    @Override
    public final int big(boolean eq, Long key) {
        if (this.index[this.index.length - 1] < key) {
            return -1;
        }
        if (eq) {
            return IndexUtil.searchLongBS(true, this.index, key);
        }
        int n = IndexUtil.searchLongBS(true, this.index, key);
        if (this.index[n] == key && ++n >= this.maxLine) {
            return -1;
        }
        return n;
    }

    @Override
    public final int small(boolean eq, Long key) {
        if (this.index[0] > key) {
            return -1;
        }
        if (eq) {
            return IndexUtil.searchLongBS(false, this.index, key);
        }
        int n = IndexUtil.searchLongBS(false, this.index, key);
        if (this.index[n] == key && --n < 0) {
            return -1;
        }
        return n;
    }

    @Override
    public final boolean between(int[] out, Long start, Long end) {
        if (start > end) {
            Long n = start;
            start = end;
            end = n;
        }
        out[0] = IndexUtil.searchLongBS(true, this.index, start);
        out[1] = IndexUtil.searchLongBS(false, this.index, end);
        return !(this.index[out[0]] < start && this.index[out[1]] < end || this.index[out[0]] > start && this.index[out[1]] > end);
    }

    @Override
    public final void like(NAdd result, String key) {
        throw new RimDbException("Number64\u3067\u306fLike\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }
}

