/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index.numberFloat;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.index.Index;
import org.maachang.rimdb.util.NAdd;

public final class NumberFloatIndex
extends Index<Double> {
    protected final double[] index;

    public static final int search(double[] a, double key) {
        int low = 0;
        int high = a.length - 1;
        long keyBits = Double.doubleToLongBits(key);
        while (low <= high) {
            int cmp;
            double d;
            int mid = low + high >>> 1;
            double midVal = a[mid];
            if (d < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == keyBits ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static final int searchBS(boolean big, double[] a, double key) {
        int low = 0;
        int high = a.length - 1;
        long keyBits = Double.doubleToLongBits(key);
        int mid = 0;
        while (low <= high) {
            int cmp;
            double d;
            mid = low + high >>> 1;
            double midVal = a[mid];
            if (d < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == keyBits ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        if (big) {
            if (a[mid] > key) {
                return mid;
            }
            if (a.length <= mid + 1) {
                return a.length - 1;
            }
            return mid + 1;
        }
        if (a[mid] > key) {
            if (mid <= 0) {
                return 0;
            }
            return mid - 1;
        }
        return mid;
    }

    public NumberFloatIndex(double[] index, int[][] line, int max) {
        super(line, max);
        this.index = index;
    }

    public double[] getIndex() {
        return this.index;
    }

    @Override
    public final int eq(Double key) {
        return NumberFloatIndex.search(this.index, key);
    }

    @Override
    public final int big(boolean eq, Double key) {
        if (this.index[this.index.length - 1] < key) {
            return -1;
        }
        if (eq) {
            return NumberFloatIndex.searchBS(true, this.index, key);
        }
        int n = NumberFloatIndex.searchBS(true, this.index, key);
        if (this.index[n] == key && ++n >= this.maxLine) {
            return -1;
        }
        return n;
    }

    @Override
    public final int small(boolean eq, Double key) {
        if (this.index[0] > key) {
            return -1;
        }
        if (eq) {
            return NumberFloatIndex.searchBS(false, this.index, key);
        }
        int n = NumberFloatIndex.searchBS(false, this.index, key);
        if (this.index[n] == key && --n < 0) {
            return -1;
        }
        return n;
    }

    @Override
    public final boolean between(int[] out, Double start, Double end) {
        if (start > end) {
            Double n = start;
            start = end;
            end = n;
        }
        out[0] = NumberFloatIndex.searchBS(true, this.index, start);
        out[1] = NumberFloatIndex.searchBS(false, this.index, end);
        return (this.index[out[0]] >= start || this.index[out[1]] >= end) && (this.index[out[0]] <= start || this.index[out[1]] <= end);
    }

    @Override
    public final void like(NAdd result, String key) {
        throw new RimDbException("Float\u3067\u306fLike\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }
}

