/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index.position;

import java.util.Arrays;
import org.maachang.rimdb.index.Mask;
import org.maachang.rimdb.index.position.PositionIndex;
import org.maachang.rimdb.table.array.IntegerArray;
import org.maachang.rimdb.util.NList;
import org.maachang.rimdb.util.NOKeyValue;

public final class CreatePositionIndex {
    protected int accuracy;
    protected int[] xArray;
    protected int[] yArray;

    public CreatePositionIndex(int accuracy, IntegerArray xArray, IntegerArray yArray) {
        if (accuracy <= 0) {
            accuracy = 1;
        }
        this.accuracy = accuracy;
        this.xArray = xArray.getArray();
        this.yArray = yArray.getArray();
    }

    public PositionIndex create() {
        PositionIndex ret = CreatePositionIndex._create(this.accuracy, this.xArray, this.yArray);
        this.xArray = null;
        this.yArray = null;
        return ret;
    }

    private static final PositionIndex _create(int accuracy, int[] xList, int[] yList) {
        int len = xList.length;
        NOKeyValue<SrcXIndex> idx = new NOKeyValue<SrcXIndex>();
        int i = 0;
        while (i < len) {
            SrcYIndex sy;
            int x = xList[i] / accuracy;
            int y = yList[i] / accuracy;
            SrcXIndex sx = (SrcXIndex)idx.get(x);
            if (sx == null) {
                sx = new SrcXIndex();
                sx.x = x;
                idx.put(x, sx);
            }
            if ((sy = sx.yList.get(y)) == null) {
                sy = new SrcYIndex();
                sy.y = y;
                sx.yList.put(y, sy);
            }
            sy.lines.add(i);
            ++i;
        }
        len = idx.size();
        Object[] list = new SrcXIndex[len];
        idx.reset();
        i = 0;
        while (idx.hasNext()) {
            list[i++] = (SrcXIndex)idx.nextValue();
        }
        idx.clear();
        idx = null;
        Arrays.sort(list);
        len = list.length;
        int[] xIndex = new int[len];
        int[][] yIndex = new int[len][];
        PositionIndex.YLineIndex[][] yLineIndex = new PositionIndex.YLineIndex[len][];
        i = 0;
        while (i < len) {
            NOKeyValue<SrcYIndex> yidx = ((SrcXIndex)list[i]).yList;
            int lenJ = yidx.size();
            Object[] ylist = new SrcYIndex[lenJ];
            int j = 0;
            yidx.reset();
            while (yidx.hasNext()) {
                ylist[j++] = yidx.nextValue();
            }
            yidx.clear();
            yidx = null;
            ((SrcXIndex)list[i]).yList = null;
            Arrays.sort(ylist);
            xIndex[i] = ((SrcXIndex)list[i]).x;
            ((SrcXIndex)list[i]).x = null;
            list[i] = null;
            CreatePositionIndex.createYIndex(yIndex, yLineIndex, i, (SrcYIndex[])ylist);
            ylist = null;
            ++i;
        }
        return new PositionIndex(accuracy, xList, yList, xIndex, yIndex, yLineIndex);
    }

    private static final void createYIndex(int[][] outY, PositionIndex.YLineIndex[][] outYLine, int no, SrcYIndex[] yIndex) {
        int len = yIndex.length;
        int[] yPosIndex = new int[len];
        PositionIndex.YLineIndex[] yLineIndex = new PositionIndex.YLineIndex[len];
        outY[no] = yPosIndex;
        outYLine[no] = yLineIndex;
        NOKeyValue<Mask> maskList = new NOKeyValue<Mask>();
        int i = 0;
        while (i < len) {
            PositionIndex.YLineIndex yline;
            Mask msk;
            SrcYIndex y = yIndex[i];
            yPosIndex[i] = y.y;
            yIndex[i] = null;
            NList list = y.lines;
            int lenJ = list.size();
            int j = 0;
            while (j < lenJ) {
                int n = list.get(j);
                msk = (Mask)maskList.get(n >> 5);
                if (msk == null) {
                    maskList.put(n >> 5, new Mask(1 << (n & 0x1F)));
                } else {
                    msk.value |= 1 << (n & 0x1F);
                }
                ++j;
            }
            msk = null;
            list = null;
            lenJ = maskList.size();
            int[] yLine = new int[lenJ];
            int[] yMask = new int[lenJ];
            maskList.reset();
            j = 0;
            while (maskList.hasNext()) {
                yLine[j] = maskList.next();
                yMask[j++] = ((Mask)maskList.nextValue()).value;
            }
            maskList.clear();
            yLineIndex[i] = yline = new PositionIndex.YLineIndex();
            yline.yLine = yLine;
            yline.yMask = yMask;
            yLine = null;
            yMask = null;
            yline = null;
            ++i;
        }
    }

    private static final class SrcXIndex
    implements Comparable {
        Integer x;
        NOKeyValue<SrcYIndex> yList = new NOKeyValue();

        private SrcXIndex() {
        }

        public int compareTo(Object n) {
            return this.x.compareTo(((SrcXIndex)n).x);
        }
    }

    private static final class SrcYIndex
    implements Comparable {
        Integer y;
        final NList lines = new NList();

        private SrcYIndex() {
        }

        public int compareTo(Object n) {
            return this.y.compareTo(((SrcYIndex)n).y);
        }
    }
}

