/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index.string;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.index.Index;
import org.maachang.rimdb.index.string.IString;
import org.maachang.rimdb.index.string.SearchLike;
import org.maachang.rimdb.util.NAdd;

public final class StringIndex
extends Index<IString> {
    protected final IString[] index;
    protected final Object ngram;

    public static final int search(IString[] a, IString key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = a[mid].compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static final int searchBS(boolean big, IString[] a, IString key) {
        int low = 0;
        int high = a.length - 1;
        int mid = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            int cmp = a[mid].compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        if (big) {
            if (a[mid].compareTo(key) > 0) {
                return mid;
            }
            if (a.length <= mid + 1) {
                return a.length - 1;
            }
            return mid + 1;
        }
        if (a[mid].compareTo(key) > 0) {
            if (mid <= 0) {
                return 0;
            }
            return mid - 1;
        }
        return mid;
    }

    public StringIndex(IString[] index, Object ngram, int[][] line, int max) {
        super(line, max);
        this.index = index;
        this.ngram = ngram;
    }

    public IString[] getIndex() {
        return this.index;
    }

    public Object getNgram() {
        return this.ngram;
    }

    @Override
    public final int eq(IString key) {
        return StringIndex.search(this.index, key);
    }

    @Override
    public final int big(boolean eq, IString key) {
        if (this.index[this.index.length - 1].compareTo(key) == -1) {
            return -1;
        }
        if (eq) {
            return StringIndex.searchBS(true, this.index, key);
        }
        int n = StringIndex.searchBS(true, this.index, key);
        if (key.equals(this.index[n]) && ++n >= this.maxLine) {
            return -1;
        }
        return n;
    }

    @Override
    public final int small(boolean eq, IString key) {
        if (this.index[0].compareTo(key) == 1) {
            return -1;
        }
        if (eq) {
            return StringIndex.searchBS(false, this.index, key);
        }
        int n = StringIndex.searchBS(false, this.index, key);
        if (key.equals(this.index[n]) && --n < 0) {
            return -1;
        }
        return n;
    }

    @Override
    public final boolean between(int[] out, IString start, IString end) {
        if (start.compareTo(end) == 1) {
            IString n = start;
            start = end;
            end = n;
        }
        out[0] = StringIndex.searchBS(true, this.index, start);
        out[1] = StringIndex.searchBS(false, this.index, end);
        int f = this.index[out[0]].compareTo(start);
        int e = this.index[out[1]].compareTo(end);
        return !(f < 0 && e < 0 || f > 0 && e > 0);
    }

    @Override
    public final void like(NAdd result, String key) {
        try {
            if (this.ngram != null) {
                SearchLike.searchNGram(result, this.ngram, SearchLike.create(key));
            } else {
                SearchLike.search(result, this.index, SearchLike.create(key));
            }
        }
        catch (RimDbException ri) {
            throw ri;
        }
        catch (Exception e) {
            throw new RimDbException(e);
        }
    }
}

