/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.search;

import org.maachang.rimdb.Row;
import org.maachang.rimdb.SearchResult;
import org.maachang.rimdb.table.RowImpl;
import org.maachang.rimdb.table.TableImpl;

public final class SearchResultImpl
implements SearchResult {
    private final TableImpl table;
    private final RowImpl row;
    private final int[] lines;
    private final int length;
    private int cursor;
    private int offset;
    private int limit;

    protected SearchResultImpl(TableImpl table, int[] lines, int length) {
        this.table = table;
        this.row = table.getRow();
        this.lines = lines;
        this.length = length;
        this.cursor = 0;
        this.offset = 0;
        this.limit = this.getMax();
    }

    protected final SearchResultImpl setDefine(int offset, int limit) {
        int max = this.getMax();
        if (offset < 0) {
            offset = 0;
        }
        if (limit < 0) {
            limit = max - offset;
        }
        if (offset >= max) {
            offset = max;
            limit = 0;
        } else if (limit >= max - offset) {
            limit = max - offset;
        }
        this.offset = offset;
        this.limit = limit;
        if (this.cursor < offset) {
            this.cursor = offset;
        }
        return this;
    }

    @Override
    public final void clear() {
        this.row.clear();
        this.cursor = this.offset;
    }

    @Override
    public final String getName() {
        return this.table.getName();
    }

    @Override
    public final TableImpl getTable() {
        return this.table;
    }

    @Override
    public final Row get() {
        if (this.length == 0) {
            return null;
        }
        if (this.length < 0) {
            return this.row.position(this.cursor);
        }
        return this.row.position(this.lines[this.cursor]);
    }

    @Override
    public final SearchResultImpl first() {
        if (this.length != 0) {
            this.cursor = this.offset;
        }
        return this;
    }

    @Override
    public final SearchResultImpl last() {
        if (this.length != 0) {
            this.cursor = this.offset + this.limit;
        }
        return this;
    }

    @Override
    public final SearchResultImpl setRow(int no) {
        if (this.length != 0) {
            this.cursor = no <= this.offset ? this.offset : (no >= this.offset + this.limit ? this.offset + this.limit : no);
        }
        return this;
    }

    @Override
    public final int getRow() {
        return this.cursor;
    }

    @Override
    public final int getLength() {
        return this.limit;
    }

    @Override
    public final int getMax() {
        if (this.length <= 0) {
            if (this.length == 0) {
                return 0;
            }
            return this.table.length();
        }
        return this.length;
    }

    @Override
    public final boolean hasNext() {
        if (this.length == 0) {
            return false;
        }
        return this.cursor < this.offset + this.limit;
    }

    @Override
    public final Row next() {
        if (this.length == 0 || this.cursor >= this.offset + this.limit) {
            return null;
        }
        if (this.length < 0) {
            return this.row.position(this.cursor++);
        }
        return this.row.position(this.lines[this.cursor++]);
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }
}

