/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.table;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.table.CsvTable;
import org.maachang.rimdb.table.JDBCTable;
import org.maachang.rimdb.table.LoadTable;
import org.maachang.rimdb.table.TableImpl;
import org.maachang.rimdb.util.Config;
import org.maachang.rimdb.util.ConvertUtil;
import org.maachang.rimdb.util.FileUtil;
import org.maachang.rimdb.util.OList;

public final class ConfTable {
    protected static final String SECTION = "table";
    public String baseFolder;
    public String confName;
    public String name;

    public ConfTable(String baseFolder, String confName) {
        String file;
        baseFolder = FileUtil.getFullPath(baseFolder);
        if (!baseFolder.endsWith("/")) {
            baseFolder = String.valueOf(baseFolder) + "/";
        }
        if (!FileUtil.isFile(file = this.getPathName(baseFolder, confName))) {
            throw new RimDbException("\u6307\u5b9a\u30b3\u30f3\u30d5\u30a3\u30b0\u30d5\u30a1\u30a4\u30eb[" + file + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.baseFolder = baseFolder;
        this.confName = confName;
        this.name = FileUtil.getFullPath(file);
    }

    public final TableImpl createTable() {
        Config conf = this.getConf();
        String type = conf.getString(SECTION, "readType", 0);
        if (ConvertUtil.eqEng("csv", type)) {
            return this.readCsv(conf);
        }
        if (ConvertUtil.eqEng("jdbc", type)) {
            return this.readJDBC(conf);
        }
        throw new RimDbException("\u6307\u5b9a\u30b3\u30f3\u30d5\u30a3\u30b0\u30d5\u30a1\u30a4\u30eb[" + this.name + "]\u306e\u5c5e\u6027[" + type + "]\u304c\u4e0d\u660e\u3067\u3059");
    }

    private final String getPathName(String base, String file) {
        if (file.indexOf("/") == -1 && file.indexOf("\\") == -1) {
            return FileUtil.getFullPath(String.valueOf(base) + file);
        }
        return FileUtil.getFullPath(file);
    }

    private final Config getConf() {
        Config ret;
        try {
            ret = Config.read(this.name);
        }
        catch (Exception e) {
            throw new RimDbException(e);
        }
        if (!ret.isSection(SECTION)) {
            throw new RimDbException("\u6307\u5b9a\u30b3\u30f3\u30d5\u30a3\u30b0\u30d5\u30a1\u30a4\u30eb[" + this.name + "]\u306frimDB\u30b3\u30f3\u30d5\u30a3\u30b0\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        return ret;
    }

    private final TableImpl readCsv(Config conf) {
        String csvFile = conf.getString(SECTION, "csv", 0);
        String file = this.getPathName(this.baseFolder, csvFile);
        if (!FileUtil.isFile(file)) {
            throw new RimDbException("\u6307\u5b9aCSV\u30d5\u30a1\u30a4\u30eb[" + file + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        String charset = conf.getString(SECTION, "charset", 0);
        if (charset == null || charset.length() == 0) {
            charset = "Windows-31J";
        }
        boolean header = conf.getBoolean(SECTION, "header", 0);
        CsvTable createTable = new CsvTable(header, charset, file);
        this.readTableInfo(createTable, conf);
        return createTable.create();
    }

    private final TableImpl readJDBC(Config conf) {
        String driver = conf.getString(SECTION, "driver", 0);
        String url = conf.getString(SECTION, "url", 0);
        String user = conf.getString(SECTION, "user", 0);
        String passwd = conf.getString(SECTION, "passwd", 0);
        String sql = conf.getString(SECTION, "sql", 0);
        if (driver == null || (driver = driver.trim()).length() <= 0) {
            throw new RimDbException("JDBC\u30c9\u30e9\u30a4\u30d0\u30fc\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (url == null || (url = url.trim()).length() <= 0) {
            throw new RimDbException("JDBC\u63a5\u7d9a\u5148\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (sql == null || (sql = sql.trim()).length() <= 0) {
            throw new RimDbException("JDBC\u63a5\u7d9aSQL\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        JDBCTable createTable = new JDBCTable(driver, url, user, passwd, sql);
        this.readTableInfo(createTable, conf);
        return createTable.create();
    }

    private final void readTableInfo(LoadTable createTable, Config conf) {
        String[] ngram;
        String[] index;
        String tableName = conf.getString(SECTION, SECTION, 0);
        if (tableName == null || (tableName = tableName.trim()).length() == 0) {
            throw new RimDbException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + conf.getSrcName() + "]\u306e\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u306b\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        String[] columnNames = ConfTable.getColumnNames(conf, SECTION);
        int[] types = ConfTable.getColumnTypes(conf, SECTION, tableName, columnNames);
        if (columnNames == null || columnNames.length == 0 || types == null || types.length == 0) {
            throw new RimDbException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + conf.getSrcName() + "]\u306e\u30c6\u30fc\u30d6\u30eb[" + tableName + "]\u5b9a\u7fa9\u306b\u30ab\u30e9\u30e0\u5b9a\u7fa9\u6761\u4ef6\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        String[] uniqueNames = ConfTable.getStringArray(conf, SECTION, "unique");
        if (uniqueNames == null || uniqueNames.length == 0) {
            uniqueNames = null;
        }
        if ((index = ConfTable.getStringArray(conf, SECTION, "index")) == null || index.length == 0) {
            index = null;
        }
        if ((ngram = ConfTable.getStringArray(conf, SECTION, "ngram")) == null || ngram.length == 0) {
            ngram = null;
        }
        String positionX = conf.getString(SECTION, "positionX", 0);
        String positionY = conf.getString(SECTION, "positionY", 0);
        Integer accuracy = conf.getInt(SECTION, "accuracy", 0);
        if (positionX == null || (positionX = positionX.trim()).length() == 0 || positionY == null || (positionY = positionY.trim()).length() == 0) {
            positionX = null;
            positionY = null;
            accuracy = -1;
        } else if (accuracy == null || accuracy <= 0) {
            accuracy = 1;
        }
        createTable.define(tableName, columnNames, types, uniqueNames, index, ngram, positionX, positionY, accuracy);
    }

    private static final String[] getStringArray(Config conf, String section, String name) {
        int len = conf.size(section, name);
        if (len <= 0) {
            return null;
        }
        String[] ret = new String[len];
        int i = 0;
        while (i < len) {
            ret[i] = conf.getString(section, name, i).trim();
            ++i;
        }
        return ret;
    }

    private static final String[] getColumnNames(Config conf, String section) {
        String[] list = conf.getKeys(section);
        OList<String> res = new OList<String>();
        int len = list.length;
        int i = 0;
        while (i < len) {
            if (list[i].startsWith(".")) {
                res.add(list[i].substring(1).trim());
            }
            ++i;
        }
        len = res.size();
        String[] ret = new String[len];
        System.arraycopy(res.toArray(), 0, ret, 0, len);
        return ret;
    }

    private static final int[] getColumnTypes(Config conf, String section, String tableName, String[] columns) {
        int len = columns.length;
        int[] ret = new int[len];
        int i = 0;
        while (i < len) {
            String val = conf.getString(section, "." + columns[i], 0);
            if (val == null || (val = val.trim()).length() <= 0) {
                throw new RimDbException("\u30c6\u30fc\u30d6\u30eb[" + tableName + "]\u5b9a\u7fa9\u306e\u30ab\u30e9\u30e0[" + columns[i] + "]\u306b\u5bfe\u3059\u308b\u578b\u5b9a\u7fa9\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (ConvertUtil.eqEng("bool", val) || ConvertUtil.eqEng("boolean", val)) {
                ret[i] = 1;
            } else if (ConvertUtil.eqEng("int", val) || ConvertUtil.eqEng("integer", val)) {
                ret[i] = 2;
            } else if ("long".equals(val) || ConvertUtil.eqEng("bigint", val) || ConvertUtil.eqEng("biginteger", val)) {
                ret[i] = 3;
            } else if (ConvertUtil.eqEng("float", val) || ConvertUtil.eqEng("double", val) || ConvertUtil.eqEng("real", val) || ConvertUtil.eqEng("decimal", val) || ConvertUtil.eqEng("numeric", val)) {
                ret[i] = 4;
            } else if (ConvertUtil.eqEng("string", val) || ConvertUtil.eqEng("char", val) || ConvertUtil.eqEng("varchar", val) || ConvertUtil.eqEng("text", val)) {
                ret[i] = 8;
            } else if (ConvertUtil.eqEng("date", val)) {
                ret[i] = 5;
            } else if (ConvertUtil.eqEng("time", val)) {
                ret[i] = 6;
            } else if (ConvertUtil.eqEng("timestamp", val) || ConvertUtil.eqEng("datetime", val)) {
                ret[i] = 7;
            } else if (ConvertUtil.eqEng("object", val)) {
                ret[i] = 9;
            } else {
                throw new RimDbException("\u30c6\u30fc\u30d6\u30eb[" + tableName + "]\u5b9a\u7fa9\u306e\u30ab\u30e9\u30e0[" + columns[i] + "]\u306b\u5bfe\u3059\u308b\u578b\u5b9a\u7fa9[" + val + "]\u306f\u4e0d\u6b63\u3067\u3059");
            }
            ++i;
        }
        return ret;
    }
}

