/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.table;

import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.index.Index;
import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.index.bool.CreateBoolIndex;
import org.maachang.rimdb.index.comparable.CreateComparableIndex;
import org.maachang.rimdb.index.number32.CreateNumber32Index;
import org.maachang.rimdb.index.number64.CreateNumber64Index;
import org.maachang.rimdb.index.numberFloat.CreateNumberFloatIndex;
import org.maachang.rimdb.index.position.CreatePositionIndex;
import org.maachang.rimdb.index.position.PositionIndex;
import org.maachang.rimdb.index.string.CreateStringIndex;
import org.maachang.rimdb.table.ColumnName;
import org.maachang.rimdb.table.Columns;
import org.maachang.rimdb.table.Indexs;
import org.maachang.rimdb.table.TableImpl;
import org.maachang.rimdb.table.Uniques;
import org.maachang.rimdb.table.array.BooleanArray;
import org.maachang.rimdb.table.array.ColumnArray;
import org.maachang.rimdb.table.array.DateArray;
import org.maachang.rimdb.table.array.FloatArray;
import org.maachang.rimdb.table.array.IntegerArray;
import org.maachang.rimdb.table.array.LongArray;
import org.maachang.rimdb.table.array.ObjectArray;
import org.maachang.rimdb.table.array.StringArray;
import org.maachang.rimdb.table.array.TimeArray;
import org.maachang.rimdb.table.array.TimestampArray;
import org.maachang.rimdb.table.array.UniqueId;
import org.maachang.rimdb.util.ConvertUtil;
import org.maachang.rimdb.util.OList;

public final class CreateTable {
    private final String name;
    private final int[] types;
    private final String[] names;
    private final String[] uniqueNames;
    private final String[] indexNames;
    private final String[] ngramNames;
    private final String positionX;
    private final String positionY;
    private final int accuracy;
    private final ColumnName[] columnNames;
    private final OList<Object[]> list;
    private final int length;
    private int position;

    public CreateTable(String name, String[] names, int[] types, String[] uniqueNames, String[] indexNames, String[] ngramNames, String positionX, String positionY, int accuracy) {
        int len = types.length;
        Object[] cc = new ColumnName[len];
        int i = 0;
        while (i < len) {
            cc[i] = new ColumnName(names[i], i);
            ++i;
        }
        Arrays.sort(cc);
        if (ngramNames != null && ngramNames.length > 0) {
            Arrays.sort(ngramNames);
        }
        this.name = name;
        this.names = names;
        this.types = types;
        this.uniqueNames = uniqueNames;
        this.indexNames = indexNames;
        this.ngramNames = ngramNames;
        if (positionX != null && positionY != null) {
            this.positionX = positionX;
            this.positionY = positionY;
            this.accuracy = accuracy <= 0 ? 1 : accuracy;
        } else {
            this.positionX = null;
            this.positionY = null;
            this.accuracy = -1;
        }
        this.columnNames = cc;
        this.length = len;
        this.list = new OList();
        this.position = -1;
    }

    public final String getName() {
        return this.name;
    }

    public final int length() {
        return this.length;
    }

    public final String[] getColumns() {
        return this.names;
    }

    public final void next() {
        this.list.add(new Object[this.length]);
        ++this.position;
    }

    public final int position() {
        return this.position;
    }

    public final void set(Object ... value) {
        int len = value.length;
        System.arraycopy(value, 0, this.list.get(this.position), 0, len);
    }

    public final void set(int no, Object value) {
        this.list.get((int)this.position)[no] = value;
    }

    public final void set(String name, Object value) {
        int p = IndexUtil.search(this.columnNames, (Comparable)((Object)name));
        if (p != -1) {
            this.list.get((int)this.position)[p] = value;
        }
    }

    public final TableImpl getTable() {
        try {
            int[] positionColumnNo;
            PositionIndex posIdx;
            Index[] indexList;
            int[] indexColumnNo;
            Uniques uniqueTable;
            Object[] rows;
            if (this.position == -1) {
                return new TableImpl(new Columns(null, this.types, this.columnNames), null, null, this.name, 0);
            }
            int len = this.list.size();
            int[] typeList = this.types;
            int columnLength = this.length;
            Object[] columnList = new Object[columnLength];
            int i = 0;
            while (i < columnLength) {
                columnList[i] = CreateTable.createArray(typeList[i], len, i);
                ++i;
            }
            i = 0;
            while (i < len) {
                rows = this.list.get(i);
                int j = 0;
                while (j < columnLength) {
                    CreateTable.setArray(columnList[j], typeList[j], i, rows[j]);
                    ++j;
                }
                ++i;
            }
            rows = null;
            this.list.clear();
            this.position = -1;
            ColumnArray[] arrays = new ColumnArray[columnLength];
            i = 0;
            while (i < columnLength) {
                arrays[i] = CreateTable.createColumnArray(typeList[i], columnList[i]);
                ++i;
            }
            Columns columnTable = new Columns(arrays, typeList, this.columnNames);
            arrays = null;
            if (this.uniqueNames != null && this.uniqueNames.length > 0) {
                int[] uniqueColumnNo = CreateTable.createColumnNoList(typeList, new int[]{2, 3}, this.names, this.uniqueNames);
                Arrays.sort(uniqueColumnNo);
                int uniqueLength = uniqueColumnNo.length;
                UniqueId[] uniqueList = new UniqueId[uniqueLength];
                i = 0;
                while (i < uniqueLength) {
                    uniqueList[i] = CreateTable.createUniqueId(typeList[uniqueColumnNo[i]], columnList[uniqueColumnNo[i]]);
                    ++i;
                }
                uniqueTable = new Uniques(uniqueColumnNo, uniqueList);
            } else {
                uniqueTable = null;
            }
            if (this.indexNames != null && this.indexNames.length > 0) {
                indexColumnNo = CreateTable.createColumnNoList(typeList, null, this.names, this.indexNames);
                Arrays.sort(indexColumnNo);
                int indexLength = indexColumnNo.length;
                indexList = new Index[indexLength];
                if (this.ngramNames != null && this.ngramNames.length > 0) {
                    i = 0;
                    while (i < indexLength) {
                        indexList[i] = IndexUtil.search((Comparable[])this.ngramNames, (Comparable)((Object)this.columnNames[indexColumnNo[i]].name)) != -1 ? CreateTable.createIndex(this.columnNames[indexColumnNo[i]].name, typeList[indexColumnNo[i]], columnList[indexColumnNo[i]], true) : CreateTable.createIndex(this.columnNames[indexColumnNo[i]].name, typeList[indexColumnNo[i]], columnList[indexColumnNo[i]], false);
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < indexLength) {
                        indexList[i] = CreateTable.createIndex(this.columnNames[indexColumnNo[i]].name, typeList[indexColumnNo[i]], columnList[indexColumnNo[i]], false);
                        ++i;
                    }
                }
            } else {
                indexList = null;
                indexColumnNo = null;
            }
            if (this.positionX != null && this.positionY != null) {
                int s = CreateTable.getColumnNo(this.names, this.positionX);
                int e = CreateTable.getColumnNo(this.names, this.positionY);
                if (s == -1 || e == -1) {
                    throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306e\u30ab\u30e9\u30e0\u540d[x=" + this.positionX + ":" + s + "][y=" + this.positionY + ":" + e + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                }
                if (columnTable.list[s].getType() != 2) {
                    throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9X\u6761\u4ef6[" + this.positionX + "]\u306e\u30ab\u30e9\u30e0\u30bf\u30a4\u30d7\u306fint\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
                }
                if (columnTable.list[e].getType() != 2) {
                    throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9Y\u6761\u4ef6[" + this.positionY + "]\u306e\u30ab\u30e9\u30e0\u30bf\u30a4\u30d7\u306fint\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
                }
                CreatePositionIndex n = new CreatePositionIndex(this.accuracy, (IntegerArray)columnTable.list[s], (IntegerArray)columnTable.list[e]);
                posIdx = n.create();
                positionColumnNo = new int[]{s, e};
            } else {
                posIdx = null;
                positionColumnNo = null;
            }
            Indexs indexTable = new Indexs(columnTable, indexColumnNo, indexList, positionColumnNo, posIdx);
            return new TableImpl(columnTable, uniqueTable, indexTable, this.name, len);
        }
        catch (Exception e) {
            throw new RimDbException("\u30c6\u30fc\u30d6\u30eb[" + this.name + "]\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    private static final int getColumnNo(String[] columnNames, String column) {
        int len = columnNames.length;
        int i = 0;
        while (i < len) {
            if (columnNames[i].equals(column)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static final int[] createColumnNoList(int[] types, int[] target, String[] columnNames, String[] value) {
        int len = value.length;
        int allLen = columnNames.length;
        int targetLen = target != null ? target.length : 0;
        int[] ret = new int[len];
        int i = 0;
        while (i < len) {
            ret[i] = -1;
            String n = value[i];
            int j = 0;
            while (j < allLen) {
                if (columnNames[j].equals(n)) {
                    ret[i] = j;
                    break;
                }
                ++j;
            }
            if (ret[i] == -1) {
                throw new RimDbException("\u6307\u5b9a\u6761\u4ef6\u306e\u30ab\u30e9\u30e0\u540d[" + n + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            if (target != null) {
                int t = types[ret[i]];
                j = 0;
                while (j < targetLen) {
                    if (t == target[j]) {
                        t = -1;
                    }
                    ++j;
                }
                if (t != -1) {
                    throw new RimDbException("\u6307\u5b9a\u6761\u4ef6\u306e\u30ab\u30e9\u30e0\u30bf\u30a4\u30d7[" + t + "]\u306f\u8a31\u53ef\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                }
            }
            ++i;
        }
        return ret;
    }

    private static final Object createArray(int type, int len, int no) {
        switch (type) {
            case 1: {
                return new Boolean[len];
            }
            case 2: {
                return new Integer[len];
            }
            case 3: {
                return new Long[len];
            }
            case 4: {
                return new Double[len];
            }
            case 5: {
                return new Date[len];
            }
            case 6: {
                return new Time[len];
            }
            case 7: {
                return new Timestamp[len];
            }
            case 8: {
                return new String[len];
            }
            case 9: {
                return new Object[len];
            }
        }
        throw new RimDbException("\u578b[" + type + "]\u304c\u4e0d\u660e\u3067\u3059(" + no + ")");
    }

    private static final void setArray(Object out, int type, int no, Object v) {
        switch (type) {
            case 1: {
                ((Boolean[])out)[no] = ConvertUtil.convertBool(v);
                break;
            }
            case 2: {
                ((Integer[])out)[no] = ConvertUtil.convertInt(v);
                break;
            }
            case 3: {
                ((Long[])out)[no] = ConvertUtil.convertLong(v);
                break;
            }
            case 4: {
                ((Double[])out)[no] = ConvertUtil.convertDouble(v);
                break;
            }
            case 5: {
                ((Date[])out)[no] = ConvertUtil.convertSqlDate(v);
                break;
            }
            case 6: {
                ((Time[])out)[no] = ConvertUtil.convertSqlTime(v);
                break;
            }
            case 7: {
                ((Timestamp[])out)[no] = ConvertUtil.convertSqlTimestamp(v);
                break;
            }
            case 8: {
                ((String[])out)[no] = ConvertUtil.convertString(v);
                break;
            }
            case 9: {
                ((Object[])out)[no] = v;
            }
        }
    }

    private static final ColumnArray createColumnArray(int type, Object v) {
        switch (type) {
            case 1: {
                return new BooleanArray((Boolean[])v);
            }
            case 2: {
                return new IntegerArray((Integer[])v);
            }
            case 3: {
                return new LongArray((Long[])v);
            }
            case 4: {
                return new FloatArray((Double[])v);
            }
            case 5: {
                return new DateArray((Date[])v);
            }
            case 6: {
                return new TimeArray((Time[])v);
            }
            case 7: {
                return new TimestampArray((Timestamp[])v);
            }
            case 8: {
                return new StringArray((String[])v);
            }
            case 9: {
                return new ObjectArray((Object[])v);
            }
        }
        return null;
    }

    private static final UniqueId createUniqueId(int type, Object value) {
        switch (type) {
            case 2: {
                return new UniqueId((Integer[])value);
            }
            case 3: {
                return new UniqueId((Long[])value);
            }
        }
        throw new RimDbException("\u30e6\u30cb\u30fc\u30af\u6761\u4ef6\u306f[int,long]\u4ee5\u5916\u306e\u30ab\u30e9\u30e0\u306f\u9069\u5fdc\u3067\u304d\u307e\u305b\u3093");
    }

    private static final Index createIndex(String column, int type, Object value, boolean ngram) {
        try {
            switch (type) {
                case 1: {
                    CreateBoolIndex idx = new CreateBoolIndex();
                    idx.addArray((Boolean[])value);
                    idx.setNGram(ngram);
                    return (Index)idx.create();
                }
                case 2: {
                    CreateNumber32Index idx = new CreateNumber32Index();
                    idx.addArray((Integer[])value);
                    idx.setNGram(ngram);
                    return (Index)idx.create();
                }
                case 3: {
                    CreateNumber64Index idx = new CreateNumber64Index();
                    idx.addArray((Long[])value);
                    idx.setNGram(ngram);
                    return (Index)idx.create();
                }
                case 4: {
                    CreateNumberFloatIndex idx = new CreateNumberFloatIndex();
                    idx.addArray((Double[])value);
                    idx.setNGram(ngram);
                    return (Index)idx.create();
                }
                case 5: {
                    CreateNumber64Index idx = new CreateNumber64Index();
                    Date[] d = (Date[])value;
                    int len = d.length;
                    int i = 0;
                    while (i < len) {
                        idx.add(d[i].getTime());
                        ++i;
                    }
                    idx.setNGram(ngram);
                    return (Index)idx.create();
                }
                case 6: {
                    CreateNumber32Index idx = new CreateNumber32Index();
                    Time[] t = (Time[])value;
                    int len = t.length;
                    int i = 0;
                    while (i < len) {
                        idx.add((int)t[i].getTime());
                        ++i;
                    }
                    idx.setNGram(ngram);
                    return (Index)idx.create();
                }
                case 7: {
                    CreateNumber64Index idx = new CreateNumber64Index();
                    Timestamp[] t = (Timestamp[])value;
                    int len = t.length;
                    int i = 0;
                    while (i < len) {
                        idx.add(t[i].getTime());
                        ++i;
                    }
                    idx.setNGram(ngram);
                    return (Index)idx.create();
                }
                case 8: {
                    CreateStringIndex idx = new CreateStringIndex();
                    idx.addArray((String[])value);
                    idx.setNGram(ngram);
                    return (Index)idx.create();
                }
                case 9: {
                    CreateComparableIndex idx = new CreateComparableIndex();
                    int len = Array.getLength(value);
                    int i = 0;
                    while (i < len) {
                        idx.add((Comparable)Array.get(value, i));
                        ++i;
                    }
                    idx.setNGram(ngram);
                    return (Index)idx.create();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new RimDbException("\u30ab\u30e9\u30e0[" + column + "]\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }
}

