/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.table;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.index.BetweenPointer;
import org.maachang.rimdb.index.IfPointer;
import org.maachang.rimdb.index.InPointer;
import org.maachang.rimdb.index.Index;
import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.index.LikePointer;
import org.maachang.rimdb.index.bool.BoolEq;
import org.maachang.rimdb.index.bool.BoolIndex;
import org.maachang.rimdb.index.comparable.ComparableBetween;
import org.maachang.rimdb.index.comparable.ComparableBig;
import org.maachang.rimdb.index.comparable.ComparableEq;
import org.maachang.rimdb.index.comparable.ComparableIn;
import org.maachang.rimdb.index.comparable.ComparableIndex;
import org.maachang.rimdb.index.comparable.ComparableSmall;
import org.maachang.rimdb.index.number32.Number32Between;
import org.maachang.rimdb.index.number32.Number32Big;
import org.maachang.rimdb.index.number32.Number32Eq;
import org.maachang.rimdb.index.number32.Number32In;
import org.maachang.rimdb.index.number32.Number32Index;
import org.maachang.rimdb.index.number32.Number32Small;
import org.maachang.rimdb.index.number64.Number64Between;
import org.maachang.rimdb.index.number64.Number64Big;
import org.maachang.rimdb.index.number64.Number64Eq;
import org.maachang.rimdb.index.number64.Number64In;
import org.maachang.rimdb.index.number64.Number64Index;
import org.maachang.rimdb.index.number64.Number64Small;
import org.maachang.rimdb.index.numberFloat.NumberFloatBetween;
import org.maachang.rimdb.index.numberFloat.NumberFloatBig;
import org.maachang.rimdb.index.numberFloat.NumberFloatEq;
import org.maachang.rimdb.index.numberFloat.NumberFloatIn;
import org.maachang.rimdb.index.numberFloat.NumberFloatIndex;
import org.maachang.rimdb.index.numberFloat.NumberFloatSmall;
import org.maachang.rimdb.index.position.PositionIndex;
import org.maachang.rimdb.index.position.PositionIndexPointer;
import org.maachang.rimdb.index.string.StringBetween;
import org.maachang.rimdb.index.string.StringBig;
import org.maachang.rimdb.index.string.StringEq;
import org.maachang.rimdb.index.string.StringIn;
import org.maachang.rimdb.index.string.StringIndex;
import org.maachang.rimdb.index.string.StringLike;
import org.maachang.rimdb.index.string.StringSmall;
import org.maachang.rimdb.table.Columns;

public final class Indexs {
    protected final int[] columns;
    protected final Index[] list;
    protected final PositionIndex position;
    protected final int[] positionColumns;
    protected Columns base;
    protected final int length;

    public Indexs(Columns base, int[] columns, Index[] list, int[] positionColumns, PositionIndex position) {
        this.base = base;
        this.columns = columns;
        this.list = list;
        this.positionColumns = positionColumns;
        this.position = position;
        int len = list.length;
        int i = 0;
        while (i < len) {
            list[i].setColumnNoAndName(columns[i], base.getColumnName(columns[i]));
            ++i;
        }
        this.length = len;
    }

    public final int length() {
        return this.length;
    }

    public final PositionIndex getPositionIndex() {
        return this.position;
    }

    public final boolean isPositionIndex() {
        return this.position != null;
    }

    public final boolean contains(int no) {
        return this.getColumnNoByNo(no) != -1;
    }

    public final boolean contains(String name) {
        return this.getColumnNameByNo(name) != -1;
    }

    public final Index getIndex(int no) {
        int p = this.getColumnNoByNo(no);
        if (p == -1) {
            return null;
        }
        return this.list[p];
    }

    public final Index getIndex(String name) {
        int p = this.getColumnNameByNo(name);
        if (p == -1) {
            return null;
        }
        return this.list[p];
    }

    public final IfPointer eq(int no) {
        return this._eq(this.getColumnNoByNo(no), true);
    }

    public final IfPointer eq(String name) {
        return this._eq(this.getColumnNameByNo(name), true);
    }

    public final IfPointer not(int no) {
        return this._eq(this.getColumnNoByNo(no), false);
    }

    public final IfPointer not(String name) {
        return this._eq(this.getColumnNameByNo(name), false);
    }

    public final IfPointer big(int no) {
        return this._big(this.getColumnNoByNo(no), false);
    }

    public final IfPointer big(String name) {
        return this._big(this.getColumnNameByNo(name), false);
    }

    public final IfPointer bigEq(int no) {
        return this._big(this.getColumnNoByNo(no), true);
    }

    public final IfPointer bigEq(String name) {
        return this._big(this.getColumnNameByNo(name), true);
    }

    public final IfPointer small(int no) {
        return this._small(this.getColumnNoByNo(no), false);
    }

    public final IfPointer small(String name) {
        return this._small(this.getColumnNameByNo(name), false);
    }

    public final IfPointer smallEq(int no) {
        return this._small(this.getColumnNoByNo(no), true);
    }

    public final IfPointer smallEq(String name) {
        return this._small(this.getColumnNameByNo(name), true);
    }

    public final InPointer in(int no) {
        return this._in(this.getColumnNoByNo(no));
    }

    public final InPointer in(String name) {
        return this._in(this.getColumnNameByNo(name));
    }

    public final BetweenPointer between(int no) {
        return this._between(this.getColumnNoByNo(no));
    }

    public final BetweenPointer between(String name) {
        return this._between(this.getColumnNameByNo(name));
    }

    public final LikePointer like(int no) {
        return this._like(this.getColumnNoByNo(no));
    }

    public final LikePointer like(String name) {
        return this._like(this.getColumnNameByNo(name));
    }

    public final PositionIndexPointer position() {
        if (this.position == null) {
            throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
        }
        return new PositionIndexPointer();
    }

    protected final int getColumnNoByNo(int no) {
        return IndexUtil.searchInt(this.columns, no);
    }

    protected final int getColumnNameByNo(String name) {
        int p = this.base.getColumnNo(name);
        if (p == -1 || (p = IndexUtil.searchInt(this.columns, p)) == -1) {
            return -1;
        }
        return p;
    }

    protected final IfPointer _eq(int no, boolean eq) {
        if (no < 0 || no >= this.length) {
            throw new RimDbException("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u6761\u4ef6\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + no);
        }
        Index idx = this.list[no];
        int type = this.base.list[this.columns[no]].getType();
        switch (type) {
            case 1: {
                return new BoolEq((BoolIndex)idx, eq);
            }
            case 2: {
                return new Number32Eq((Number32Index)idx, eq);
            }
            case 3: {
                return new Number64Eq((Number64Index)idx, eq);
            }
            case 4: {
                return new NumberFloatEq((NumberFloatIndex)idx, eq);
            }
            case 5: {
                return new Number64Eq((Number64Index)idx, eq);
            }
            case 6: {
                return new Number32Eq((Number32Index)idx, eq);
            }
            case 7: {
                return new Number64Eq((Number64Index)idx, eq);
            }
            case 8: {
                return new StringEq((StringIndex)idx, eq);
            }
            case 9: {
                return new ComparableEq((ComparableIndex)idx, eq);
            }
        }
        throw new RimDbException("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u6761\u4ef6[" + no + "]\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
    }

    protected final IfPointer _big(int no, boolean eq) {
        if (no < 0 || no >= this.length) {
            throw new RimDbException("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u6761\u4ef6[" + no + "]\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        Index idx = this.list[no];
        int type = this.base.list[this.columns[no]].getType();
        switch (type) {
            case 1: {
                throw new RimDbException("Boolean\u578b\u3067\u306f[> or >=]\u51e6\u7406\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
            }
            case 2: {
                return new Number32Big((Number32Index)idx, eq);
            }
            case 3: {
                return new Number64Big((Number64Index)idx, eq);
            }
            case 4: {
                return new NumberFloatBig((NumberFloatIndex)idx, eq);
            }
            case 5: {
                return new Number64Big((Number64Index)idx, eq);
            }
            case 6: {
                return new Number32Big((Number32Index)idx, eq);
            }
            case 7: {
                return new Number64Big((Number64Index)idx, eq);
            }
            case 8: {
                return new StringBig((StringIndex)idx, eq);
            }
            case 9: {
                return new ComparableBig((ComparableIndex)idx, eq);
            }
        }
        throw new RimDbException("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u6761\u4ef6[" + no + "]\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
    }

    protected final IfPointer _small(int no, boolean eq) {
        if (no < 0 || no >= this.length) {
            throw new RimDbException("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u6761\u4ef6[" + no + "]\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        Index idx = this.list[no];
        int type = this.base.list[this.columns[no]].getType();
        switch (type) {
            case 1: {
                throw new RimDbException("Boolean\u578b\u3067\u306f[< or <=]\u51e6\u7406\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
            }
            case 2: {
                return new Number32Small((Number32Index)idx, eq);
            }
            case 3: {
                return new Number64Small((Number64Index)idx, eq);
            }
            case 4: {
                return new NumberFloatSmall((NumberFloatIndex)idx, eq);
            }
            case 5: {
                return new Number64Small((Number64Index)idx, eq);
            }
            case 6: {
                return new Number32Small((Number32Index)idx, eq);
            }
            case 7: {
                return new Number64Small((Number64Index)idx, eq);
            }
            case 8: {
                return new StringSmall((StringIndex)idx, eq);
            }
            case 9: {
                return new ComparableSmall((ComparableIndex)idx, eq);
            }
        }
        throw new RimDbException("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u6761\u4ef6[" + no + "]\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
    }

    protected final InPointer _in(int no) {
        if (no < 0 || no >= this.length) {
            throw new RimDbException("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u6761\u4ef6[" + no + "]\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        Index idx = this.list[no];
        int type = this.base.list[this.columns[no]].getType();
        switch (type) {
            case 1: {
                throw new RimDbException("Boolean\u578b\u3067\u306fIN\u51e6\u7406\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
            }
            case 2: {
                return new Number32In((Number32Index)idx);
            }
            case 3: {
                return new Number64In((Number64Index)idx);
            }
            case 4: {
                return new NumberFloatIn((NumberFloatIndex)idx);
            }
            case 5: {
                return new Number64In((Number64Index)idx);
            }
            case 6: {
                return new Number32In((Number32Index)idx);
            }
            case 7: {
                return new Number64In((Number64Index)idx);
            }
            case 8: {
                return new StringIn((StringIndex)idx);
            }
            case 9: {
                return new ComparableIn((ComparableIndex)idx);
            }
        }
        throw new RimDbException("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u6761\u4ef6[" + no + "]\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
    }

    protected final BetweenPointer _between(int no) {
        if (no < 0 || no >= this.length) {
            throw new RimDbException("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u6761\u4ef6[" + no + "]\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        Index idx = this.list[no];
        int type = this.base.list[this.columns[no]].getType();
        switch (type) {
            case 1: {
                throw new RimDbException("Boolean\u578b\u3067\u306fIN\u51e6\u7406\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
            }
            case 2: {
                return new Number32Between((Number32Index)idx);
            }
            case 3: {
                return new Number64Between((Number64Index)idx);
            }
            case 4: {
                return new NumberFloatBetween((NumberFloatIndex)idx);
            }
            case 5: {
                return new Number64Between((Number64Index)idx);
            }
            case 6: {
                return new Number32Between((Number32Index)idx);
            }
            case 7: {
                return new Number64Between((Number64Index)idx);
            }
            case 8: {
                return new StringBetween((StringIndex)idx);
            }
            case 9: {
                return new ComparableBetween((ComparableIndex)idx);
            }
        }
        throw new RimDbException("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u6761\u4ef6[" + no + "]\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
    }

    protected final LikePointer _like(int no) {
        if (no < 0 || no >= this.length) {
            throw new RimDbException("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u6761\u4ef6[" + no + "]\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        Index idx = this.list[no];
        int type = this.base.list[this.columns[no]].getType();
        switch (type) {
            case 1: {
                throw new RimDbException("Boolean\u578b\u3067\u306f[Like]\u51e6\u7406\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
            }
            case 2: {
                throw new RimDbException("Integer\u578b\u3067\u306f[Like]\u51e6\u7406\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
            }
            case 3: {
                throw new RimDbException("Long\u578b\u3067\u306f[Like]\u51e6\u7406\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
            }
            case 4: {
                throw new RimDbException("Float\u578b\u3067\u306f[Like]\u51e6\u7406\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
            }
            case 5: {
                throw new RimDbException("Date\u578b\u3067\u306f[Like]\u51e6\u7406\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
            }
            case 6: {
                throw new RimDbException("Time\u578b\u3067\u306f[Like]\u51e6\u7406\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
            }
            case 7: {
                throw new RimDbException("Timestamp\u578b\u3067\u306f[Like]\u51e6\u7406\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
            }
            case 8: {
                return new StringLike((StringIndex)idx);
            }
            case 9: {
                throw new RimDbException("Object\u578b\u3067\u306f[Like]\u51e6\u7406\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
            }
        }
        throw new RimDbException("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u6761\u4ef6[" + no + "]\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
    }
}

