/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.util.DateTimeUtil;

public final class ConvertUtil {
    private static final int SMALL_BIG_CODE = 32;

    protected ConvertUtil() {
    }

    public static final boolean isNumeric(Object num) {
        if (num == null) {
            return false;
        }
        if (num instanceof Number) {
            return true;
        }
        String s = !(num instanceof String) ? num.toString().trim() : ((String)num).trim();
        if (s.length() <= 0) {
            return false;
        }
        int start = 0;
        if (s.charAt(0) == '-') {
            start = 1;
        }
        boolean dt = false;
        int len = s.length();
        if (start >= len) {
            return false;
        }
        int i = start;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '.') {
                if (dt) {
                    return false;
                }
                dt = true;
            } else if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final Boolean convertBool(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        if (o instanceof String) {
            String s = ((String)o).trim();
            if (ConvertUtil.eqEng("true", s) || ConvertUtil.eqEng("t", s)) {
                return true;
            }
            if (ConvertUtil.eqEng("false", s) || ConvertUtil.eqEng("f", s)) {
                return false;
            }
        }
        throw new RimDbException("BOOL\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    public static final Integer convertInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String && ConvertUtil.isNumeric(o)) {
            return ConvertUtil.parseInt(((String)o).trim());
        }
        throw new RimDbException("Int\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    public static final Long convertLong(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String && ConvertUtil.isNumeric(o)) {
            return ConvertUtil.parseLong(((String)o).trim());
        }
        throw new RimDbException("Long\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    public static final Float convertFloat(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return (Float)o;
        }
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        if (o instanceof String && ConvertUtil.isNumeric(o)) {
            return Float.valueOf(ConvertUtil.parseFloat(((String)o).trim()));
        }
        throw new RimDbException("Float\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    public static final Double convertDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String && ConvertUtil.isNumeric(o)) {
            return ConvertUtil.parseDouble(((String)o).trim());
        }
        throw new RimDbException("Double\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    public static final String convertString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    private static final java.sql.Date _cDate(long d) {
        return ConvertUtil._cDate(new Date(d));
    }

    private static final java.sql.Date _cDate(Date n) {
        return new java.sql.Date(n.getYear(), n.getMonth(), n.getDate());
    }

    public static final java.sql.Date convertSqlDate(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return ConvertUtil._cDate((Date)o);
        }
        if (o instanceof Long) {
            return ConvertUtil._cDate((Long)o);
        }
        if (o instanceof Number) {
            return ConvertUtil._cDate(((Number)o).longValue());
        }
        if (o instanceof String) {
            if (ConvertUtil.isNumeric(o)) {
                return ConvertUtil._cDate(ConvertUtil.parseLong((String)o));
            }
            return DateTimeUtil.getDate((String)o);
        }
        throw new RimDbException("java.sql.Date\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    private static final Time _cTime(long d) {
        return ConvertUtil._cTime(new Date(d));
    }

    private static final Time _cTime(Date n) {
        return new Time(n.getHours(), n.getMinutes(), n.getSeconds());
    }

    public static final Time convertSqlTime(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return ConvertUtil._cTime((Date)o);
        }
        if (o instanceof Long) {
            return ConvertUtil._cTime((Long)o);
        }
        if (o instanceof Number) {
            return ConvertUtil._cTime(((Number)o).longValue());
        }
        if (o instanceof String) {
            if (ConvertUtil.isNumeric((String)o)) {
                return ConvertUtil._cTime(ConvertUtil.parseLong((String)o));
            }
            return DateTimeUtil.getTime((String)o);
        }
        throw new RimDbException("java.sql.Time\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    public static final Timestamp convertSqlTimestamp(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            if (o instanceof Timestamp) {
                return (Timestamp)o;
            }
            return new Timestamp(((Date)o).getTime());
        }
        if (o instanceof Long) {
            return new Timestamp((Long)o);
        }
        if (o instanceof Number) {
            return new Timestamp(((Number)o).longValue());
        }
        if (o instanceof String) {
            if (ConvertUtil.isNumeric((String)o)) {
                return new Timestamp(ConvertUtil.parseLong((String)o));
            }
            return DateTimeUtil.getTimestamp((String)o);
        }
        throw new RimDbException("java.sql.Timestamp\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    public static final Date convertDate(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Long) {
            return new Date((Long)o);
        }
        if (o instanceof Number) {
            return new Date(((Number)o).longValue());
        }
        if (o instanceof String) {
            if (ConvertUtil.isNumeric((String)o)) {
                return new Timestamp(ConvertUtil.parseLong((String)o));
            }
            return DateTimeUtil.getTimestamp((String)o);
        }
        throw new RimDbException("java.util.Date\u578b\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + o + "]");
    }

    public static final boolean parseBoolean(String s) {
        if (s == null || s.length() <= 0) {
            throw new IllegalArgumentException("\u6587\u5b57\u5217\u306f\u7a7a\u3067\u3059");
        }
        if (ConvertUtil.eqEng("true", s)) {
            return true;
        }
        if (ConvertUtil.eqEng("false", s)) {
            return false;
        }
        throw new RimDbException("Boolean\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + s);
    }

    public static final int parseInt(String num) {
        int v;
        int len;
        if (num == null || (len = num.length()) <= 0) {
            throw new IllegalArgumentException("\u6587\u5b57\u5217\u306f\u7a7a\u3067\u3059");
        }
        int ret = 0;
        int end = 0;
        if (num.charAt(0) == '-') {
            end = 1;
        }
        if ((v = num.indexOf(".")) != -1) {
            len = v;
        }
        v = 1;
        int i = len - 1;
        while (i >= end) {
            char c = num.charAt(i);
            if (c >= '0' && c <= '9') {
                ret += v * (c - 48);
                v *= 10;
            } else {
                throw new RimDbException("\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + num);
            }
            --i;
        }
        if (end == 1) {
            return ret * -1;
        }
        return ret;
    }

    public static final long parseLong(String num) {
        int dot;
        int len;
        if (num == null || (len = num.length()) <= 0) {
            throw new IllegalArgumentException("\u6587\u5b57\u5217\u306f\u7a7a\u3067\u3059");
        }
        long ret = 0L;
        int end = 0;
        if (num.charAt(0) == '-') {
            end = 1;
        }
        if ((dot = num.indexOf(".")) != -1) {
            len = dot;
        }
        long v = 1L;
        int i = len - 1;
        while (i >= end) {
            char c = num.charAt(i);
            if (c >= '0' && c <= '9') {
                ret += v * (long)(c - 48);
                v *= 10L;
            } else {
                throw new RimDbException("\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + num);
            }
            --i;
        }
        if (end == 1) {
            return ret * -1L;
        }
        return ret;
    }

    public static final float parseFloat(String num) {
        char c;
        int len;
        if (num == null || (len = num.length()) <= 0) {
            throw new IllegalArgumentException("\u6587\u5b57\u5217\u306f\u7a7a\u3067\u3059");
        }
        float ret = 0.0f;
        int end = 0;
        if (num.charAt(0) == '-') {
            end = 1;
        }
        float v = 1.0f;
        int dot = num.indexOf(".");
        if (dot == -1) {
            int i = len - 1;
            while (i >= end) {
                char c2 = num.charAt(i);
                if (c2 >= '0' && c2 <= '9') {
                    ret += v * (float)(c2 - 48);
                    v *= 10.0f;
                } else {
                    throw new RimDbException("\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + num);
                }
                --i;
            }
            if (end == 1) {
                return ret * -1.0f;
            }
            return ret;
        }
        int i = dot - 1;
        while (i >= end) {
            c = num.charAt(i);
            if (c >= '0' && c <= '9') {
                ret += v * (float)(c - 48);
                v *= 10.0f;
            } else {
                throw new RimDbException("\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + num);
            }
            --i;
        }
        float dret = 0.0f;
        v = 1.0f;
        int i2 = len - 1;
        while (i2 > dot) {
            c = num.charAt(i2);
            if (c >= '0' && c <= '9') {
                dret += v * (float)(c - 48);
                v *= 10.0f;
            } else {
                throw new RimDbException("\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + num);
            }
            --i2;
        }
        ret = end == 1 ? (ret + dret / v) * -1.0f : (ret += dret / v);
        return ret;
    }

    public static final double parseDouble(String num) {
        char c;
        int len;
        if (num == null || (len = num.length()) <= 0) {
            throw new IllegalArgumentException("\u6587\u5b57\u5217\u306f\u7a7a\u3067\u3059");
        }
        double ret = 0.0;
        int end = 0;
        if (num.charAt(0) == '-') {
            end = 1;
        }
        double v = 1.0;
        int dot = num.indexOf(".");
        if (dot == -1) {
            int i = len - 1;
            while (i >= end) {
                char c2 = num.charAt(i);
                if (c2 >= '0' && c2 <= '9') {
                    ret += v * (double)(c2 - 48);
                    v *= 10.0;
                } else {
                    throw new RimDbException("\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + num);
                }
                --i;
            }
            if (end == 1) {
                return ret * -1.0;
            }
            return ret;
        }
        int i = dot - 1;
        while (i >= end) {
            c = num.charAt(i);
            if (c >= '0' && c <= '9') {
                ret += v * (double)(c - 48);
                v *= 10.0;
            } else {
                throw new RimDbException("\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + num);
            }
            --i;
        }
        double dret = 0.0;
        v = 1.0;
        int i2 = len - 1;
        while (i2 > dot) {
            c = num.charAt(i2);
            if (c >= '0' && c <= '9') {
                dret += v * (double)(c - 48);
                v *= 10.0;
            } else {
                throw new RimDbException("\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + num);
            }
            --i2;
        }
        ret = end == 1 ? (ret + dret / v) * -1.0 : (ret += dret / v);
        return ret;
    }

    public static final boolean[] getArray(boolean ... v) {
        return v;
    }

    public static final int[] getArray(int ... v) {
        return v;
    }

    public static final long[] getArray(long ... v) {
        return v;
    }

    public static final float[] getArray(float ... v) {
        return v;
    }

    public static final double[] getArray(double ... v) {
        return v;
    }

    public static final java.sql.Date[] getArray(java.sql.Date ... v) {
        return v;
    }

    public static final Time[] getArray(Time ... v) {
        return v;
    }

    public static final Timestamp[] getArray(Timestamp ... v) {
        return v;
    }

    public static final String[] getArray(String ... v) {
        return v;
    }

    public static final Comparable[] getArray(Comparable ... v) {
        return v;
    }

    public static final Object[] getArray(Object ... v) {
        return v;
    }

    public static final int bitMask(int x) {
        if (x < 1) {
            return 1;
        }
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        x = (x & 0x55555555) + (x >> 1 & 0x55555555);
        x = (x & 0x33333333) + (x >> 2 & 0x33333333);
        x = (x & 0xF0F0F0F) + (x >> 4 & 0xF0F0F0F);
        x = (x & 0xFF00FF) + (x >> 8 & 0xFF00FF);
        x = (x & 0xFFFF) + (x >> 16 & 0xFFFF);
        return 1 << (x & 0xFFFF) + (x >> 16 & 0xFFFF) - 1;
    }

    public static final boolean eqEng(String src, String dest) {
        if (src == null || dest == null) {
            return false;
        }
        int len = src.length();
        if (len != dest.length()) {
            return false;
        }
        int i = 0;
        while (i < len) {
            char d;
            char s = src.charAt(i);
            if (s != (d = dest.charAt(i)) && (s < 'A' || s > 'z' || d < 'A' || d > 'z' || s + 32 != d && s - 32 != d && s != d + 32 && s != d - 32 && s + 32 != d + 32 && s - 32 != d + 32 && s + 32 != d - 32 && s - 32 != d - 32)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean eqEng(String src, int start, int end, String dest) {
        if (src == null || dest == null) {
            return false;
        }
        int len = end - start;
        if (len != dest.length()) {
            return false;
        }
        int i = 0;
        while (i < len) {
            char d;
            char s = src.charAt(i + start);
            if (s != (d = dest.charAt(i)) && (s < 'A' || s > 'z' || d < 'A' || d > 'z' || s + 32 != d && s - 32 != d && s != d + 32 && s != d - 32 && s + 32 != d + 32 && s - 32 != d + 32 && s + 32 != d - 32 && s - 32 != d - 32)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final String changeString(String src, String s, String d) {
        return ConvertUtil.changeString(src, 0, src.length(), s, d);
    }

    public static final String changeString(String src, int off, int len, String s, String d) {
        char t = s.charAt(0);
        int lenS = s.length();
        StringBuilder buf = new StringBuilder(len);
        int i = off;
        while (i < len) {
            if (src.charAt(i) == t) {
                int j = i;
                int k = 0;
                while (++k < lenS && ++j < len && src.charAt(j) == s.charAt(k)) {
                }
                if (k >= lenS) {
                    buf.append(d);
                    i += lenS - 1;
                } else {
                    buf.append(t);
                }
            } else {
                buf.append(src.charAt(i));
            }
            ++i;
        }
        return buf.toString();
    }

    public static final String indentCote(String string, int indent, boolean dc) {
        int j;
        if (string == null || string.length() <= 0) {
            return string;
        }
        char cote = dc ? (char)'\"' : '\'';
        int len = string.length();
        int yenLen = 0;
        StringBuilder buf = new StringBuilder((int)((double)len * 1.25));
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == cote) {
                if (yenLen > 0) {
                    yenLen = indent == -1 ? (yenLen >>= 1) : (yenLen <<= 1);
                    j = 0;
                    while (j < yenLen) {
                        buf.append("\\");
                        ++j;
                    }
                    yenLen = 0;
                }
                if (indent == -1) {
                    buf.append(cote);
                } else {
                    buf.append("\\").append(cote);
                }
            } else if ('\\' == c) {
                ++yenLen;
            } else {
                if (yenLen != 0) {
                    j = 0;
                    while (j < yenLen) {
                        buf.append("\\");
                        ++j;
                    }
                    yenLen = 0;
                }
                buf.append(c);
            }
            ++i;
        }
        if (yenLen != 0) {
            j = 0;
            while (j < yenLen) {
                buf.append("\\");
                ++j;
            }
        }
        return buf.toString();
    }

    public static final String upIndentDoubleCote(String string) {
        return ConvertUtil.indentCote(string, 0, true);
    }

    public static final String upIndentSingleCote(String string) {
        return ConvertUtil.indentCote(string, 0, false);
    }

    public static final String downIndentDoubleCote(String string) {
        boolean exec = false;
        int len = string.length();
        char b = '\u0000';
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == '\"') {
                if (b != '\\') break;
                exec = true;
                break;
            }
            b = c;
            ++i;
        }
        if (exec) {
            return ConvertUtil.indentCote(string, -1, true);
        }
        return string;
    }

    public static final String downIndentSingleCote(String string) {
        boolean exec = false;
        int len = string.length();
        char b = '\u0000';
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == '\'') {
                if (b != '\\') break;
                exec = true;
                break;
            }
            b = c;
            ++i;
        }
        if (exec) {
            return ConvertUtil.indentCote(string, -1, false);
        }
        return string;
    }
}

