/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.util;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class OList<T> {
    private static final int DEF = 16;
    private Object[] list;
    private int length;
    private int max;

    public static final OList getInstance(Object ... args) {
        return new OList(args);
    }

    public OList() {
        this(16);
    }

    public OList(int buf) {
        if (buf < 16) {
            buf = 16;
        }
        this.max = buf;
        this.list = new Object[buf];
        this.length = 0;
    }

    public OList(Object[] o) {
        if (o != null && o.length > 0) {
            int oLen = o.length;
            int len = oLen + (oLen >> 1);
            if (len < 16) {
                len = 16;
            }
            this.max = len;
            this.list = new Object[len];
            this.length = oLen;
            System.arraycopy(o, 0, this.list, 0, oLen);
        } else {
            this.max = 16;
            this.list = new Object[this.max];
            this.length = 0;
        }
    }

    public void clear() {
        if (this.list.length != this.max) {
            this.list = new Object[this.max];
        }
        this.length = 0;
    }

    public void clear(int buf) {
        if (this.list.length < buf) {
            this.list = new Object[buf];
        }
        this.length = 0;
    }

    public void add(T n) {
        if (this.length + 1 >= this.list.length) {
            Object[] tmp = new Object[this.length << 1];
            System.arraycopy(this.list, 0, tmp, 0, this.length);
            this.list = tmp;
        }
        this.list[this.length++] = n;
    }

    public void set(int no, T o) {
        this.list[no] = o;
    }

    public T get(int no) {
        return (T)this.list[no];
    }

    public void remove(int no) {
        if (no < 0 || no >= this.length) {
            return;
        }
        if (this.length == 1) {
            this.list[0] = null;
        } else {
            --this.length;
            this.list[no] = this.list[this.length];
            this.list[this.length] = null;
        }
    }

    public int size() {
        return this.length;
    }

    public int search(T n) {
        int len = this.length;
        if (n == null) {
            int i = 0;
            while (i < len) {
                if (this.list[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                if (n.equals(this.list[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int binarySearch(Comparable n) {
        int low = 0;
        int high = this.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = ((Comparable)this.list[mid]).compareTo(n);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public OList sort() {
        if (this.length > 0) {
            Arrays.sort(this.list, 0, this.length);
        }
        return this;
    }

    public Object[] getArray() {
        Object[] ret = new Object[this.length];
        System.arraycopy(this.list, 0, ret, 0, this.length);
        return ret;
    }

    public Object[] toArray() {
        return this.list;
    }

    public void setAll(Object n) {
        int len = Array.getLength(n);
        if (this.list.length < len) {
            this.list = new Object[len];
            this.max = len;
        }
        this.length = len;
        System.arraycopy(n, 0, this.list, 0, len);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.length) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.list[i]);
            ++i;
        }
        return buf.toString();
    }
}

