package org.maachang.rimdb ;

import java.util.Map;

/**
 * テーブル行情報.
 * 
 * @version 2014/07/07
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public interface Row extends Map<Object,Object> {
    
    /**
     * 現在のオブジェクトをコピー.
     * @return Row コピーされたオブジェクトが返却されます.
     */
    public Row copy() ;
    
    /**
     * 現在のオブジェクトをMAP変換.
     * @return ColumnMap 変換されたMapオブジェクトが返却されます.
     * @version rimdb-1.01
     */
    public ColumnMap toMap() ;
    
    /**
     * 現在のオブジェクトをキー名をJava名に変換してMap取得.
     * @return ColumnMap 変換されたMapオブジェクトが返却されます.
     * @version rimdb-1.01
     */
    public ColumnMap toJavaMap() ;
    
    /**
     * 行ポジションを取得.
     * @return int ポジションが返却されます.
     */
    public int position() ;
    
    /**
     * 行ポジションセット.
     * @param pos 対象のポジションを設定します.
     * @return Row オブジェクトが返却されます.
     */
    public Row position( int pos ) ;
    
    /**
     * カラムタイプを取得.
     * @param no 対象のカラム項番を設定します.
     * @return int カラムタイプが返却されます.
     */
    public int getType( int no ) ;
    
    /**
     * カラムタイプを取得.
     * @param name 対象のカラム名を設定します.
     * @return int カラムタイプが返却されます.
     *             [-1]の場合、取得に失敗しました.
     */
    public int getType( String name ) ;
    
    /**
     * カラム数を取得.
     * @return int カラム数が返却されます.
     */
    public int length() ;
    
    /**
     * カラム名を取得.
     * @param no 対象のカラム項番を設定します.
     * @return String カラム名が返却されます.
     */
    public String getColumnName( int no ) ;
    
    /**
     * 情報取得.
     * @param no 対象の項番を設定します.
     * @return Object 情報が返却されます.
     */
    public Object getValue( int no ) ;
    
    /**
     * 情報取得.
     * @param no 対象の項番を設定します.
     * @return Object 情報が返却されます.
     */
    public Object getValue( long no ) ;
    
    /**
     * 情報取得.
     * @param name 対象のカラム名を設定します.
     * @return Object 情報が返却されます.
     */
    public Object getValue( String name ) ;
    
    /**
     * boolean情報を取得.
     * @param no 対象の項番を設定します.
     * @return Boolean 情報が返却されます.
     */
    public Boolean getBoolean( int no ) ;
    
    /**
     * int情報を取得.
     * @param no 対象の項番を設定します.
     * @return Integer 情報が返却されます.
     */
    public Integer getInt( int no ) ;
    
    /**
     * long情報を取得.
     * @param no 対象の項番を設定します.
     * @return Long 情報が返却されます.
     */
    public Long getLong( int no ) ;
    
    /**
     * float情報を取得.
     * @param no 対象の項番を設定します.
     * @return Float 情報が返却されます.
     */
    public Float getFloat( int no ) ;
    
    /**
     * double情報を取得.
     * @param no 対象の項番を設定します.
     * @return Double 情報が返却されます.
     */
    public Double getDouble( int no ) ;
    
    /**
     * String情報を取得.
     * @param no 対象の項番を設定します.
     * @return String 情報が返却されます.
     */
    public String getString( int no ) ;
    
    /**
     * Date情報を取得.
     * @param no 対象の項番を設定します.
     * @return Date 情報が返却されます.
     */
    public java.sql.Date getDate( int no ) ;
    
    /**
     * Time情報を取得.
     * @param no 対象の項番を設定します.
     * @return Time 情報が返却されます.
     */
    public java.sql.Time getTime( int no ) ;
    
    /**
     * Timestamp情報を取得.
     * @param no 対象の項番を設定します.
     * @return Timestamp 情報が返却されます.
     */
    public java.sql.Timestamp getTimestamp( int no ) ;
    
    /**
     * boolean情報を取得.
     * @param no 対象の項番を設定します.
     * @return Boolean 情報が返却されます.
     */
    public Boolean getBoolean( long no ) ;
    
    /**
     * int情報を取得.
     * @param no 対象の項番を設定します.
     * @return Integer 情報が返却されます.
     */
    public Integer getInt( long no ) ;
    
    /**
     * long情報を取得.
     * @param no 対象の項番を設定します.
     * @return Long 情報が返却されます.
     */
    public Long getLong( long no ) ;
    
    /**
     * float情報を取得.
     * @param no 対象の項番を設定します.
     * @return Float 情報が返却されます.
     */
    public Float getFloat( long no ) ;
    
    /**
     * double情報を取得.
     * @param no 対象の項番を設定します.
     * @return Double 情報が返却されます.
     */
    public Double getDouble( long no ) ;
    
    /**
     * String情報を取得.
     * @param no 対象の項番を設定します.
     * @return String 情報が返却されます.
     */
    public String getString( long no ) ;
    
    /**
     * Date情報を取得.
     * @param no 対象の項番を設定します.
     * @return Date 情報が返却されます.
     */
    public java.sql.Date getDate( long no ) ;
    
    /**
     * Time情報を取得.
     * @param no 対象の項番を設定します.
     * @return Time 情報が返却されます.
     */
    public java.sql.Time getTime( long no ) ;
    
    /**
     * Timestamp情報を取得.
     * @param no 対象の項番を設定します.
     * @return Timestamp 情報が返却されます.
     */
    public java.sql.Timestamp getTimestamp( long no ) ;
    
    /**
     * boolean情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return Boolean 情報が返却されます.
     */
    public Boolean getBoolean( String key ) ;
    
    /**
     * int情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return Integer 情報が返却されます.
     */
    public Integer getInt( String key ) ;
    
    /**
     * long情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return Long 情報が返却されます.
     */
    public  Long getLong( String key ) ;
    
    /**
     * float情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return Float 情報が返却されます.
     */
    public Float getFloat( String key ) ;
    
    /**
     * double情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return Double 情報が返却されます.
     */
    public Double getDouble( String key ) ;
    
    /**
     * String情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return String 情報が返却されます.
     */
    public String getString( String key ) ;
    
    /**
     * Date情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return Date 情報が返却されます.
     */
    public java.sql.Date getDate( String key ) ;
    
    /**
     * Time情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return Time 情報が返却されます.
     */
    public java.sql.Time getTime( String key ) ;
    
    /**
     * Timestamp情報を取得.
     * @param key 対象のカラム名を設定します.
     * @return Timestamp 情報が返却されます.
     */
    public java.sql.Timestamp getTimestamp( String key ) ;
    
    /**
     * 空間インデックスの距離を取得.
     * @param x 中心点X軸を設定します.
     * @param y 中心点Y軸を設定します.
     * @return int 距離が返却されます.
     */
    public int getPoint( int x,int y ) ;
    
    /**
     * 空間インデックスの距離を取得.
     * @param lat 中心緯度を設定します.
     * @param lon 中心経度を設定します.
     * @return int 距離が返却されます.
     */
    public int getPoint( Number lat,Number lon ) ;
}
