package org.maachang.rimdb.index.bool ;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.index.Index;
import org.maachang.rimdb.util.NAdd;

/**
 * Bool(boolean)インデックス.
 * 
 * @version 2014/07/03
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public final class BoolIndex extends Index<Boolean> {
    
    /** インデックス情報. **/
    protected final boolean[] index ;
    protected final int indexLength ;
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param line 対象の行情報を設定します.
     * @param max 全体長を設定します.
     */
    public BoolIndex( boolean[] index,int[][] line,int max ) {
        super( line,max ) ;
        this.index = index ;
        this.indexLength = index.length ;
    }
    
    /**
     * インデックス情報を取得.
     * @return boolean[] インデックス情報が返却されます.
     */
    public boolean[] getIndex() {
        return index ;
    }
    
    /**
     * 一致検索.
     * @param key 対象のキーを設定します.
     * @return int インデックス番号が返却されます.
     */
    public final int eq( final Boolean key ) {
        for( int i = 0 ; i < indexLength ; i ++ ) {
            if( index[ i ] == key ) {
                return i ;
            }
        }
        return -1 ;
    }
    
    /**
     * 大なり検索.
     * @param eq 一致を許可する場合には[true]をセットします.
     * @param key 対象のキーを設定します.
     * @return int インデックス番号が返却されます.
     */
    public final int big( final boolean eq,final Boolean key ) {
        throw new RimDbException( "Booleanでは>or>=はサポートされていません" ) ;
    }
    
    /**
     * 小なり検索.
     * @param eq 一致を許可する場合には[true]をセットします.
     * @param key 対象のキーを設定します.
     * @return int インデックス番号が返却されます.
     */
    public final int small( final boolean eq,final Boolean key ) {
        throw new RimDbException( "Booleanでは<or<=はサポートされていません" ) ;
    }
    
    /**
     * between検索.
     * @param out 格納行情報を設定します.
     * @param start 開始値を設定します.
     * @param end 終了値を設定します.
     * @return boolean [true]の場合、範囲取得に成功しました.
     */
    public final boolean between( final int[] out,final Boolean start,final Boolean end ) {
        throw new RimDbException( "BooleanではBetweenはサポートされていません" ) ;
    }
    
    /**
     * 部分一致検索.
     * @param result 一致行情報を格納するListオブジェクトを設定します.
     * @param key 対象のLike条件を設定します.
     */
    public final void like( final NAdd result,String key ) {
        throw new RimDbException( "BooleanではLikeはサポートされていません" ) ;
    }
}

