package org.maachang.rimdb.index.number32 ;

import java.lang.reflect.Array;
import java.util.List;

import org.maachang.rimdb.index.InPointer;
import org.maachang.rimdb.util.ConvertUtil;
import org.maachang.rimdb.util.OList;

/**
 * Number32(int)複数一致ポインタ.
 * 
 * @version 2014/06/29
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
@SuppressWarnings("unchecked")
public final class Number32In extends InPointer<Integer> {
    protected Number32In(){}
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param word 対象の検索ワード群を設定します.
     */
    public Number32In( Number32Index index ) {
        this.type = TYPE_IN ;
        this.columnName = index.getColumnName() ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param word 対象の検索ワード群を設定します.
     */
    public Number32In( Number32Index index,OList<Integer> word ) {
        this( index ) ;
        set( word ) ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param word 対象の検索ワード群を設定します.
     */
    public Number32In( Number32Index index,int... word ) {
        this( index ) ;
        set( word ) ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param word 対象の検索ワード群を設定します.
     */
    public Number32In( Number32Index index,Object word ) {
        this( index ) ;
        set( word ) ;
    }
    
    
    /**
     * 情報セット.
     * @param word 対象の検索ワード群を設定します.
     */
    public final void set( final int... word ) {
        OList<Integer> n = new OList<Integer>() ;
        final int len = word.length ;
        for( int i = 0 ; i < len ; i ++ ) {
            n.add( word[ i ] ) ;
        }
        set( n ) ;
    }
    
    /**
     * 情報セット.
     * @param word 対象の検索ワード群を設定します.
     */
    public final void set( final Object word ) {
        set( getWord( word ) ) ;
    }
    
    /**
     * 情報セット.
     * @param word 対象の検索ワード群を設定します.
     */
    public final void parameter( final Object word ) {
        set( getWord( word ) ) ;
    }
    
    /**
     * ワード変換.
     * @param word 対象のワードオブジェクトを設定します.
     * @return OList 変換されたワード内容が返却されます.
     */
    public static final OList<Integer> getWord( Object word ) {
        if( word instanceof List ) {
            final List n = (List)word ;
            final int len = n.size() ;
            final OList<Integer> ret = new OList<Integer>( len ) ;
            for( int i = 0 ; i < len ; i ++ ) {
                ret.add( convert( n.get( i ) ) ) ;
            }
            return ret ;
        }
        else if( word instanceof int[] ) {
            final int[] n = (int[])word ;
            final int len = n.length ;
            final OList<Integer> ret = new OList<Integer>( len ) ;
            for( int i = 0 ; i < len ; i ++ ) {
                ret.add( n[ i ] ) ;
            }
            return ret ;
        }
        else if( word instanceof Integer[] ) {
            final Integer[] n = (Integer[])word ;
            final int len = n.length ;
            final OList<Integer> ret = new OList<Integer>( len ) ;
            for( int i = 0 ; i < len ; i ++ ) {
                ret.add( n[ i ] ) ;
            }
            return ret ;
        }
        else if( word instanceof Object[] ) {
            final Object[] n = (Object[])word ;
            final int len = n.length ;
            final OList<Integer> ret = new OList<Integer>( len ) ;
            for( int i = 0 ; i < len ; i ++ ) {
                ret.add( convert( n[ i ] ) ) ;
            }
            return ret ;
        }
        else if( word instanceof OList ) {
            final OList n = (OList)word ;
            if( n.size() != 0 && n.get( 0 ) instanceof Integer ) {
                return (OList)word ;
            }
            final int len = n.size() ;
            final OList<Integer> ret = new OList<Integer>( len ) ;
            for( int i = 0 ; i < len ; i ++ ) {
                ret.add( convert( n.get( i ) ) ) ;
            }
            return ret ;
        }
        else if( word.getClass().isArray() ) {
            final int len = Array.getLength( word ) ;
            final OList<Integer> ret = new OList<Integer>( len ) ;
            for( int i = 0 ; i < len ; i ++ ) {
                ret.add( convert( Array.get( word,i ) ) ) ;
            }
            return ret ;
        }
        final OList<Integer> ret = new OList<Integer>( 1 ) ;
        ret.add( convert( word ) ) ;
        return ret ;
    }
    
    /** int変換. **/
    protected static final int convert( final Object o ) {
        // 数値でない場合は、時間変換.
        if( !ConvertUtil.isNumeric( o ) ) {
            return (int)(ConvertUtil.convertSqlTime( o )).getTime() ;
        }
        return ConvertUtil.convertInt( o ) ;
    }
    
    /**
     * オブジェクトコピー.
     * @param mode [true]を設定した場合、パラメータ情報はコピーされません.
     * @return SearchPointer コピーされたオブジェクトが返却されます.
     */
    public final Number32In copy( final boolean mode ) {
        Number32In ret = new Number32In() ;
        baseCopy( mode,ret ) ;
        return ret ;
    }
}
