package org.maachang.rimdb.index.number64 ;

import org.maachang.rimdb.index.BetweenPointer;

/**
 * Number64(long)一致ポインタ.
 * 
 * @version 2014/06/29
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public final class Number64Between extends BetweenPointer<Long> {
    protected Number64Between(){}
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     */
    public Number64Between( Number64Index index ) {
        this.type = TYPE_BETWEEN ;
        this.columnName = index.getColumnName() ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param start 対象の開始検索ワードを設定します.
     * @param end 対象の終了検索ワードを設定します.
     */
    public Number64Between( Number64Index index,long start,long end ) {
        this( index ) ;
        set( start,end ) ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param start 対象の開始検索ワードを設定します.
     * @param end 対象の終了検索ワードを設定します.
     */
    public Number64Between( Number64Index index,Object start,Object end ) {
        this( index ) ;
        parameter( start,end ) ;
    }
    
    /**
     * 情報セット.
     * @param start 対象の開始ワード情報を設定します.
     * @param end 対象の終了ワード情報を設定します.
     */
    public final void parameter( final Object start,final Object end ) {
        set( Number64In.convert( start ),Number64In.convert( end ) ) ;
    }
    
    /**
     * オブジェクトコピー.
     * @param mode [true]を設定した場合、パラメータ情報はコピーされません.
     * @return SearchPointer コピーされたオブジェクトが返却されます.
     */
    public final Number64Between copy( final boolean mode ) {
        Number64Between ret = new Number64Between() ;
        baseCopy( mode,ret ) ;
        return ret ;
    }
}
