package org.maachang.rimdb.index.numberFloat ;

import java.lang.reflect.Array;
import java.util.List;

import org.maachang.rimdb.index.InPointer;
import org.maachang.rimdb.util.ConvertUtil;
import org.maachang.rimdb.util.OList;

/**
 * Float(double)複数一致ポインタ.
 * 
 * @version 2014/06/29
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
@SuppressWarnings("unchecked")
public final class NumberFloatIn extends InPointer<Double> {
    protected NumberFloatIn(){}
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param word 対象の検索ワード群を設定します.
     */
    public NumberFloatIn( NumberFloatIndex index ) {
        this.type = TYPE_IN ;
        this.columnName = index.getColumnName() ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param word 対象の検索ワード群を設定します.
     */
    public NumberFloatIn( NumberFloatIndex index,OList<Double> word ) {
        this( index ) ;
        set( word ) ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param word 対象の検索ワード群を設定します.
     */
    public NumberFloatIn( NumberFloatIndex index,double... word ) {
        this( index ) ;
        set( word ) ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param word 対象の検索ワード群を設定します.
     */
    public NumberFloatIn( NumberFloatIndex index,Object word ) {
        this( index ) ;
        set( word ) ;
    }
    
    /**
     * 情報セット.
     * @param word 対象の検索ワード群を設定します.
     */
    public final void set( final double... word ) {
        OList<Double> n = new OList<Double>() ;
        final int len = word.length ;
        for( int i = 0 ; i < len ; i ++ ) {
            n.add( word[ i ] ) ;
        }
        set( n ) ;
    }
    
    /**
     * 情報セット.
     * @param word 対象の検索ワード群を設定します.
     */
    public final void set( final Object word ) {
        set( getWord( word ) ) ;
    }
    
    /**
     * 情報セット.
     * @param word 対象の検索ワード群を設定します.
     */
    public final void parameter( final Object word ) {
        set( getWord( word ) ) ;
    }
    
    /**
     * ワード変換.
     * @param word 対象のワードオブジェクトを設定します.
     * @return OList 変換されたワード内容が返却されます.
     */
    public static final OList<Double> getWord( Object word ) {
        if( word instanceof List ) {
            final List n = (List)word ;
            final int len = n.size() ;
            final OList<Double> ret = new OList<Double>( len ) ;
            for( int i = 0 ; i < len ; i ++ ) {
                ret.add( convert( n.get( i ) ) ) ;
            }
            return ret ;
        }
        else if( word instanceof double[] ) {
            final double[] n = (double[])word ;
            final int len = n.length ;
            final OList<Double> ret = new OList<Double>( len ) ;
            for( int i = 0 ; i < len ; i ++ ) {
                ret.add( n[ i ] ) ;
            }
            return ret ;
        }
        else if( word instanceof Double[] ) {
            final Double[] n = (Double[])word ;
            final int len = n.length ;
            final OList<Double> ret = new OList<Double>( len ) ;
            for( int i = 0 ; i < len ; i ++ ) {
                ret.add( n[ i ] ) ;
            }
            return ret ;
        }
        else if( word instanceof Object[] ) {
            final Object[] n = (Object[])word ;
            final int len = n.length ;
            final OList<Double> ret = new OList<Double>( len ) ;
            for( int i = 0 ; i < len ; i ++ ) {
                ret.add( convert( n[ i ] ) ) ;
            }
            return ret ;
        }
        else if( word instanceof OList ) {
            final OList n = (OList)word ;
            if( n.size() != 0 && n.get( 0 ) instanceof Double ) {
                return (OList)word ;
            }
            final int len = n.size() ;
            final OList<Double> ret = new OList<Double>( len ) ;
            for( int i = 0 ; i < len ; i ++ ) {
                ret.add( convert( n.get( i ) ) ) ;
            }
            return ret ;
        }
        else if( word.getClass().isArray() ) {
            final int len = Array.getLength( word ) ;
            final OList<Double> ret = new OList<Double>( len ) ;
            for( int i = 0 ; i < len ; i ++ ) {
                ret.add( convert( Array.get( word,i ) ) ) ;
            }
            return ret ;
        }
        final OList<Double> ret = new OList<Double>( 1 ) ;
        ret.add( convert( word ) ) ;
        return ret ;
    }
    
    /** Double変換. **/
    protected static final Double convert( final Object o ) {
        return ConvertUtil.convertDouble( o ) ;
    }
    
    /**
     * オブジェクトコピー.
     * @param mode [true]を設定した場合、パラメータ情報はコピーされません.
     * @return SearchPointer コピーされたオブジェクトが返却されます.
     */
    public final NumberFloatIn copy( final boolean mode ) {
        NumberFloatIn ret = new NumberFloatIn() ;
        baseCopy( mode,ret ) ;
        return ret ;
    }
}
