package org.maachang.rimdb.search ;

/**
 * 検索条件ブロック.
 * 
 * @version 2014/07/13
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public interface Block<T> {
    
    /** ブロック条件 : AND. **/
    public static final int AND = 0 ;
    
    /** ブロック条件 : OR. **/
    public static final int OR = 1 ;
    
    /** ブロック条件 : ORリスト. **/
    public static final int AND_LIST = 2 ;
    
    /** ブロック条件 : ORリスト. **/
    public static final int OR_LIST = 3 ;
    
    /** ブロック条件 : AND空間検索. **/
    public static final int AND_POSITION = 4 ;
    
    /** ブロック条件 : OR空間検索. **/
    public static final int OR_POSITION = 5 ;
    
    /**
     * ブロックタイプを取得.
     * @return int ブロックタイプが返却されます.
     */
    public int getType() ;
    
    /**
     * 情報取得.
     * @return T 情報が返却されます.
     */
    public T get() ;
    
}
