package org.maachang.rimdb.table.array ;

import java.lang.reflect.Array;

import org.maachang.rimdb.ColumnType;

/**
 * Object配列.
 * 
 * @version 2014/07/07
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public final class ObjectArray implements ColumnArray<Object> {
    private Object[] list ;
    
    /**
     * コンストラクタ.
     * @param columns カラム群を設定します.
     */
    public ObjectArray( final Object columns ) {
        final int len = Array.getLength( columns ) ;
        list = new Object[ len ] ;
        System.arraycopy( columns,0,list,0,len ) ;
    }
    
    /**
     * カラムタイプを取得.
     * @return int カラムタイプが返却されます.
     */
    public final int getType() {
        return ColumnType.TYPE_OBJECT ;
    }
    
    /**
     * 指定位置の情報を取得.
     * @param no 対象の項番を設定します.
     * @return Object 情報が返却されます.
     */
    public final Object get( final int no ) {
        return list[ no ] ;
    }
}
