package org.maachang.rimdb.util ;


/**
 * 数字配列オブジェクト.
 * 
 * @version 2014/06/29
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public final class NArray implements NAdd {
    private int[] list ;
    private int position ;
    
    /**
     * コンストラクタ.
     * @param len 対象の配列長を設定します.
     */
    public NArray( int len ) {
        list = new int[ len ] ;
        position = 0 ;
    }
    
    /**
     * 情報クリア.
     */
    public final void clear() {
        position = 0 ;
    }
    
    /**
     * 配列の長さを指定して、情報クリア.
     * @param buf 対象の長さを設定します.
     */
    public final void clear( int buf ) {
        if( list.length < buf ) {
            list = new int[ buf ] ;
        }
        position = 0 ;
    }
    
    /**
     * 情報追加.
     * @param n 対象の数値を設定します.
     */
    public final void add( int n ) {
        list[ position ++ ] = n ;
    }
    
    /**
     * 情報取得.
     * @param no 対象の項番を設定します.
     * @return int 対象条件が返却されます.
     * @version rimdb-1.01
     */
    public final int get( int no ) {
        return list[ no ] ;
    }
    
    /**
     * サイズを取得.
     * @return int サイズが返却されます.
     */
    public final int size() {
        return position ;
    }
    
    /**
     * 配列を取得.
     * @return int[] 配列が返却されます.
     */
    public final int[] getArray() {
        if( list.length != position ) {
            int[] ret = new int[ position ] ;
            System.arraycopy( list,0,ret,0,position ) ;
            return ret ;
        }
        return list ;
    }
    
    /**
     * 素の配列を取得.
     * @return int[] 素の配列が返却されます.
     */
    public final int[] toArray() {
        return list ;
    }
}

