package org.maachang.rimdb.util ;

/**
 * オブジェクトKeyValue.
 * 
 * @version 2014/06/29
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
@SuppressWarnings("unchecked")
public final class OOKeyValue<K,V> {
    private static final int DEF_LENGTH = 32 ;
    private static final int MIN_LENGTH = 4 ;
    
    private OOChild[] list ;
    private int mask ;
    private int length ;
    private int limit ;
    private int base ;
    
    private OOChild<K,V> nullValue ;
    
    /**
     * コンストラクタ.
     */
    public OOKeyValue() {
        this( DEF_LENGTH ) ;
    }
    
    /**
     * コンストラクタ.
     * @param size 初期サイズを設定します.
     */
    public OOKeyValue( int size ) {
        if( size < MIN_LENGTH ) {
            size = MIN_LENGTH ;
        }
        else {
            size = ConvertUtil.bitMask( size ) ;
        }
        list = new OOChild[ size ] ;
        length = 0 ;
        mask = size - 1 ;
        limit = size ;
        base = size ;
        nullValue = null ;
    }
    
    /**
     * クリア.
     */
    public void clear() {
        list = new OOChild[ base ] ;
        length = 0 ;
        mask = base - 1 ;
        limit = base ;
        nullValue = null ;
    }
    
    /**
     * 数値追加.
     * @param b 対象の数値を設定します.
     * @param o 対象の要素を設定します.
     * @return OOChild<K,V> 子要素が返却されます.
     */
    public OOChild<K,V> put( K b,V o ) {
        if( b == null ) {
            nullValue = new OOChild( null,o ) ;
            return nullValue ;
        }
        int h,bh ;
        if( length + 1 >= limit ) {
            int nLen = limit << 1 ;
            int msk = nLen - 1 ;
            OOChild[] nList = new OOChild[ nLen ] ;
            OOChild n,t ;
            for( int i = 0 ; i < limit ; i ++ ) {
                n = list[ i ] ;
                while( n != null ) {
                    if( nList[ ( h = n.b.hashCode() & msk ) ] == null ) {
                        t = n.n ;
                        n.n = null ;
                    }
                    else {
                        t = n.n ;
                        n.n = nList[ h ] ;
                    }
                    nList[ h ] = n ;
                    n = t ;
                }
            }
            list = nList ;
            limit = nLen ;
            mask = msk ;
        }
        if( list[ ( h = b.hashCode() & mask ) ] == null ) {
            list[ h ] = new OOChild( b,o ) ;
            length ++ ;
            return list[ h ] ;
        }
        bh = b.hashCode() ;
        OOChild nn = list[ h ] ;
        while( nn.n != null ) {
            if( nn.b.hashCode() == bh && ( nn.b == b || nn.b.equals( b ) ) ) {
                nn.o = o ;
                return nn ;
            }
            nn = nn.n ;
        }
        if( nn.b.hashCode() == bh && ( nn.b == b || nn.b.equals( b ) ) ) {
            nn.o = o ;
            return nn ;
        }
        nn.n = new OOChild( b,o ) ;
        length ++ ;
        return nn.n ;
    }
    
    /**
     * 情報が存在するかチェック.
     * @param b 対象のキーを設定します.
     * @return boolean [true]の場合、数値は存在します.
     */
    public boolean containsKey( K b ) {
        if( b == null ) {
            return nullValue != null ;
        }
        int hb = b.hashCode() ;
        OOChild n = list[ hb & mask ] ;
        while( n != null ) {
            if( n.b.hashCode() == hb && ( n.b == b || n.b.equals( b ) ) ) {
                return true ;
            }
            n = n.n ;
        }
        return false ;
    }
    
    /**
     * 要素を取得.
     * @param b 対象のキーを設定します.
     * @return V 要素情報が返却されます.
     */
    public V get( K b ) {
        if( b == null ) {
            if( nullValue != null ) {
                return nullValue.o ;
            }
            return null ;
        }
        int hb = b.hashCode() ;
        OOChild n = list[ hb & mask ] ;
        while( n != null ) {
            if( n.b.hashCode() == hb && ( n.b == b || n.b.equals( b ) ) ) {
                return (V)n.o ;
            }
            n = n.n ;
        }
        return null ;
    }
    
    /**
     * 要素を取得.
     * @param b 対象のキーを設定します.
     * @return  OOChild<K,V> 要素情報が返却されます.
     */
    public OOChild<K,V> getChild( K b ) {
        if( b == null ) {
            return nullValue ;
        }
        int hb = b.hashCode() ;
        OOChild n = list[ hb & mask ] ;
        while( n != null ) {
            if( n.b.hashCode() == hb && ( n.b == b || n.b.equals( b ) ) ) {
                return n ;
            }
            n = n.n ;
        }
        return null ;
    }
    
    /**
     * 削除処理.
     * @param b 対象のキーを設定します.
     */
    public void remove( Object b ) {
        if( b == null ) {
            nullValue = null ;
            return ;
        }
        int bh = b.hashCode() ;
        OOChild bf = null ;
        OOChild n = list[ bh & mask ] ;
        while( n != null ) {
            if( n.b.hashCode() == bh && ( n.b == b || n.b.equals( b ) ) ) {
                if( bf == null ) {
                    if( n.n == null ) {
                        list[ bh & mask ] = null ;
                    }
                    else {
                        list[ bh & mask ] = n.n ;
                    }
                }
                else {
                    if( n.n == null ) {
                        bf.n = null ;
                    }
                    else {
                        bf.n = n.n ;
                    }
                }
                length -- ;
                break ;
            }
            bf = n ;
            n = n.n ;
        }
    }
    
    /**
     * サイズを取得.
     * @return int サイズが返却されます.
     */
    public int size() {
        return ( nullValue != null ) ? length + 1 : length ;
    }
    
    /**
     * 配列として返却.
     * @return Object[] 配列として返却します.
     */
    public Object[] keyArray() {
        if( size() == 0 ) {
            return null ;
        }
        OOChild n ;
        int cnt ;
        Object[] ret ;
        if( nullValue != null ) {
            ret = new Object[ length + 1 ] ;
            cnt = 1 ;
        }
        else {
            ret = new Object[ length ] ;
            cnt = 0 ;
        }
        for( int i = 0 ; i < limit ; i ++ ) {
            if( list[ i ] != null ) {
                n = list[ i ] ;
                while( n != null ) {
                    ret[ cnt ++ ] = n.b ;
                    n = n.n ;
                }
            }
        }
        return ret ;
    }
    
    /** 位置読み込み条件. **/
    private int pos = 0 ;
    private OOChild cPos = null ;
    private int count = 0 ;
    
    /**
     * 読み込み中の位置をリセット.
     * @return OOKeyValue このオブジェクトが返却されます.
     */
    public OOKeyValue<K,V> reset() {
        pos = 0 ;
        cPos = null ;
        count = 0 ;
        return this ;
    }
    
    /**
     * 次の読み込み条件を取得.
     * @return boolean [true]が返却された場合、情報は存在します.
     */
    public boolean hasNext() {
        if( count == 0 ) {
            if( nullValue != null ) {
                count ++ ;
                cPos = nullValue ;
                return true ;
            }
        }
        if( cPos != null ) {
            if( ( cPos = cPos.n ) != null ) {
                count ++ ;
                return true ;
            }
        }
        while( pos < limit ) {
            if( ( cPos = list[ pos ++ ] ) != null ) {
                count ++ ;
                return true ;
            }
        }
        return false ;
    }
    
    /**
     * 現在の読み込み位置の情報を取得.
     * @return Object 現在の読み込み位置の内容が返却されます.
     *                 [null]の場合は、情報は存在しません.
     */
    public K next() {
        if( cPos == null ) {
            return null ;
        }
        return (K)cPos.b ;
    }
    
    /*
     * 現在の読み込み位置の要素情報を取得.
     * @return Object 現在の読み込み位置の内容が返却されます.
     */
    public V nextValue() {
        if( cPos == null ) {
            return null ;
        }
        return (V)cPos.o ;
    }
    
    /*
     * 現在の読み込み位置の子要素情報を取得.
     * @return OOChild<K,V> 現在の読み込み位置の子要素が返却されます.
     */
    public OOChild<K,V> nextChild() {
        return cPos ;
    }
    
    /**
     * カウントを取得.
     * @return int 現在読み込み中の位置が返却されます.
     */
    public int count() {
        return count ;
    }
}
