package test ;

import org.maachang.rimdb.* ;

// サンプル2.
// SQL文でtestテーブルから情報を取得.
//
public final class Sample2 {
    
    public static final void main( String[] args ) throws Exception {
        
        // コンフィグファイル名.
        // ※環境に合わせて変更してください.
        String confFile = "/C:/project/java/project/ReadInMemoryDB/sample/conf/rimdb.conf" ;
        
        // rimdbの定義を読み込む.
        TableFactory factory = TableFactory.getInstance() ;
        factory.init( confFile ) ;
        
        // test名でSearchオブジェクトをキャッシュして、SQL文を解析.
        Search s = Sql.create( "$test from test_table where id=? ;" ) ;
        
        // IDのパラメータセット.
        s.setParameter( 0,2 ) ;
        
        // 実行処理.
        SearchResult res = s.execute() ;
        
        // 処理件数を取得.
        System.out.println( res.getLength() + "件の情報を取得" ) ;
        
        // 取得結果を出力.
        while( res.hasNext() ) {
            Row row = res.next() ;
            System.out.println( row ) ;
        }
        
    }
}
