/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.leveldb;

import org.maachang.leveldb.Unsafe;
import org.maachang.leveldb.jni;

public final class JniIO {
    private static final boolean UnsafeMode = Unsafe.UNSAFE_MODE;
    private static final sun.misc.Unsafe unsafe = Unsafe.unsafe;

    protected JniIO() {
    }

    public static final long malloc(int len) {
        return jni.malloc(len);
    }

    public static final long realloc(long addr, int len) {
        return jni.realloc(addr, len);
    }

    public static final void free(long addr) {
        jni.free(addr);
    }

    public static final void memset(long addr, int code, int len) {
        jni.memset(addr, (byte)code, len);
    }

    public static final void memset(long addr, byte code, int len) {
        jni.memset(addr, code, len);
    }

    public static final void memcpy(long dest, long src, int len) {
        jni.memcpy(dest, src, len);
    }

    public static final byte get(long address, int index) {
        if (UnsafeMode) {
            return unsafe.getByte(address + (long)index);
        }
        return jni.getByte(address + (long)index);
    }

    public static final void put(long address, int index, byte value) {
        if (UnsafeMode) {
            unsafe.putByte(address + (long)index, value);
        } else {
            jni.putByte(address + (long)index, value);
        }
    }

    public static final int putBinary(long address, int index, byte[] value, int offset, int length) {
        jni.putBinary(address + (long)index, value, offset, length);
        return length;
    }

    public static final int getBinary(long address, int index, byte[] value, int offset, int length) {
        jni.getBinary(address + (long)index, value, offset, length);
        return length;
    }

    public static final void putBoolean(long address, int index, boolean value) {
        if (UnsafeMode) {
            unsafe.putByte(address + (long)index, value ? (byte)1 : 0);
        } else {
            jni.putByte(address + (long)index, value ? (byte)1 : 0);
        }
    }

    public static final boolean getBoolean(long address, int index) {
        if (UnsafeMode) {
            return unsafe.getByte(address + (long)index) != 0;
        }
        return jni.getByte(address + (long)index) != 0;
    }

    public static final void putChar(long address, int index, char value) {
        if (UnsafeMode) {
            unsafe.putChar(address + (long)index, value);
        } else {
            jni.putChar(address + (long)index, value);
        }
    }

    public static final char getChar(long address, int index) {
        if (UnsafeMode) {
            return unsafe.getChar(address + (long)index);
        }
        return jni.getChar(address + (long)index);
    }

    public static final void putShort(long address, int index, short value) {
        if (UnsafeMode) {
            unsafe.putShort(address + (long)index, value);
        } else {
            jni.putShort(address + (long)index, value);
        }
    }

    public static final short getShort(long address, int index) {
        if (UnsafeMode) {
            return unsafe.getShort(address + (long)index);
        }
        return jni.getShort(address + (long)index);
    }

    public static final void putInt(long address, int index, int value) {
        if (UnsafeMode) {
            unsafe.putInt(address + (long)index, value);
        } else {
            jni.putInt(address + (long)index, value);
        }
    }

    public static final int getInt(long address, int index) {
        if (UnsafeMode) {
            return unsafe.getInt(address + (long)index);
        }
        return jni.getInt(address + (long)index);
    }

    public static final void putLong(long address, int index, long value) {
        if (UnsafeMode) {
            unsafe.putLong(address + (long)index, value);
        } else {
            jni.putLong(address + (long)index, value);
        }
    }

    public static final long getLong(long address, int index) {
        if (UnsafeMode) {
            return unsafe.getLong(address + (long)index);
        }
        return jni.getLong(address + (long)index);
    }

    public static final void putFloat(long address, int index, float value) {
        JniIO.putInt(address, index, Float.floatToIntBits(value));
    }

    public static final float getFloat(long address, int index) {
        return Float.intBitsToFloat(JniIO.getInt(address, index));
    }

    public static final void putDouble(long address, int index, double value) {
        JniIO.putLong(address, index, Double.doubleToLongBits(value));
    }

    public static final double getDouble(long address, int index) {
        return Double.longBitsToDouble(JniIO.getLong(address, index));
    }
}

