/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.leveldb;

import org.maachang.leveldb.JniBuffer;
import org.maachang.leveldb.Leveldb;
import org.maachang.leveldb.LeveldbException;
import org.maachang.leveldb.jni;

public final class LeveldbIterator {
    protected Leveldb parent;
    private long addr;

    protected LeveldbIterator() {
    }

    protected LeveldbIterator(Leveldb p) {
        if (p == null || p.isClose()) {
            throw new LeveldbException("\u5bfe\u8c61\u306eLeveldb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u308b\u304b\u3001\u7121\u52b9\u3067\u3059.");
        }
        this.parent = p;
        this.addr = jni.leveldb_iterator(p.addr);
        jni.leveldb_itr_first(this.addr);
    }

    protected final void finalize() {
        this.close();
    }

    public void close() {
        if (this.addr != 0L) {
            jni.leveldb_itr_delete(this.addr);
            this.addr = 0L;
        }
    }

    public final boolean isClose() {
        return this.parent.closeFlag || this.addr == 0L;
    }

    protected final void check() {
        if (this.parent.closeFlag || this.addr == 0L) {
            throw new LeveldbException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
    }

    public final void first() {
        this.check();
        jni.leveldb_itr_first(this.addr);
    }

    public final void last() {
        this.check();
        jni.leveldb_itr_last(this.addr);
    }

    public final void seek(JniBuffer key) {
        this.check();
        if (key == null || key.position() == 0) {
            throw new LeveldbException("\u30ad\u30fc\u60c5\u5831\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        jni.leveldb_itr_seek(this.addr, key.address(), key.position());
    }

    public final void next() {
        this.check();
        jni.leveldb_itr_next(this.addr);
    }

    public final boolean valid() {
        this.check();
        return jni.leveldb_itr_valid(this.addr) == 1;
    }

    public final int key(JniBuffer out) {
        this.check();
        if (out == null) {
            return -1;
        }
        long[] n = new long[]{out.address()};
        int len = jni.leveldb_itr_key(this.addr, n, out.length());
        if (len <= 0) {
            return 0;
        }
        if (len > out.length()) {
            out.set(n[0], len, len);
        } else {
            out.position(len);
        }
        return len;
    }

    public final int value(JniBuffer out) {
        this.check();
        if (out == null) {
            return -1;
        }
        long[] n = new long[]{out.address()};
        int len = jni.leveldb_itr_value(this.addr, n, out.length());
        if (len <= 0) {
            return 0;
        }
        if (len > out.length()) {
            out.set(n[0], len, len);
        } else {
            out.position(len);
        }
        return len;
    }
}

