/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.leveldb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.maachang.leveldb.JniBuffer;
import org.maachang.leveldb.JniIO;

public final class ValueBinary {
    protected ValueBinary() {
    }

    public static final void encode(OutputStream buf, Object o) throws Exception {
        ValueBinary.encodeObject(buf, o);
    }

    public static final Object decode(JniBuffer b) throws Exception {
        return ValueBinary.decode(b, 0, b.position());
    }

    public static final Object decode(JniBuffer b, int off, int len) throws Exception {
        if (len > b.position()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u9577\u3055\u306f\u3001\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059:" + len + "," + b.position());
        }
        int[] p = new int[]{off};
        return ValueBinary.decodeObject(p, b, len);
    }

    public static final Object decodeBinary(int[] outOff, JniBuffer b, int len) throws Exception {
        if (len > b.position()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u9577\u3055\u306f\u3001\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059:" + len + "," + b.position());
        }
        return ValueBinary.decodeObject(outOff, b, len);
    }

    public static final void byte1(OutputStream buf, int b) throws Exception {
        buf.write(b & 0xFF);
    }

    public static final void byte2(OutputStream buf, int b) throws Exception {
        buf.write(new byte[]{(byte)((b & 0xFF00) >> 8), (byte)(b & 0xFF)});
    }

    public static final void byte4(OutputStream buf, int b) throws Exception {
        int bit = ValueBinary.nlzs(b);
        int src = (bit >> 3) + (bit & 1 | bit >> 1 & 1 | bit >> 2 & 1);
        bit += 2;
        if ((bit = (bit >> 3) + (bit & 1 | bit >> 1 & 1 | bit >> 2 & 1)) == src) {
            switch (bit) {
                case 1: {
                    buf.write(new byte[]{(byte)(b & 0xFF)});
                    return;
                }
                case 2: {
                    buf.write(new byte[]{(byte)(0x40 | (b & 0xFF00) >> 8), (byte)(b & 0xFF)});
                    return;
                }
                case 3: {
                    buf.write(new byte[]{(byte)(0x80 | (b & 0xFF0000) >> 16), (byte)((b & 0xFF00) >> 8), (byte)(b & 0xFF)});
                    return;
                }
                case 4: {
                    buf.write(new byte[]{(byte)(0xC0 | (b & 0xFF000000) >> 24), (byte)((b & 0xFF0000) >> 16), (byte)((b & 0xFF00) >> 8), (byte)(b & 0xFF)});
                    return;
                }
            }
        }
        switch (src) {
            case 0: 
            case 1: {
                byte[] byArray = new byte[2];
                byArray[1] = (byte)(b & 0xFF);
                buf.write(byArray);
                return;
            }
            case 2: {
                buf.write(new byte[]{64, (byte)((b & 0xFF00) >> 8), (byte)(b & 0xFF)});
                return;
            }
            case 3: {
                buf.write(new byte[]{-128, (byte)((b & 0xFF0000) >> 16), (byte)((b & 0xFF00) >> 8), (byte)(b & 0xFF)});
                return;
            }
            case 4: {
                buf.write(new byte[]{-64, (byte)((b & 0xFF000000) >> 24), (byte)((b & 0xFF0000) >> 16), (byte)((b & 0xFF00) >> 8), (byte)(b & 0xFF)});
                return;
            }
        }
    }

    public static final void byte8(OutputStream buf, long b) throws Exception {
        int bit = ValueBinary.nlzs(b);
        int src = (bit >> 3) + (bit & 1 | bit >> 1 & 1 | bit >> 2 & 1);
        bit += 3;
        if ((bit = (bit >> 3) + (bit & 1 | bit >> 1 & 1 | bit >> 2 & 1)) == src) {
            switch (bit) {
                case 1: {
                    buf.write(new byte[]{(byte)(b & 0xFFL)});
                    return;
                }
                case 2: {
                    buf.write(new byte[]{(byte)(0x20L | (b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                    return;
                }
                case 3: {
                    buf.write(new byte[]{(byte)(0x40L | (b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                    return;
                }
                case 4: {
                    buf.write(new byte[]{(byte)(0x60L | (b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                }
                case 5: {
                    buf.write(new byte[]{(byte)(0x80L | (b & 0xFF00000000L) >> 32), (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                    return;
                }
                case 6: {
                    buf.write(new byte[]{(byte)(0xA0L | (b & 0xFF0000000000L) >> 40), (byte)((b & 0xFF00000000L) >> 32), (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                    return;
                }
                case 7: {
                    buf.write(new byte[]{(byte)(0xC0L | (b & 0xFF000000000000L) >> 48), (byte)((b & 0xFF0000000000L) >> 40), (byte)((b & 0xFF00000000L) >> 32), (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                    return;
                }
                case 8: {
                    buf.write(new byte[]{(byte)(0xE0L | (b & 0xFF00000000000000L) >> 56), (byte)((b & 0xFF000000000000L) >> 48), (byte)((b & 0xFF0000000000L) >> 40), (byte)((b & 0xFF00000000L) >> 32), (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                    return;
                }
            }
        }
        switch (src) {
            case 0: 
            case 1: {
                byte[] byArray = new byte[2];
                byArray[1] = (byte)(b & 0xFFL);
                buf.write(byArray);
                return;
            }
            case 2: {
                buf.write(new byte[]{32, (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                return;
            }
            case 3: {
                buf.write(new byte[]{64, (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                return;
            }
            case 4: {
                buf.write(new byte[]{96, (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                return;
            }
            case 5: {
                buf.write(new byte[]{-128, (byte)((b & 0xFF00000000L) >> 32), (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                return;
            }
            case 6: {
                buf.write(new byte[]{-96, (byte)((b & 0xFF0000000000L) >> 40), (byte)((b & 0xFF00000000L) >> 32), (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                return;
            }
            case 7: {
                buf.write(new byte[]{-64, (byte)((b & 0xFF000000000000L) >> 48), (byte)((b & 0xFF0000000000L) >> 40), (byte)((b & 0xFF00000000L) >> 32), (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                return;
            }
            case 8: {
                buf.write(new byte[]{-32, (byte)((b & 0xFF00000000000000L) >> 56), (byte)((b & 0xFF000000000000L) >> 48), (byte)((b & 0xFF0000000000L) >> 40), (byte)((b & 0xFF00000000L) >> 32), (byte)((b & 0xFF000000L) >> 24), (byte)((b & 0xFF0000L) >> 16), (byte)((b & 0xFF00L) >> 8), (byte)(b & 0xFFL)});
                return;
            }
        }
    }

    public static final void stringBinary(OutputStream buf, String s) throws Exception {
        byte[] b = s.getBytes("UTF8");
        ValueBinary.byte4(buf, b.length);
        buf.write(b, 0, b.length);
    }

    public static final void serialBinary(OutputStream buf, Serializable s) throws Exception {
        byte[] b = ValueBinary.toBinary(s);
        ValueBinary.byte4(buf, b.length);
        buf.write(b, 0, b.length);
    }

    protected static final byte[] toBinary(Serializable value) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] ret = null;
        ObjectOutputStream o = null;
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            o = new ObjectOutputStream(b);
            o.writeObject(value);
            o.flush();
            ret = b.toByteArray();
        }
        finally {
            try {
                o.close();
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    private static final void head(OutputStream buf, int n) throws Exception {
        ValueBinary.byte1(buf, n);
    }

    public static final void encodeObject(OutputStream buf, Object o) throws Exception {
        if (o == null) {
            ValueBinary.head(buf, 255);
        } else if (o instanceof String) {
            ValueBinary.head(buf, 1);
            ValueBinary.stringBinary(buf, (String)o);
        } else if (o instanceof Number) {
            if (o instanceof Byte) {
                ValueBinary.head(buf, 4);
                ValueBinary.byte1(buf, ((Byte)o).byteValue());
            } else if (o instanceof Short) {
                ValueBinary.head(buf, 5);
                ValueBinary.byte2(buf, ((Short)o).shortValue());
            } else if (o instanceof Integer) {
                ValueBinary.head(buf, 6);
                ValueBinary.byte4(buf, (Integer)o);
            } else if (o instanceof Long) {
                ValueBinary.head(buf, 7);
                ValueBinary.byte8(buf, (Long)o);
            } else if (o instanceof Float) {
                ValueBinary.head(buf, 8);
                ValueBinary.byte4(buf, Float.floatToRawIntBits(((Float)o).floatValue()));
            } else if (o instanceof Double) {
                ValueBinary.head(buf, 9);
                ValueBinary.byte8(buf, Double.doubleToRawLongBits((Double)o));
            } else if (o instanceof AtomicInteger) {
                ValueBinary.head(buf, 10);
                ValueBinary.byte4(buf, ((AtomicInteger)o).get());
            } else if (o instanceof AtomicLong) {
                ValueBinary.head(buf, 11);
                ValueBinary.byte8(buf, ((AtomicLong)o).get());
            } else if (o instanceof BigDecimal) {
                ValueBinary.head(buf, 12);
                ValueBinary.stringBinary(buf, o.toString());
            } else if (o instanceof BigInteger) {
                ValueBinary.head(buf, 13);
                ValueBinary.stringBinary(buf, o.toString());
            }
        } else if (o instanceof Boolean) {
            ValueBinary.head(buf, 2);
            ValueBinary.byte1(buf, (Boolean)o != false ? 1 : 0);
        } else if (o instanceof Character) {
            ValueBinary.head(buf, 3);
            ValueBinary.byte2(buf, ((Character)o).charValue());
        } else if (o instanceof java.util.Date) {
            ValueBinary.head(buf, 14);
            if (o instanceof Date) {
                ValueBinary.byte1(buf, 1);
            } else if (o instanceof Time) {
                ValueBinary.byte1(buf, 2);
            } else if (o instanceof Timestamp) {
                ValueBinary.byte1(buf, 3);
            } else {
                ValueBinary.byte1(buf, 4);
            }
            ValueBinary.byte8(buf, ((java.util.Date)o).getTime());
        } else if (o instanceof List) {
            ValueBinary.head(buf, 51);
            List lst = (List)o;
            int len = lst.size();
            ValueBinary.byte4(buf, len);
            int i = 0;
            while (i < len) {
                ValueBinary.encodeObject(buf, lst.get(i));
                ++i;
            }
        } else if (o instanceof Map) {
            ValueBinary.head(buf, 52);
            Map map = (Map)o;
            ValueBinary.byte4(buf, map.size());
            for (Object k : map.keySet()) {
                ValueBinary.encodeObject(buf, k);
                ValueBinary.encodeObject(buf, map.get(k));
            }
        } else if (o instanceof Set) {
            ValueBinary.head(buf, 53);
            Set set = (Set)o;
            ValueBinary.byte4(buf, set.size());
            Iterator it = set.iterator();
            while (it.hasNext()) {
                ValueBinary.encodeObject(buf, it.next());
            }
        } else if (o instanceof Serializable) {
            ValueBinary.head(buf, 60);
            ValueBinary.serialBinary(buf, (Serializable)o);
        } else if (o.getClass().isArray()) {
            if (o instanceof boolean[]) {
                ValueBinary.head(buf, 20);
                boolean[] c = (boolean[])o;
                int len = c.length;
                ValueBinary.byte4(buf, len);
                int i = 0;
                while (i < len) {
                    ValueBinary.byte1(buf, c[i] ? 1 : 0);
                    ++i;
                }
            } else if (o instanceof byte[]) {
                ValueBinary.head(buf, 21);
                byte[] b = (byte[])o;
                ValueBinary.byte4(buf, b.length);
                buf.write(b, 0, b.length);
                b = null;
            } else if (o instanceof char[]) {
                ValueBinary.head(buf, 22);
                char[] c = (char[])o;
                int len = c.length;
                ValueBinary.byte4(buf, len);
                int i = 0;
                while (i < len) {
                    ValueBinary.byte2(buf, c[i]);
                    ++i;
                }
            } else if (o instanceof short[]) {
                ValueBinary.head(buf, 23);
                short[] c = (short[])o;
                int len = c.length;
                ValueBinary.byte4(buf, len);
                int i = 0;
                while (i < len) {
                    ValueBinary.byte2(buf, c[i]);
                    ++i;
                }
            } else if (o instanceof int[]) {
                ValueBinary.head(buf, 24);
                int[] c = (int[])o;
                int len = c.length;
                ValueBinary.byte4(buf, len);
                int i = 0;
                while (i < len) {
                    ValueBinary.byte4(buf, c[i]);
                    ++i;
                }
            } else if (o instanceof long[]) {
                ValueBinary.head(buf, 25);
                long[] c = (long[])o;
                int len = c.length;
                ValueBinary.byte4(buf, len);
                int i = 0;
                while (i < len) {
                    ValueBinary.byte8(buf, c[i]);
                    ++i;
                }
            } else if (o instanceof float[]) {
                ValueBinary.head(buf, 26);
                float[] c = (float[])o;
                int len = c.length;
                ValueBinary.byte4(buf, len);
                int i = 0;
                while (i < len) {
                    ValueBinary.byte4(buf, Float.floatToRawIntBits(c[i]));
                    ++i;
                }
            } else if (o instanceof double[]) {
                ValueBinary.head(buf, 27);
                double[] c = (double[])o;
                int len = c.length;
                ValueBinary.byte4(buf, len);
                int i = 0;
                while (i < len) {
                    ValueBinary.byte8(buf, Double.doubleToRawLongBits(c[i]));
                    ++i;
                }
            } else if (o instanceof String[]) {
                ValueBinary.head(buf, 28);
                String[] c = (String[])o;
                int len = c.length;
                ValueBinary.byte4(buf, len);
                int i = 0;
                while (i < len) {
                    ValueBinary.stringBinary(buf, c[i]);
                    ++i;
                }
            } else if (o instanceof Object[]) {
                ValueBinary.head(buf, 50);
                ValueBinary.byte4(buf, 0);
                Object[] c = (Object[])o;
                int len = c.length;
                ValueBinary.byte4(buf, len);
                int i = 0;
                while (i < len) {
                    ValueBinary.encodeObject(buf, c[i]);
                    ++i;
                }
            } else {
                String s = o.getClass().getName();
                if (s.startsWith("[L")) {
                    ValueBinary.head(buf, 50);
                    if ("[Ljava.lang.Object;".equals(s)) {
                        ValueBinary.byte4(buf, 0);
                    } else {
                        ValueBinary.stringBinary(buf, s.substring(2, s.length() - 1).trim());
                    }
                    int len = Array.getLength(o);
                    ValueBinary.byte4(buf, len);
                    int i = 0;
                    while (i < len) {
                        ValueBinary.encodeObject(buf, Array.get(o, i));
                        ++i;
                    }
                } else {
                    ValueBinary.head(buf, 255);
                }
            }
        } else {
            ValueBinary.head(buf, 255);
        }
    }

    public static final int byte1Int(long b, int[] off) {
        int n = off[0];
        off[0] = n + 1;
        return JniIO.get(b, n) & 0xFF;
    }

    public static final int byte2Int(long b, int[] off) {
        int n = off[0];
        off[0] = n + 1;
        int n2 = off[0];
        off[0] = n2 + 1;
        return (JniIO.get(b, n) & 0xFF) << 8 | JniIO.get(b, n2) & 0xFF;
    }

    public static final int byte4Int(long b, int[] off) {
        int o = off[0];
        byte h = JniIO.get(b, o);
        if ((h & 0x3F) == 0) {
            switch ((h & 0xC0) >> 6) {
                case 0: {
                    off[0] = off[0] + 2;
                    return JniIO.get(b, o + 1) & 0xFF;
                }
                case 1: {
                    off[0] = off[0] + 3;
                    return (JniIO.get(b, o + 1) & 0xFF) << 8 | JniIO.get(b, o + 2) & 0xFF;
                }
                case 2: {
                    off[0] = off[0] + 4;
                    return (JniIO.get(b, o + 1) & 0xFF) << 16 | (JniIO.get(b, o + 2) & 0xFF) << 8 | JniIO.get(b, o + 3) & 0xFF;
                }
                case 3: {
                    off[0] = off[0] + 5;
                    return (JniIO.get(b, o + 1) & 0xFF) << 24 | (JniIO.get(b, o + 2) & 0xFF) << 16 | (JniIO.get(b, o + 3) & 0xFF) << 8 | JniIO.get(b, o + 4) & 0xFF;
                }
            }
            throw new IllegalArgumentException("\u4e0d\u6b63\u306abyte4Int\u6761\u4ef6:" + off[0]);
        }
        switch ((h & 0xC0) >> 6) {
            case 0: {
                off[0] = off[0] + 1;
                return h & 0x3F;
            }
            case 1: {
                off[0] = off[0] + 2;
                return (h & 0x3F) << 8 | JniIO.get(b, o + 1) & 0xFF;
            }
            case 2: {
                off[0] = off[0] + 3;
                return (h & 0x3F) << 16 | (JniIO.get(b, o + 1) & 0xFF) << 8 | JniIO.get(b, o + 2) & 0xFF;
            }
            case 3: {
                off[0] = off[0] + 4;
                return (h & 0x3F) << 24 | (JniIO.get(b, o + 1) & 0xFF) << 16 | (JniIO.get(b, o + 2) & 0xFF) << 8 | JniIO.get(b, o + 3) & 0xFF;
            }
        }
        throw new IllegalArgumentException("\u4e0d\u6b63\u306abyte4Int\u6761\u4ef6:" + off[0]);
    }

    public static final long byte8Long(long b, int[] off) {
        int o = off[0];
        byte h = JniIO.get(b, o);
        if ((h & 0x1F) == 0) {
            switch ((h & 0xE0) >> 5) {
                case 0: {
                    off[0] = off[0] + 2;
                    return JniIO.get(b, o + 1) & 0xFF;
                }
                case 1: {
                    off[0] = off[0] + 3;
                    return (JniIO.get(b, o + 1) & 0xFF) << 8 | JniIO.get(b, o + 2) & 0xFF;
                }
                case 2: {
                    off[0] = off[0] + 4;
                    return (JniIO.get(b, o + 1) & 0xFF) << 16 | (JniIO.get(b, o + 2) & 0xFF) << 8 | JniIO.get(b, o + 3) & 0xFF;
                }
                case 3: {
                    off[0] = off[0] + 5;
                    return (JniIO.get(b, o + 1) & 0xFF) << 24 | (JniIO.get(b, o + 2) & 0xFF) << 16 | (JniIO.get(b, o + 3) & 0xFF) << 8 | JniIO.get(b, o + 4) & 0xFF;
                }
                case 4: {
                    off[0] = off[0] + 6;
                    return ((long)JniIO.get(b, o + 1) & 0xFFL) << 32 | ((long)JniIO.get(b, o + 2) & 0xFFL) << 24 | ((long)JniIO.get(b, o + 3) & 0xFFL) << 16 | ((long)JniIO.get(b, o + 4) & 0xFFL) << 8 | (long)JniIO.get(b, o + 5) & 0xFFL;
                }
                case 5: {
                    off[0] = off[0] + 7;
                    return ((long)JniIO.get(b, o + 1) & 0xFFL) << 40 | ((long)JniIO.get(b, o + 2) & 0xFFL) << 32 | ((long)JniIO.get(b, o + 3) & 0xFFL) << 24 | ((long)JniIO.get(b, o + 4) & 0xFFL) << 16 | ((long)JniIO.get(b, o + 5) & 0xFFL) << 8 | (long)JniIO.get(b, o + 6) & 0xFFL;
                }
                case 6: {
                    off[0] = off[0] + 8;
                    return ((long)JniIO.get(b, o + 1) & 0xFFL) << 48 | ((long)JniIO.get(b, o + 2) & 0xFFL) << 40 | ((long)JniIO.get(b, o + 3) & 0xFFL) << 32 | ((long)JniIO.get(b, o + 4) & 0xFFL) << 24 | ((long)JniIO.get(b, o + 5) & 0xFFL) << 16 | ((long)JniIO.get(b, o + 6) & 0xFFL) << 8 | (long)JniIO.get(b, o + 7) & 0xFFL;
                }
                case 7: {
                    off[0] = off[0] + 9;
                    return ((long)JniIO.get(b, o + 1) & 0xFFL) << 56 | ((long)JniIO.get(b, o + 2) & 0xFFL) << 48 | ((long)JniIO.get(b, o + 3) & 0xFFL) << 40 | ((long)JniIO.get(b, o + 4) & 0xFFL) << 32 | ((long)JniIO.get(b, o + 5) & 0xFFL) << 24 | ((long)JniIO.get(b, o + 6) & 0xFFL) << 16 | ((long)JniIO.get(b, o + 7) & 0xFFL) << 8 | (long)JniIO.get(b, o + 8) & 0xFFL;
                }
            }
            throw new IllegalArgumentException("\u4e0d\u6b63\u306abyte8Long\u6761\u4ef6:" + off[0]);
        }
        switch ((h & 0xE0) >> 5) {
            case 0: {
                off[0] = off[0] + 1;
                return h & 0x1F;
            }
            case 1: {
                off[0] = off[0] + 2;
                return (h & 0x1F) << 8 | JniIO.get(b, o + 1) & 0xFF;
            }
            case 2: {
                off[0] = off[0] + 3;
                return (h & 0x1F) << 16 | (JniIO.get(b, o + 1) & 0xFF) << 8 | JniIO.get(b, o + 2) & 0xFF;
            }
            case 3: {
                off[0] = off[0] + 4;
                return (h & 0x1F) << 24 | (JniIO.get(b, o + 1) & 0xFF) << 16 | (JniIO.get(b, o + 2) & 0xFF) << 8 | JniIO.get(b, o + 3) & 0xFF;
            }
            case 4: {
                off[0] = off[0] + 5;
                return ((long)h & 0x1FL) << 32 | ((long)JniIO.get(b, o + 1) & 0xFFL) << 24 | ((long)JniIO.get(b, o + 2) & 0xFFL) << 16 | ((long)JniIO.get(b, o + 3) & 0xFFL) << 8 | (long)JniIO.get(b, o + 4) & 0xFFL;
            }
            case 5: {
                off[0] = off[0] + 6;
                return ((long)h & 0x1FL) << 40 | ((long)JniIO.get(b, o + 1) & 0xFFL) << 32 | ((long)JniIO.get(b, o + 2) & 0xFFL) << 24 | ((long)JniIO.get(b, o + 3) & 0xFFL) << 16 | ((long)JniIO.get(b, o + 4) & 0xFFL) << 8 | (long)JniIO.get(b, o + 5) & 0xFFL;
            }
            case 6: {
                off[0] = off[0] + 7;
                return ((long)h & 0x1FL) << 48 | ((long)JniIO.get(b, o + 1) & 0xFFL) << 40 | ((long)JniIO.get(b, o + 2) & 0xFFL) << 32 | ((long)JniIO.get(b, o + 3) & 0xFFL) << 24 | ((long)JniIO.get(b, o + 4) & 0xFFL) << 16 | ((long)JniIO.get(b, o + 5) & 0xFFL) << 8 | (long)JniIO.get(b, o + 6) & 0xFFL;
            }
            case 7: {
                off[0] = off[0] + 8;
                return ((long)h & 0x1FL) << 56 | ((long)JniIO.get(b, o + 1) & 0xFFL) << 48 | ((long)JniIO.get(b, o + 2) & 0xFFL) << 40 | ((long)JniIO.get(b, o + 3) & 0xFFL) << 32 | ((long)JniIO.get(b, o + 4) & 0xFFL) << 24 | ((long)JniIO.get(b, o + 5) & 0xFFL) << 16 | ((long)JniIO.get(b, o + 6) & 0xFFL) << 8 | (long)JniIO.get(b, o + 7) & 0xFFL;
            }
        }
        throw new IllegalArgumentException("\u4e0d\u6b63\u306abyte8Long\u6761\u4ef6:" + off[0]);
    }

    public static final String byteString(long b, int[] pos) throws Exception {
        int len = ValueBinary.byte4Int(b, pos);
        if (len == 0) {
            return "";
        }
        byte[] bb = new byte[len];
        JniIO.getBinary(b, pos[0], bb, 0, len);
        String ret = new String(bb, "UTF8");
        pos[0] = pos[0] + len;
        return ret;
    }

    public static final Object byteSerial(long b, int[] pos) throws Exception {
        int len = ValueBinary.byte4Int(b, pos);
        if (len == 0) {
            return null;
        }
        byte[] bb = new byte[len];
        JniIO.getBinary(b, pos[0], bb, 0, len);
        Serializable ret = ValueBinary.toObject(bb, 0, len);
        pos[0] = pos[0] + len;
        return ret;
    }

    protected static final Serializable toObject(byte[] bin, int off, int len) throws Exception {
        if (bin == null || bin.length <= 0) {
            throw new IllegalArgumentException("\u30b7\u30ea\u30a2\u30e9\u30a4\u30ba\u5fa9\u5143\u306e\u30d0\u30a4\u30ca\u30ea\u9577\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        ObjectInputStream in = null;
        Serializable ret = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(bin, off, len));
            ret = (Serializable)in.readObject();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            in = null;
        }
        return ret;
    }

    public static final Object decodeObject(int[] pos, JniBuffer b, int length) throws Exception {
        if (length <= pos[0]) {
            throw new IOException("\u6307\u5b9a\u9577[" + length + "byte]\u3092\u8d8a\u3048\u3066\u3001\u51e6\u7406\u3092\u884c\u304a\u3046\u3068\u3057\u3066\u3044\u307e\u3059:" + pos[0]);
        }
        long addr = b.address();
        int code = ValueBinary.byte1Int(addr, pos);
        switch (code) {
            case 1: {
                return ValueBinary.byteString(addr, pos);
            }
            case 2: {
                Boolean ret = ValueBinary.byte1Int(addr, pos) == 1;
                return ret;
            }
            case 3: {
                Character ret = Character.valueOf((char)ValueBinary.byte2Int(addr, pos));
                return ret;
            }
            case 4: {
                Byte ret = (byte)ValueBinary.byte1Int(addr, pos);
                return ret;
            }
            case 5: {
                Short ret = (short)ValueBinary.byte2Int(addr, pos);
                return ret;
            }
            case 6: {
                Integer ret = ValueBinary.byte4Int(addr, pos);
                return ret;
            }
            case 7: {
                Long ret = ValueBinary.byte8Long(addr, pos);
                return ret;
            }
            case 8: {
                Float ret = Float.valueOf(Float.intBitsToFloat(ValueBinary.byte4Int(addr, pos)));
                return ret;
            }
            case 9: {
                Double ret = Double.longBitsToDouble(ValueBinary.byte8Long(addr, pos));
                return ret;
            }
            case 10: {
                AtomicInteger ret = new AtomicInteger(ValueBinary.byte4Int(addr, pos));
                return ret;
            }
            case 11: {
                AtomicLong ret = new AtomicLong(ValueBinary.byte8Long(addr, pos));
                return ret;
            }
            case 12: {
                return new BigDecimal(ValueBinary.byteString(addr, pos));
            }
            case 13: {
                return new BigInteger(ValueBinary.byteString(addr, pos));
            }
            case 14: {
                int type = ValueBinary.byte1Int(addr, pos);
                java.util.Date ret = type == 1 ? new Date(ValueBinary.byte8Long(addr, pos)) : (type == 2 ? new Time(ValueBinary.byte8Long(addr, pos)) : (type == 3 ? new Timestamp(ValueBinary.byte8Long(addr, pos)) : new java.util.Date(ValueBinary.byte8Long(addr, pos))));
                return ret;
            }
            case 20: {
                int len = ValueBinary.byte4Int(addr, pos);
                boolean[] lst = new boolean[len];
                int i = 0;
                while (i < len) {
                    lst[i] = ValueBinary.byte1Int(addr, pos) == 1;
                    ++i;
                }
                return lst;
            }
            case 21: {
                int len = ValueBinary.byte4Int(addr, pos);
                byte[] lst = new byte[len];
                JniIO.getBinary(addr, pos[0], lst, 0, len);
                pos[0] = pos[0] + len;
                return lst;
            }
            case 22: {
                int len = ValueBinary.byte4Int(addr, pos);
                char[] lst = new char[len];
                int i = 0;
                while (i < len) {
                    lst[i] = (char)ValueBinary.byte2Int(addr, pos);
                    ++i;
                }
                return lst;
            }
            case 23: {
                int len = ValueBinary.byte4Int(addr, pos);
                short[] lst = new short[len];
                int i = 0;
                while (i < len) {
                    lst[i] = (short)ValueBinary.byte2Int(addr, pos);
                    ++i;
                }
                return lst;
            }
            case 24: {
                int len = ValueBinary.byte4Int(addr, pos);
                int[] lst = new int[len];
                int i = 0;
                while (i < len) {
                    lst[i] = ValueBinary.byte4Int(addr, pos);
                    ++i;
                }
                return lst;
            }
            case 25: {
                int len = ValueBinary.byte4Int(addr, pos);
                long[] lst = new long[len];
                int i = 0;
                while (i < len) {
                    lst[i] = ValueBinary.byte8Long(addr, pos);
                    ++i;
                }
                return lst;
            }
            case 26: {
                int len = ValueBinary.byte4Int(addr, pos);
                float[] lst = new float[len];
                int i = 0;
                while (i < len) {
                    lst[i] = Float.intBitsToFloat(ValueBinary.byte4Int(addr, pos));
                    ++i;
                }
                return lst;
            }
            case 27: {
                int len = ValueBinary.byte4Int(addr, pos);
                double[] lst = new double[len];
                int i = 0;
                while (i < len) {
                    lst[i] = Double.longBitsToDouble(ValueBinary.byte8Long(addr, pos));
                    ++i;
                }
                return lst;
            }
            case 28: {
                int len = ValueBinary.byte4Int(addr, pos);
                String[] lst = new String[len];
                int i = 0;
                while (i < len) {
                    lst[i] = ValueBinary.byteString(addr, pos);
                    ++i;
                }
                return lst;
            }
            case 50: {
                Object[] lst;
                String cls = ValueBinary.byteString(addr, pos);
                int len = ValueBinary.byte4Int(addr, pos);
                if (cls.length() == 0) {
                    Object[] n = new Object[len];
                    int i = 0;
                    while (i < len) {
                        n[i] = ValueBinary.decodeObject(pos, b, length);
                        ++i;
                    }
                    lst = n;
                } else {
                    lst = Array.newInstance(Class.forName(cls), len);
                    int i = 0;
                    while (i < len) {
                        Array.set(lst, i, ValueBinary.decodeObject(pos, b, length));
                        ++i;
                    }
                }
                return lst;
            }
            case 51: {
                int len = ValueBinary.byte4Int(addr, pos);
                ArrayList<Object> lst = new ArrayList<Object>();
                int i = 0;
                while (i < len) {
                    lst.add(ValueBinary.decodeObject(pos, b, length));
                    ++i;
                }
                return lst;
            }
            case 52: {
                int len = ValueBinary.byte4Int(addr, pos);
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                int i = 0;
                while (i < len) {
                    map.put(ValueBinary.decodeObject(pos, b, length), ValueBinary.decodeObject(pos, b, length));
                    ++i;
                }
                return map;
            }
            case 53: {
                HashSet<Object> set = new HashSet<Object>();
                int len = ValueBinary.byte4Int(addr, pos);
                int i = 0;
                while (i < len) {
                    set.add(ValueBinary.decodeObject(pos, b, length));
                    ++i;
                }
                return set;
            }
            case 60: {
                return ValueBinary.byteSerial(addr, pos);
            }
            case 255: {
                return null;
            }
        }
        throw new IOException("\u4e0d\u660e\u306a\u30bf\u30a4\u30d7[" + code + "]\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
    }

    protected static final int nlzs(int x) {
        if (x == 0) {
            return 0;
        }
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        x = (x & 0x55555555) + (x >> 1 & 0x55555555);
        x = (x & 0x33333333) + (x >> 2 & 0x33333333);
        x = (x & 0xF0F0F0F) + (x >> 4 & 0xF0F0F0F);
        x = (x & 0xFF00FF) + (x >> 8 & 0xFF00FF);
        return (x & 0xFFFF) + (x >> 16 & 0xFFFF);
    }

    protected static final int nlzs(long x) {
        int xx = (int)((x & 0xFFFFFFFF00000000L) >> 32);
        if (ValueBinary.nlzs(xx) == 0) {
            return ValueBinary.nlzs((int)(x & 0xFFFFFFFFFFFFFFFFL));
        }
        return ValueBinary.nlzs(xx) + 32;
    }
}

