/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.leveldb;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.maachang.leveldb.JniBuffer;
import org.maachang.leveldb.LevelMap;
import org.maachang.leveldb.LeveldbException;
import org.maachang.leveldb.WriteBatch;

public class WriteBatchMap
implements Map<String, Object> {
    protected LevelMap src = null;
    protected WriteBatch batch = null;

    protected WriteBatchMap() {
    }

    protected WriteBatchMap(LevelMap map) {
        this.src = map;
    }

    protected final void finalize() throws Exception {
        this.clear();
    }

    public final void clearCache() {
        this.src.clearCache();
    }

    @Override
    public final void clear() {
        if (this.batch != null) {
            this.batch.close();
            this.batch = null;
        }
    }

    public final void write() {
        if (this.batch != null) {
            try {
                this.batch.write(this.src.leveldb);
            }
            finally {
                this.clear();
            }
        }
    }

    protected final void writeBatch() {
        if (this.batch == null) {
            this.batch = new WriteBatch();
        }
    }

    @Override
    public final void putAll(Map toMerge) {
        if (toMerge.size() > 0) {
            for (Object k : toMerge.keySet()) {
                if (!(k instanceof String)) continue;
                this.put((String)k, toMerge.get(k));
            }
        }
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.src.containsValue(value);
    }

    @Override
    public Set entrySet() {
        return this.src.entrySet();
    }

    @Override
    public Collection values() {
        return this.src.values();
    }

    @Override
    public final Object put(String name, Object value) {
        if (name == null) {
            return null;
        }
        if (value != null && value instanceof LevelMap) {
            throw new LeveldbException("\u8981\u7d20\u306bLevelMap\u8981\u7d20\u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093");
        }
        this.writeBatch();
        try {
            JniBuffer keyBuf = LevelMap.getKeyBuffer(name);
            JniBuffer valBuf = LevelMap.getValueBuffer(value);
            this.batch.put(keyBuf, valBuf);
            keyBuf.clear();
            valBuf.clear();
            return null;
        }
        catch (LeveldbException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LeveldbException(e);
        }
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.src.containsKey(key);
    }

    @Override
    public final Object get(Object key) {
        return this.src.get(key);
    }

    @Override
    public final Object remove(Object key) {
        if (key == null) {
            return false;
        }
        this.writeBatch();
        try {
            JniBuffer keyBuf = LevelMap.getKeyBuffer((String)key);
            this.batch.remove(keyBuf);
            keyBuf.clear();
            return null;
        }
        catch (LeveldbException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LeveldbException(e);
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.src.isEmpty();
    }

    @Override
    public final Set keySet() {
        return this.src.keySet();
    }

    @Override
    public final int size() {
        return this.src.size();
    }

    public final void getAllKey(Set<Object> set) {
        this.src.getAllKey(set);
    }

    public final void getAllValues(Set<Object> set) {
        this.src.getAllValues(set);
    }

    public final String toString() {
        return this.src.toString();
    }
}

