/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.leveldb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;

class jni {
    public static final String VERSION = "1.01";
    public static final String LIB_NAME = "leveldb";
    public static final String LIB_BIT_32 = "32-";
    public static final String LIB_BIT_64 = "64-";
    public static final String WINDOWS_LIB_PLUS = ".dll";
    public static final String LINUX_LIB_PLUS = ".so";
    public static final String MAC_LIB_PLUS = ".dylib";
    public static final String NATIVE_PACKAGE = "org/maachang/leveldb/native/";
    public static final String DEFAULT_DIR = ".lib_work";
    private static volatile boolean initFlag = false;

    static {
        String arm = System.getProperty("os.arch");
        if (arm.startsWith("arm")) {
            System.load(jni.targetDynamincLib(true, LIB_NAME + "-" + LIB_BIT_32 + "arm-" + VERSION + LINUX_LIB_PLUS));
            initFlag = true;
        } else {
            String name = LIB_NAME;
            StringBuilder libBuf = new StringBuilder().append(name).append("-");
            String osName = jni.getOsName();
            int bit = jni.getOsBit();
            if (bit == -1) {
                System.err.println("JavaVM\u6761\u4ef6\u306e\u53d6\u5f97\u306b\u5931\u6557");
                System.exit(-1);
            }
            if ("windows".equals(osName) || "linux".equals(osName)) {
                if (bit == 32) {
                    libBuf.append(LIB_BIT_32);
                } else if (bit == 64) {
                    libBuf.append(LIB_BIT_64);
                }
            }
            String lib = libBuf.append(VERSION).toString();
            libBuf = null;
            if ("windows".equals(osName)) {
                lib = String.valueOf(lib) + WINDOWS_LIB_PLUS;
                System.load(jni.targetDynamincLib(true, lib));
                initFlag = true;
            } else if ("linux".equals(osName)) {
                lib = String.valueOf(lib) + LINUX_LIB_PLUS;
                System.load(jni.targetDynamincLib(true, lib));
                initFlag = true;
            } else if ("mac".equals(osName) && bit == 64) {
                lib = String.valueOf(lib) + MAC_LIB_PLUS;
                System.load(jni.targetDynamincLib(true, lib));
                initFlag = true;
            } else {
                System.err.println("NativeIO\u521d\u671f\u5316\u51e6\u7406\u5931\u6557(unknown)");
                System.exit(-1);
            }
        }
    }

    private jni() {
    }

    protected static final boolean isInit() {
        return initFlag;
    }

    protected static final byte[] nativeString(String s) {
        if (s == null || (s = s.trim()).length() <= 0) {
            return new byte[1];
        }
        byte[] b = s.getBytes();
        int len = b.length;
        byte[] ret = new byte[len + 1];
        System.arraycopy(b, 0, ret, 0, len);
        ret[len] = 0;
        return ret;
    }

    private static final String targetDynamincLib(boolean mode, String lib) {
        String sp = System.getProperty("file.separator");
        File targetDir = null;
        targetDir = new File(System.getProperty("user.home") + sp + DEFAULT_DIR);
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        File outFile = new File(targetDir, lib);
        if (mode) {
            BufferedInputStream is;
            String ntvDir = NATIVE_PACKAGE;
            if (!(ntvDir = ntvDir.trim()).endsWith("/")) {
                ntvDir = String.valueOf(ntvDir) + "/";
            }
            if (ntvDir.startsWith("/")) {
                ntvDir = ntvDir.substring(1);
            }
            if (jni.isLibFile(outFile, is = new BufferedInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream(String.valueOf(ntvDir) + lib)))) {
                try {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFile));
                    try {
                        try {
                            int n;
                            byte[] b = new byte[4096];
                            while ((n = ((InputStream)is).read(b)) > 0) {
                                ((OutputStream)os).write(b, 0, n);
                            }
                            ((OutputStream)os).flush();
                            ((OutputStream)os).close();
                            os = null;
                            ((InputStream)is).close();
                            is = null;
                        }
                        finally {
                            if (is != null) {
                                ((InputStream)is).close();
                                is = null;
                            }
                        }
                    }
                    finally {
                        if (os != null) {
                            ((OutputStream)os).close();
                            os = null;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    outFile = null;
                }
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                is = null;
            }
        }
        if (outFile != null) {
            return outFile.getAbsolutePath();
        }
        return null;
    }

    private static final boolean isLibFile(File f, InputStream in) {
        boolean ret = false;
        try {
            int len;
            ret = !f.exists() ? true : (len = (int)f.length()) <= 0 || len != in.available();
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public static final String fullPath(String path) throws IOException {
        return new File(path).getCanonicalPath();
    }

    private static final String getOsName() {
        String pathSp = System.getProperty("path.separator");
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        if (pathSp.equals(";")) {
            return "windows";
        }
        if (pathSp.equals(":")) {
            if (osName.indexOf("mac") > -1) {
                return "mac";
            }
            return "linux";
        }
        return "unknown";
    }

    private static final int getOsBit() {
        String os = System.getProperty("sun.arch.data.mode");
        if (os != null && (os = os.trim()).length() > 0) {
            if ("32".equals(os)) {
                return 32;
            }
            if ("64".equals(os)) {
                return 64;
            }
        }
        if ((os = System.getProperty("os.arch")) == null || (os = os.trim()).length() <= 0) {
            return -1;
        }
        if (os.endsWith("32")) {
            return 32;
        }
        if (os.endsWith("64")) {
            return 64;
        }
        return 32;
    }

    protected static native long malloc(int var0);

    protected static native long realloc(long var0, int var2);

    protected static native void free(long var0);

    protected static native void memset(long var0, byte var2, int var3);

    protected static native void memcpy(long var0, long var2, int var4);

    protected static native byte getByte(long var0);

    protected static native void putByte(long var0, byte var2);

    protected static native void getBinary(long var0, byte[] var2, int var3, int var4);

    protected static native void putBinary(long var0, byte[] var2, int var3, int var4);

    protected static native void putChar(long var0, char var2);

    protected static native char getChar(long var0);

    protected static native void putShort(long var0, short var2);

    protected static native short getShort(long var0);

    protected static native void putInt(long var0, int var2);

    protected static native int getInt(long var0);

    protected static native void putLong(long var0, long var2);

    protected static native long getLong(long var0);

    protected static native int eq(long var0, long var2, int var4);

    protected static native int snappyMaxCompressedLength(int var0);

    protected static native int snappyCompress(long var0, int var2, long var3, int[] var5);

    protected static native int snappyDecompress(long var0, int var2, long var3, int[] var5);

    protected static native void leveldb_destroy(long var0, int var2, int var3, int var4, int var5);

    protected static native void leveldb_repair(long var0, int var2, int var3, int var4, int var5);

    protected static native long leveldb_open(long var0, int var2, int var3, int var4, int var5);

    protected static native void leveldb_close(long var0);

    protected static native int leveldb_put(long var0, long var2, int var4, long var5, int var7);

    protected static native int leveldb_get(long var0, long var2, int var4, long[] var5, int var6);

    protected static native int leveldb_remove(long var0, long var2, int var4);

    protected static native long leveldb_iterator(long var0);

    protected static native int leveldb_property(long var0, long var2, int var4, long[] var5, int var6);

    protected static native void leveldb_itr_delete(long var0);

    protected static native void leveldb_itr_first(long var0);

    protected static native void leveldb_itr_last(long var0);

    protected static native void leveldb_itr_seek(long var0, long var2, int var4);

    protected static native int leveldb_itr_valid(long var0);

    protected static native void leveldb_itr_next(long var0);

    protected static native int leveldb_itr_key(long var0, long[] var2, int var3);

    protected static native int leveldb_itr_value(long var0, long[] var2, int var3);

    protected static native long leveldb_wb_create();

    protected static native void leveldb_wb_destroy(long var0);

    protected static native void leveldb_wb_put(long var0, long var2, int var4, long var5, int var7);

    protected static native void leveldb_wb_remove(long var0, long var2, int var4);

    protected static native int leveldb_wb_flush(long var0, long var2);
}

