package org.seasar.dao.interceptors;

import java.lang.reflect.Method;

import javax.sql.DataSource;

import org.aopalliance.intercept.MethodInvocation;
import org.seasar.dao.DaoMetaData;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.meta.DaoMetaDataFactory;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.util.MethodUtil;

/**
 * @author higa
 *
 */
public class S2DaoInterceptor extends AbstractInterceptor {

	private DataSource dataSource_;
	
	public S2DaoInterceptor(DataSource dataSource) {
		dataSource_ = dataSource;
	}

	/**
	 * @see org.aopalliance.intercept.MethodInterceptor#invoke(org.aopalliance.intercept.MethodInvocation)
	 */
	public Object invoke(MethodInvocation invocation) throws Throwable {
		Method method = invocation.getMethod();
		if (!MethodUtil.isAbstract(method)) {
			return invocation.proceed();
		}
		Class daoClass = getTargetClass(invocation);
		DaoMetaData dmd = DaoMetaDataFactory.getDaoMetaData(daoClass);
		SqlCommand cmd = dmd.getSqlCommand(method.getName()); 
		return cmd.execute(dataSource_, invocation.getArguments());
	}
}
