package test.org.seasar.dao.interceptors;

import java.util.List;

import org.seasar.extension.unit.S2TestCase;

/**
 * @author higa
 *
 */
public class S2DaoInterceptorTest extends S2TestCase {

	private EmployeeDao dao_;
	/**
	 * Constructor for InvocationImplTest.
	 * @param arg0
	 */
	public S2DaoInterceptorTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(S2DaoInterceptorTest.class);
	}
	
	public void setUp() {
		include("j2ee.dicon");
		include("EmployeeDao.dicon");
	}

	public void testSelectBeanList() throws Exception {
		List employees = dao_.getAllEmployees();
		for (int i = 0; i < employees.size(); ++i) {
			System.out.println(employees.get(i));
		}
		assertEquals("1", true, employees.size() > 0);
	}
	
	public void testSelectBean() throws Exception {
		Employee employee = dao_.getEmployee(7788);
		System.out.println(employee);
		assertEquals("1", "SCOTT", employee.getEname());
	}
	
	public void testSelectObject() throws Exception {
		int count = dao_.getCount();
		System.out.println("count:" + count);
		assertEquals("1", true, count > 0);
	}

	public void testUpdateTx() throws Exception {
		Employee employee = dao_.getEmployee(7788);
		assertEquals("1", 1, dao_.update(employee));
	}

}